/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.tools.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.UserTarget;
import org.snmp4j.asn1.BER;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.TSM;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.DtlsAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.tools.console.TableFormatter;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DTLSTM;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.TransportListener;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;
import org.snmp4j.version.VersionInfo;

public class SnmpCommand
implements Runnable,
CommandResponder,
TransportListener {
    private static final String OPTIONS = "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] ";
    private static final String CONSOLE_OPTIONS = "+w[i{=79}] +h[i{=0}] ";
    private static final String V3_AUTH_PRIV_PROTOCOL = "+a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] ";
    private static final String V3_OPTIONS = "+a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] ";
    private static final String TRAP_OPTIONS = "+Ta[s{=0.0.0.0}<(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}>] -To[s{=1.3.6.1.6.3.1.1.5.1}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Te[s{=0.0}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Ts[i{=0}] +Tg[i{=0}] +Tu[l{=0}] ";
    private static final String TLS_OPTIONS = "+tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword ";
    private static final String SNMP_OPTIONS = "+b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p ";
    private static final String SNMPV3_ONLY_OPTIONS = "+c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<3>] +Ors[i{=65535}] +p ";
    private static final String BULK_OPTIONS = "-Cr[i{=10}] -Cn[i{=0}] ";
    private static final String TABLE_OPTIONS = "+Cil[s] +Ciu[s] +Ch +Ci +Cl +Cw[i] +Cf[s] +Cc[i] +Otd +OtCSV +OttCSV ";
    private static final String WALK_OPTIONS = "+ilo ";
    private static final String ADDRESS_PARAMETER = "#address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] ";
    private static final String OID_PARAMETER = "#OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] ";
    private static final String OPT_OID_PARAMETER = "+OID[s<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.#]*(=(\\{[iusxdnotab]\\})?.*)?>] ";
    private static final String OIDLIST_PARAMETER = "#OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] .. ";
    private static final String OPT_OIDLIST_PARAMETER = "+OID[s<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.#]*(=(\\{[iusxdnotab]\\})?.*)?>] .. ";
    private static final String ALL_OPTIONS = "+w[i{=79}] +h[i{=0}] +d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword +Ta[s{=0.0.0.0}<(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}>] -To[s{=1.3.6.1.6.3.1.1.5.1}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Te[s{=0.0}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Ts[i{=0}] +Tg[i{=0}] +Tu[l{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p -Cr[i{=10}] -Cn[i{=0}] +Cil[s] +Ciu[s] +Ch +Ci +Cl +Cw[i] +Cf[s] +Cc[i] +Otd +OtCSV +OttCSV +ilo ";
    private static final String[][] COMMANDS;
    private static final int DEFAULT = 0;
    private static final int WALK = 1;
    private static final int LISTEN = 2;
    private static final int TABLE = 3;
    private static final int CVS_TABLE = 4;
    private static final int TIME_BASED_CVS_TABLE = 5;
    private static final int SNAPSHOT_CREATION = 6;
    private static final int SNAPSHOT_DUMP = 7;
    private static final int OID_FIND = 8;
    private static final int SMI_DUMP = 9;
    private static final int OP_USM_USER = 10;
    private static final int OP_USM_KEY = 11;
    private static final int OP_USM_DH_KEY = 12;
    private static final int OP_USM_DH_KICKSTART_INIT = 13;
    private static final int OP_USM_DH_KICKSTART_RUN = 14;
    private static boolean packetDumpEnabled;
    Target<?> target;
    OID authProtocol;
    OID privProtocol;
    OctetString privPassphrase;
    OctetString authPassphrase;
    OctetString community = new OctetString("public");
    OctetString authoritativeEngineID;
    OctetString contextEngineID;
    OctetString contextName = new OctetString();
    OctetString securityName = new OctetString();
    OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    TimeTicks sysUpTime = new TimeTicks(0L);
    OID trapOID = SnmpConstants.coldStart;
    int version = 3;
    int engineBootCount = 0;
    int retries = 1;
    int timeout = 1000;
    int pduType = -95;
    int maxSizeResponsePDU = 65535;
    Vector<VariableBinding> vbs = new Vector();
    File snapshotFile;
    protected int operation = 0;
    int numDispatcherThreads = 2;
    boolean useDenseTableOperation = false;
    private static int stdoutWidth;
    OID lowerBoundIndex;
    OID upperBoundIndex;
    PDUFactory pduFactory;
    Snmp snmp;
    Map<String, List<Object>> settings;
    String command;
    private static PrintStream err;
    private static PrintStream out;
    private static ResourceBundle help;
    private static int[] tabs;
    private static boolean silent;
    private int returnCode = 0;

    public SnmpCommand(String command, Map<String, List<Object>> args2) throws IOException {
        this.command = command;
        this.settings = args2;
        if (!("help".equals(command) || "example".equals(command) || "license".equals(command) || "oid".equals(command) || "smi".equals(command))) {
            if ("usmUser".equals(command) || "usmKey".equals(command) || "usmDHKey".equals(command) || "usmDHKickstartRun".equals(command)) {
                args2.put("v", Collections.singletonList("3"));
            }
            SnmpConfigurator snmpConfig = new SnmpConfigurator();
            this.target = snmpConfig.getTarget(args2);
            Address bindAddress = snmpConfig.getBindAddress(args2);
            AbstractTransportMapping transport = null;
            if (bindAddress == null) {
                transport = this.target.getAddress() instanceof TlsAddress ? new TLSTM() : (this.target.getAddress() instanceof DtlsAddress ? new DTLSTM() : (this.target.getAddress() instanceof TcpAddress ? new DefaultTcpTransportMapping() : new DefaultUdpTransportMapping()));
            } else if (this.target.getAddress() != null && bindAddress.getClass().equals(this.target.getAddress().getClass())) {
                transport = this.target.getAddress() instanceof TlsAddress ? new TLSTM((TlsAddress)bindAddress) : (this.target.getAddress() instanceof DtlsAddress ? new DTLSTM((DtlsAddress)bindAddress) : (this.target.getAddress() instanceof TcpAddress ? new DefaultTcpTransportMapping((TcpAddress)bindAddress) : new DefaultUdpTransportMapping((UdpAddress)bindAddress)));
            } else {
                System.err.println("Bind address type " + String.valueOf(bindAddress) + " does not match target address type " + String.valueOf(this.target.getAddress()) + ", aborting");
                System.exit(2);
            }
            if (args2.containsKey("p")) {
                packetDumpEnabled = true;
            }
            SNMP4JSettings.setReportSecurityLevelStrategy(SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded);
            if (args2.containsKey("rsl")) {
                String strategy = (String)ArgumentParser.getValue(this.settings, "rsl", 0);
                if (strategy != null && "basic".indexOf(strategy) == 0) {
                    SNMP4JSettings.setReportSecurityLevelStrategy(SNMP4JSettings.ReportSecurityLevelStrategy.standard);
                } else if (strategy != null && "secure".indexOf(strategy) == 0) {
                    SNMP4JSettings.setReportSecurityLevelStrategy(SNMP4JSettings.ReportSecurityLevelStrategy.neverNoAuthNoPriv);
                }
            }
            CounterSupport.getInstance().addCounterListener(new DefaultCounterListener());
            SnmpCommandMessageDispatcher bmd = new SnmpCommandMessageDispatcher();
            bmd.addCommandResponder(this);
            bmd.addMessageProcessingModel(new MPv2c());
            bmd.addMessageProcessingModel(new MPv1());
            bmd.addMessageProcessingModel(new MPv3());
            SecurityProtocols.getInstance().addDefaultProtocols();
            SecurityProtocols.getInstance().addPrivacyProtocol(new PrivAES256With3DESKeyExtension());
            SecurityProtocols.getInstance().addPrivacyProtocol(new PrivAES192With3DESKeyExtension());
            this.snmp = new Snmp(bmd, transport);
            if (args2.containsKey("v") && "3".equals(ArgumentParser.getValue(this.settings, "v", 0))) {
                MPv3 mpv3 = (MPv3)this.snmp.getMessageProcessingModel(3);
                if (this.target.getSecurityModel() == 3) {
                    SecurityModels.getInstance().addSecurityModel(new USM(SecurityProtocols.getInstance(), new OctetString(mpv3.getLocalEngineID()), 0));
                } else if (this.target.getSecurityModel() == 4) {
                    OctetString localEngineID = SnmpConfigurator.createOctetString((String)ArgumentParser.getValue(this.settings, "l", 0), null);
                    if (localEngineID == null) {
                        SecurityModels.getInstance().addSecurityModel(new TSM(new OctetString(mpv3.getLocalEngineID()), false));
                    } else {
                        SecurityModels.getInstance().addSecurityModel(new TSM(localEngineID, false));
                    }
                }
            }
            snmpConfig.configure(this.snmp, args2);
            this.snmp.listen();
            this.pduType = PDU.getTypeFromString(command.toUpperCase());
            if (this.pduType == Integer.MIN_VALUE) {
                this.pduType = -95;
            }
            args2.put("o", Arrays.asList(PDU.getTypeString(this.pduType)));
            this.pduFactory = snmpConfig.getPDUFactory(args2);
            this.pduType = this.pduFactory.createPDU(this.target).getType();
            this.assignOptions(args2);
        }
    }

    private void assignOptions(Map<String, List<Object>> args2) {
        if ("walk".equals(this.command)) {
            this.operation = 1;
        } else if ("create-snapshot".equals(this.command)) {
            this.operation = 6;
            this.snapshotFile = new File((String)ArgumentParser.getValue(args2, "file", 0));
            if (!this.snapshotFile.canWrite() && this.snapshotFile.exists()) {
                throw new IllegalArgumentException("Snapshot file '" + String.valueOf(this.snapshotFile) + "' cannot be written");
            }
        } else if ("dump-snapshot".equals(this.command)) {
            this.operation = 7;
            this.snapshotFile = new File((String)ArgumentParser.getValue(args2, "file", 0));
            if (!this.snapshotFile.canRead()) {
                throw new IllegalArgumentException("Snapshot file '" + String.valueOf(this.snapshotFile) + "' cannot be read");
            }
        } else if ("listen".equals(this.command)) {
            this.operation = 2;
        } else if ("table".equals(this.command)) {
            this.operation = 3;
            if (args2.containsKey("OtCSV")) {
                this.operation = 4;
            } else if (args2.containsKey("OttCSV")) {
                this.operation = 5;
            }
            if (args2.containsKey("Otd")) {
                this.useDenseTableOperation = true;
            }
        }
        this.parseOIDs(args2);
        this.checkTrapVariables(this.vbs, this.pduType, this.trapOID, this.sysUpTime);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void parseOIDs(Map<String, List<Object>> args) throws IllegalArgumentException {
        block25: {
            oids = args.get("OID");
            if (oids == null) break block25;
            i = 1;
            for (String oid : oids) {
                block26: {
                    type = 'i';
                    value = null;
                    equal = oid.indexOf("=");
                    if (equal <= 0) break block26;
                    type = oid.contains("={") == false ? '\u0000' : (char)oid.charAt(equal + 2);
                    value = oid.substring((type == '\u0000' ? equal : oid.indexOf(125)) + 1);
                    oid = oid.substring(0, equal);
                    ** GOTO lbl-1000
                }
                if (oid.indexOf(35) > oid.indexOf(58) + 1) {
                    st = new StringTokenizer(oid, "#");
                    if (st.countTokens() != 2) {
                        throw new IllegalArgumentException("Illegal OID range specified: '" + oid);
                    }
                    oid = st.nextToken();
                    vbLower = new VariableBinding(new OID(oid));
                    this.vbs.add(vbLower);
                    lastOID = new OID(st.nextToken());
                    last = lastOID.last();
                    first = vbLower.getOid().lastUnsigned();
                    for (k = first + 1L; k <= last; ++k) {
                        nextOID = new OID(vbLower.getOid().getValue(), 0, vbLower.getOid().size() - 1);
                        nextOID.appendUnsigned(k);
                        next = new VariableBinding(nextOID);
                        this.vbs.add(next);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    try {
                        o = new OID(oid);
                        vb = new VariableBinding(o);
                        if (type == '\u0000') {
                            variable /* !! */  = null;
                            try {
                                variable /* !! */  = SNMP4JSettings.getVariableTextFormat().parse(vb.getOid(), value);
                            }
                            catch (ParseException ex) {
                                ex.printStackTrace();
                            }
                            vb.setVariable(variable /* !! */ );
                        } else if (value != null) {
                            switch (type) {
                                case 'i': {
                                    variable /* !! */  = new Integer32(Integer.parseInt(value));
                                    break;
                                }
                                case 'u': {
                                    variable /* !! */  = new UnsignedInteger32(Long.parseLong(value));
                                    break;
                                }
                                case 's': {
                                    variable /* !! */  = new OctetString(value);
                                    break;
                                }
                                case 'x': {
                                    variable /* !! */  = OctetString.fromString(value, ':', 16);
                                    break;
                                }
                                case 'd': {
                                    variable /* !! */  = OctetString.fromString(value, '.', 10);
                                    break;
                                }
                                case 'b': {
                                    variable /* !! */  = OctetString.fromString(value, ' ', 2);
                                    break;
                                }
                                case 'n': {
                                    variable /* !! */  = new Null();
                                    break;
                                }
                                case 'o': {
                                    variable /* !! */  = new OID(value);
                                    break;
                                }
                                case 't': {
                                    variable /* !! */  = new TimeTicks(Long.parseLong(value));
                                    break;
                                }
                                case 'a': {
                                    variable /* !! */  = new IpAddress(value);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Variable type " + type + " not supported");
                                }
                            }
                            vb.setVariable(variable /* !! */ );
                        }
                        this.vbs.add(vb);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IllegalArgumentException("OID #" + i + "='" + oid + "': The value '" + value + "' could not be parsed");
                    }
                    catch (Exception pex) {
                        if (pex.getMessage() == null) ** GOTO lbl89
                        throw new IllegalArgumentException("OID #" + i + "='" + oid + "' could not be resolved" + (String)(pex.getMessage() != null ? ", reason: " + pex.getMessage() : ""));
                    }
                }
lbl89:
                // 3 sources

                ++i;
            }
        }
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    public String help(String prefix, String command, boolean listOptionsDetails, boolean withDescription) {
        if (prefix == null) {
            prefix = "";
        }
        StringBuffer buf = new StringBuffer();
        if (command == null || "all".equals(command)) {
            String usage = help.getString("usage.text");
            String version = VersionInfo.getVersion();
            buf.append(MessageFormat.format(usage, version));
            TreeMap<String, ArgumentParser.ArgumentFormat> options = new TreeMap<String, ArgumentParser.ArgumentFormat>();
            TreeMap<String, String[]> commands = new TreeMap<String, String[]>();
            for (String[] COMMAND : COMMANDS) {
                String c = COMMAND[0];
                String[] format = this.selectFormat(c);
                commands.put(c, format);
            }
            for (Map.Entry entry : commands.entrySet()) {
                String c = (String)entry.getKey();
                String[] format = (String[])entry.getValue();
                ArgumentParser p = new ArgumentParser(format[0], format[1]);
                Map<String, ArgumentParser.ArgumentFormat> o = p.getOptionFormat();
                options.putAll(o);
                buf.append(c).append(":\n");
                buf.append(this.help("", c, false, command != null));
                buf.append('\n');
            }
            buf.append("\n\nOPTIONS:\n");
            this.optionDetailList(SnmpCommand.getTabPosition(0), prefix, buf, options);
        } else {
            String syn = help.getString("command.syn." + prefix + command);
            String des = help.getString("command.des." + prefix + command);
            if (syn != null && des != null) {
                Object line = "";
                if (!"".equals(syn)) {
                    line = (String)line + SnmpCommand.tab(0, 0, 0) + syn;
                    line = (String)line + (withDescription ? "\n\n" : "\n");
                }
                if (withDescription) {
                    int firstLineIndent = 0;
                    if (((String)line).length() >= SnmpCommand.getTabPosition(0)) {
                        line = (String)line + "\n";
                        firstLineIndent = SnmpCommand.getTabPosition(0);
                    }
                    line = (String)line + SnmpCommand.format(SnmpCommand.getTabPosition(0), des, 0, firstLineIndent);
                }
                buf.append((String)line);
                buf.append('\n');
            }
            try {
                String subcmd = help.getString("command.sub." + prefix + command);
                String[] subcmds = subcmd.split(",");
                for (int i = 0; i < subcmds.length; ++i) {
                    if (i == 0) {
                        buf.append("\n");
                    }
                    buf.append(SnmpCommand.spaces(SnmpCommand.getTabPosition(0)));
                    buf.append(subcmds[i]).append(withDescription ? ":\n" : "");
                    buf.append(this.help(command + ".", subcmds[i], false, withDescription));
                }
            }
            catch (MissingResourceException subcmd) {
                // empty catch block
            }
            String od = "";
            if (listOptionsDetails) {
                od = this.options(SnmpCommand.getTabPosition(0), prefix, command);
            } else if ("".equals(prefix)) {
                od = this.optionList(SnmpCommand.getTabPosition(0), prefix, command);
            }
            if (od.length() > 0) {
                buf.append('\n');
                buf.append(SnmpCommand.spaces(SnmpCommand.getTabPosition(0)));
                buf.append("Options:\n");
                buf.append(od);
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public String example(String prefix, String command) {
        if (prefix == null) {
            prefix = "";
        }
        StringBuilder buf = new StringBuilder();
        String syn = help.getString("command.syn." + prefix + command);
        String des = help.getString("command.des." + prefix + command);
        String exa = null;
        try {
            exa = help.getString("command.exa." + prefix + command);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        Object line = syn;
        line = (String)line + "\n\n";
        line = (String)line + SnmpCommand.format(0, des, 0, 0);
        buf.append((String)line);
        String od = this.options(0, prefix, command);
        if (od.length() > 0) {
            buf.append('\n');
            buf.append("Options:\n");
            buf.append(od);
        }
        buf.append('\n');
        if (exa != null) {
            buf.append("Examples:\n");
            buf.append(SnmpCommand.format(0, exa, 0, 0));
        }
        return buf.toString();
    }

    private String optionList(int indentation, String prefix, String command) {
        if (prefix != null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String[] format = this.selectFormat(command);
        if (format == null) {
            return "";
        }
        ArgumentParser p = new ArgumentParser(format[0], format[1]);
        Map<String, ArgumentParser.ArgumentFormat> options = p.getOptionFormat();
        TreeMap<String, ArgumentParser.ArgumentFormat> soptions = new TreeMap<String, ArgumentParser.ArgumentFormat>(options);
        Iterator it = soptions.keySet().iterator();
        while (it.hasNext()) {
            String opt = (String)it.next();
            buf.append("-").append(opt);
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return SnmpCommand.format(indentation, buf.toString(), 0, 0);
    }

    private String options(int indentation, String prefix, String command) {
        StringBuffer buf = new StringBuffer();
        String[] format = this.selectFormat(command);
        if (format == null) {
            return "";
        }
        ArgumentParser p = new ArgumentParser(format[0], format[1]);
        Map<String, ArgumentParser.ArgumentFormat> options = p.getOptionFormat();
        TreeMap<String, ArgumentParser.ArgumentFormat> soptions = new TreeMap<String, ArgumentParser.ArgumentFormat>(options);
        this.optionDetailList(indentation, prefix, buf, soptions);
        return buf.toString();
    }

    private void optionDetailList(int indentation, String prefix, StringBuffer buf, SortedMap<String, ArgumentParser.ArgumentFormat> soptions) {
        for (String opt : soptions.keySet()) {
            String o = SnmpCommand.spaces(indentation) + "-" + opt;
            String optSyn = help.getString("options.syn." + opt);
            o = o + SnmpCommand.tab(indentation, o.length(), 2);
            o = o + optSyn;
            buf.append(prefix);
            buf.append(o);
            String optDesc = help.getString("options.des." + opt);
            buf.append(SnmpCommand.format(SnmpCommand.getTabPosition(3), optDesc, 3, o.length()));
            buf.append('\n');
        }
    }

    private String[] selectFormat(String command) {
        for (int i = 0; i < COMMANDS.length; ++i) {
            if (!COMMANDS[i][0].equals(command)) continue;
            return new String[]{COMMANDS[i][1], COMMANDS[i][2]};
        }
        return null;
    }

    private static String tab(int offset, int position, int tabNo) {
        StringBuffer buf = new StringBuffer();
        if (tabs == null) {
            String tabString = help.getString("tabs");
            String[] tabsArray = tabString.split(",");
            tabs = new int[tabsArray.length];
            for (int i = 0; i < tabsArray.length; ++i) {
                SnmpCommand.tabs[i] = Integer.parseInt(tabsArray[i]);
            }
        }
        int t = SnmpCommand.getTabPosition(tabNo);
        buf.append(SnmpCommand.spaces(Math.max(1, t + offset - position)));
        return buf.toString();
    }

    private static int getTabPosition(int tabNo) {
        return tabNo < tabs.length ? tabs[tabNo] : tabs[tabs.length - 1] + (tabNo - tabs.length) * 8;
    }

    private static String format(int indentation, String s, int tabNo, int firstLineOffset) {
        StringTokenizer st = new StringTokenizer(s, "\t\n", true);
        StringBuffer buf = new StringBuffer();
        int lineLength = firstLineOffset;
        boolean firstLine = true;
        int i = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if ("\t".equals(t)) {
                String spaces = SnmpCommand.tab(indentation, lineLength, tabNo++);
                buf.append(spaces);
                lineLength += spaces.length();
            } else if ("\n".equals(t)) {
                tabNo = 0;
                firstLine = false;
                lineLength = 0;
                buf.append("\n");
            } else {
                String l;
                if (firstLineOffset > 0 && firstLine) {
                    l = SnmpCommand.tab(0, firstLineOffset, tabNo);
                    buf.append(l);
                    lineLength += l.length();
                } else if (lineLength == 0 && indentation > 0) {
                    l = SnmpCommand.spaces(indentation);
                    buf.append(l);
                    lineLength += l.length();
                }
                buf.append(SnmpCommand.wrap(indentation, t, stdoutWidth, lineLength));
                lineLength += t.length();
            }
            ++i;
        }
        return buf.toString();
    }

    private static String wrap(int offset, String s, int maxLineLength, int firstLineOffset) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        StringBuilder buf = new StringBuilder(s.length());
        int ll = firstLineOffset;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (ll + t.length() > maxLineLength) {
                buf.append('\n');
                if (offset > 0) {
                    buf.append(SnmpCommand.spaces(offset));
                }
                if (!" ".equals(t)) {
                    buf.append(t);
                    ll = t.length() + offset;
                    continue;
                }
                ll = offset;
                continue;
            }
            buf.append(t);
            ll += t.length();
        }
        return buf.toString();
    }

    public static String spaces(int n) {
        StringBuilder buf = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public PDU send() throws IOException {
        PDU request = this.pduFactory.createPDU(this.target);
        for (VariableBinding vb : this.vbs) {
            request.add(vb);
        }
        PDU response = null;
        if (this.operation == 1 || this.operation == 6) {
            ArrayList<VariableBinding> snapshot = null;
            if (this.operation == 6) {
                snapshot = new ArrayList<VariableBinding>();
            }
            this.walk(this.snmp, request, this.target, snapshot);
            if (snapshot != null) {
                this.createSnapshot(snapshot);
            }
            return null;
        }
        long startTime = System.currentTimeMillis();
        ResponseEvent<?> responseEvent = this.snmp.send(request, this.target);
        if (responseEvent != null) {
            response = responseEvent.getResponse();
            err.println("Received response after " + (System.currentTimeMillis() - startTime) + " millis");
        }
        this.snmp.close();
        return response;
    }

    private void checkTrapVariables(List<VariableBinding> vbs, int pduType, OID trapOID, TimeTicks sysUpTime) {
        if (pduType == -90 || pduType == -89) {
            if (vbs.size() == 0 || vbs.size() >= 1 && !vbs.get(0).getOid().equals(SnmpConstants.sysUpTime)) {
                vbs.add(0, new VariableBinding(SnmpConstants.sysUpTime, sysUpTime));
            }
            if (vbs.size() == 1 || vbs.size() > 2 && !vbs.get(1).getOid().equals(SnmpConstants.snmpTrapOID)) {
                vbs.add(1, new VariableBinding(SnmpConstants.snmpTrapOID, trapOID));
            }
        }
    }

    protected static void printReport(PDU response) {
        if (response.size() < 1) {
            out.println("REPORT PDU does not contain a variable binding.");
            return;
        }
        VariableBinding vb = response.get(0);
        OID oid = vb.getOid();
        if (SnmpConstants.usmStatsUnsupportedSecLevels.equals(oid)) {
            out.print("REPORT: Unsupported Security Level.");
        } else if (SnmpConstants.usmStatsNotInTimeWindows.equals(oid)) {
            out.print("REPORT: Message not within time window.");
        } else if (SnmpConstants.usmStatsUnknownUserNames.equals(oid)) {
            out.print("REPORT: Unknown user name.");
        } else if (SnmpConstants.usmStatsUnknownEngineIDs.equals(oid)) {
            out.print("REPORT: Unknown engine id.");
        } else if (SnmpConstants.usmStatsWrongDigests.equals(oid)) {
            out.print("REPORT: Wrong digest.");
        } else if (SnmpConstants.usmStatsDecryptionErrors.equals(oid)) {
            out.print("REPORT: Decryption error.");
        } else if (SnmpConstants.snmpUnknownSecurityModels.equals(oid)) {
            out.print("REPORT: Unknown security model.");
        } else if (SnmpConstants.snmpInvalidMsgs.equals(oid)) {
            out.print("REPORT: Invalid message.");
        } else if (SnmpConstants.snmpUnknownPDUHandlers.equals(oid)) {
            out.print("REPORT: Unknown PDU handler.");
        } else if (SnmpConstants.snmpUnavailableContexts.equals(oid)) {
            out.print("REPORT: Unavailable context.");
        } else if (SnmpConstants.snmpUnknownContexts.equals(oid)) {
            out.print("REPORT: Unknown context.");
        } else {
            out.print("REPORT contains unknown OID (" + oid.toString() + ").");
        }
        out.println(" Current counter value is " + vb.getVariable().toString() + ".");
    }

    @Override
    public synchronized <A extends Address> void processPdu(CommandResponderEvent<A> e) {
        PDU command = e.getPDU();
        if (command != null && command.getType() != -89 && command.getType() != -92 && command.getType() != -88 && command.getType() != -94) {
            out.println(command.toString());
            command.setErrorIndex(0);
            command.setErrorStatus(0);
            command.setType(-94);
            StatusInformation statusInformation = new StatusInformation();
            StateReference<A> ref = e.getStateReference();
            try {
                e.getMessageDispatcher().returnResponsePdu(e.getMessageProcessingModel(), e.getSecurityModel(), e.getSecurityName(), e.getSecurityLevel(), command, e.getMaxSizeResponsePDU(), ref, statusInformation);
            }
            catch (MessageException ex) {
                err.println("Error while sending response: " + ex.getMessage());
                LogFactory.getLogger(SnmpCommand.class).error(ex);
            }
        }
    }

    protected static void printVariableBindings(PDU response) {
        for (int i = 0; i < response.size(); ++i) {
            VariableBinding vb = response.get(i);
            out.println(vb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int table() throws IOException {
        Integer bufferSize;
        Integer maxLineLength;
        TableUtils tableUtils = new TableUtils(this.snmp, this.pduFactory);
        Integer maxRep = ((SnmpConfigurator.InnerPDUFactory)this.pduFactory).getMaxRepetitions();
        if (maxRep != null) {
            tableUtils.setMaxNumRowsPerPDU(maxRep);
        }
        Counter32 counter = new Counter32();
        OID[] columns = new OID[this.vbs.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.vbs.get(i).getOid();
        }
        Integer defaultColSize = (Integer)ArgumentParser.getValue(this.settings, "Cc", 0);
        if (defaultColSize == null) {
            defaultColSize = 16;
        }
        if ((maxLineLength = (Integer)ArgumentParser.getValue(this.settings, "Cw", 0)) == null) {
            maxLineLength = 80;
        }
        TableFormatter tf = new TableFormatter(out, defaultColSize, maxLineLength, " ");
        if (this.settings.containsKey("Cf")) {
            String s = (String)ArgumentParser.getValue(this.settings, "Cf", 0);
            tf.setCompact(true);
            tf.setSeparator(s);
        }
        if (this.settings.containsKey("Cl")) {
            tf.setLeftAlign(true);
        }
        if (this.settings.containsKey("Cb") && (bufferSize = (Integer)ArgumentParser.getValue(this.settings, "Cb", 0)) != null) {
            tf.setBufferSize(bufferSize);
        }
        if (!this.settings.containsKey("Ch")) {
            long startTime = System.currentTimeMillis();
            Counter32 counter32 = counter;
            synchronized (counter32) {
                TableListener listener = this.operation == 3 ? new TextTableListener(tf, this.settings.containsKey("Ci")) : new CVSTableListener(System.currentTimeMillis());
                if (this.useDenseTableOperation) {
                    tableUtils.getDenseTable(this.target, columns, listener, counter, this.lowerBoundIndex, this.upperBoundIndex);
                } else {
                    tableUtils.getTable(this.target, columns, listener, counter, this.lowerBoundIndex, this.upperBoundIndex);
                }
                try {
                    counter.wait(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            tf.flush();
            err.println("Table received in " + (System.currentTimeMillis() - startTime) + " milliseconds.");
        } else {
            tf.flush();
        }
        this.snmp.close();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSnapshot(List<?> snapshot) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.snapshotFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(snapshot);
            oos.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpSnapshot() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.snapshotFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            List l = (List)ois.readObject();
            int i = 1;
            err.println("Dumping snapshot file '" + String.valueOf(this.snapshotFile) + "':");
            Iterator it = l.iterator();
            while (it.hasNext()) {
                out.println(i + ": " + String.valueOf(it.next()));
                ++i;
            }
            out.println();
            err.println("Dumped " + l.size() + " variable bindings.");
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDU walk(Snmp snmp, PDU request, Target<?> target, final List<VariableBinding> snapshot) throws IOException {
        TreeListener treeListener;
        try {
            request.setNonRepeaters(0);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        OID rootOID = request.get(0).getOid();
        PDU response = null;
        final WalkCounts counts = new WalkCounts();
        final long startTime = System.currentTimeMillis();
        TreeUtils treeUtils = new TreeUtils(snmp, this.pduFactory);
        if (this.settings.containsKey("ilo")) {
            treeUtils.setIgnoreLexicographicOrder(true);
        }
        TreeListener treeListener2 = treeListener = new TreeListener(){
            private boolean finished = false;

            @Override
            public boolean next(TreeEvent e) {
                ++counts.requests;
                if (e.getVariableBindings() != null) {
                    VariableBinding[] vbs = e.getVariableBindings();
                    counts.objects += vbs.length;
                    for (VariableBinding vb : vbs) {
                        if (snapshot != null) {
                            snapshot.add(vb);
                        }
                        out.println(vb.toString());
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(TreeEvent e) {
                this.finished = true;
                if (e.getVariableBindings() != null && e.getVariableBindings().length > 0) {
                    this.next(e);
                }
                err.println();
                err.println("Total requests sent:    " + counts.requests);
                err.println("Total objects received: " + counts.objects);
                err.println("Total walk time:        " + (System.currentTimeMillis() - startTime) + " milliseconds");
                if (e.isError()) {
                    err.println("The following error occurred during walk:");
                    err.println(e.getErrorMessage());
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notifyAll();
                }
            }

            @Override
            public boolean isFinished() {
                return this.finished;
            }
        };
        synchronized (treeListener2) {
            treeUtils.getSubtree(target, rootOID, null, treeListener);
            try {
                treeListener.wait();
            }
            catch (InterruptedException ex) {
                err.println("Tree retrieval interrupted: " + ex.getMessage());
            }
        }
        return response;
    }

    private static List<VariableBinding> getVariableBindings(String[] args2, int position) {
        ArrayList<VariableBinding> v = new ArrayList<VariableBinding>(args2.length - position + 1);
        for (int i = position; i < args2.length; ++i) {
            String oid = args2[i];
            char type = 'i';
            String value = null;
            int equal = oid.indexOf("={");
            if (equal > 0) {
                oid = args2[i].substring(0, equal);
                type = args2[i].charAt(equal + 2);
                value = args2[i].substring(args2[i].indexOf(125) + 1);
            } else if (oid.indexOf(45) > 0) {
                StringTokenizer st = new StringTokenizer(oid, "-");
                if (st.countTokens() != 2) {
                    throw new IllegalArgumentException("Illegal OID range specified: '" + oid);
                }
                oid = st.nextToken();
                VariableBinding vbLower = new VariableBinding(new OID(oid));
                v.add(vbLower);
                long last = Long.parseLong(st.nextToken());
                long first = vbLower.getOid().lastUnsigned();
                for (long k = first + 1L; k <= last; ++k) {
                    OID nextOID = new OID(vbLower.getOid().getValue(), 0, vbLower.getOid().size() - 1);
                    nextOID.appendUnsigned(k);
                    VariableBinding next = new VariableBinding(nextOID);
                    v.add(next);
                }
                continue;
            }
            VariableBinding vb = new VariableBinding(new OID(oid));
            if (value != null) {
                AbstractVariable variable;
                switch (type) {
                    case 'i': {
                        variable = new Integer32(Integer.parseInt(value));
                        break;
                    }
                    case 'u': {
                        variable = new UnsignedInteger32(Long.parseLong(value));
                        break;
                    }
                    case 's': {
                        variable = new OctetString(value);
                        break;
                    }
                    case 'x': {
                        variable = OctetString.fromString(value, ':', 16);
                        break;
                    }
                    case 'd': {
                        variable = OctetString.fromString(value, '.', 10);
                        break;
                    }
                    case 'b': {
                        variable = OctetString.fromString(value, ' ', 2);
                        break;
                    }
                    case 'n': {
                        variable = new Null();
                        break;
                    }
                    case 'o': {
                        variable = new OID(value);
                        break;
                    }
                    case 't': {
                        variable = new TimeTicks(Long.parseLong(value));
                        break;
                    }
                    case 'a': {
                        variable = new IpAddress(value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Variable type " + type + " not supported");
                    }
                }
                vb.setVariable(variable);
            }
            v.add(vb);
        }
        return v;
    }

    private static Address getAddress(String transportAddress) {
        String transport = "udp";
        int colon = ((String)transportAddress).indexOf(58);
        if (colon > 0) {
            transport = ((String)transportAddress).substring(0, colon);
            transportAddress = ((String)transportAddress).substring(colon + 1);
        }
        if (((String)transportAddress).indexOf(47) < 0) {
            transportAddress = (String)transportAddress + "/161";
        }
        if (transport.equalsIgnoreCase("udp")) {
            return new UdpAddress((String)transportAddress);
        }
        if (transport.equalsIgnoreCase("tcp")) {
            return new TcpAddress((String)transportAddress);
        }
        throw new IllegalArgumentException("Unknown transport " + transport);
    }

    public synchronized int listen() throws IOException {
        Object address = this.target.getAddress();
        AbstractTransportMapping transport = address instanceof TcpAddress ? new DefaultTcpTransportMapping((TcpAddress)address) : new DefaultUdpTransportMapping((UdpAddress)address);
        ThreadPool threadPool = ThreadPool.create("DispatcherPool", this.numDispatcherThreads);
        MultiThreadedMessageDispatcher mtDispatcher = new MultiThreadedMessageDispatcher(threadPool, new SnmpCommandMessageDispatcher());
        mtDispatcher.addMessageProcessingModel(new MPv1());
        mtDispatcher.addMessageProcessingModel(new MPv2c());
        mtDispatcher.addMessageProcessingModel(new MPv3(this.localEngineID.getValue()));
        SecurityProtocols.getInstance().addDefaultProtocols();
        SecurityProtocols.getInstance().addPrivacyProtocol(new Priv3DES());
        Snmp snmp = new Snmp(mtDispatcher, transport);
        if (this.version == 3) {
            USM usm = new USM(SecurityProtocols.getInstance(), this.localEngineID, 0);
            SecurityModels.getInstance().addSecurityModel(usm);
            if (this.authoritativeEngineID != null) {
                snmp.setLocalEngine(this.authoritativeEngineID.getValue(), 0, 0);
            }
            SnmpConfigurator snmpConfig = new SnmpConfigurator();
            snmpConfig.configure(snmp, this.settings);
        } else {
            CommunityTarget target = new CommunityTarget(address, this.community);
            this.target = target;
        }
        snmp.addCommandResponder(this);
        transport.listen();
        out.println("Listening on " + String.valueOf(address));
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    public static void main(String[] args2) {
        Map<String, List<Object>> commandLineParameters = null;
        try {
            String helpCmd;
            Integer width;
            String[] commandSet = ArgumentParser.selectCommand(args2, ALL_OPTIONS, COMMANDS);
            if (commandSet == null) {
                SnmpCommand.printUsage();
                System.exit(2);
            }
            ArgumentParser parser = new ArgumentParser(commandSet[1], commandSet[2]);
            commandLineParameters = parser.parse(args2);
            String command = (String)ArgumentParser.getValue(commandLineParameters, "command", 0);
            if (commandLineParameters.containsKey("w") && (width = (Integer)ArgumentParser.getValue(commandLineParameters, "w", 0)) > 20) {
                stdoutWidth = width;
            }
            if (commandLineParameters.containsKey("s")) {
                silent = true;
            }
            if (commandLineParameters.containsKey("d")) {
                LogLevel level = new LogLevel(((String)ArgumentParser.getValue(commandLineParameters, "d", 0)).toUpperCase());
                LogFactory.getLogFactory().getRootLogger().setLogLevel(level);
            }
            if ("help".equals(command)) {
                helpCmd = (String)ArgumentParser.getValue(commandLineParameters, "subject", 0);
                SnmpCommand b2 = new SnmpCommand(command, commandLineParameters);
                String help = b2.help("", helpCmd, true, true);
                out.println(help);
                System.exit(0);
            } else if ("example".equals(command)) {
                helpCmd = (String)ArgumentParser.getValue(commandLineParameters, "subject", 0);
                SnmpCommand b3 = new SnmpCommand(command, commandLineParameters);
                String help = b3.example("", helpCmd);
                out.println(help);
                System.exit(0);
            } else if ("version".equals(command)) {
                SnmpCommand.printVersion();
                System.exit(0);
            } else {
                SnmpCommand browser = new SnmpCommand(command, commandLineParameters);
                browser.run();
                System.exit(browser.returnCode);
            }
        }
        catch (ArgumentParser.ArgumentParseException apex) {
            if (args2.length == 0 || "help".equals(args2[0])) {
                try {
                    SnmpCommand.printUsage();
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            } else {
                System.out.println(apex.getMessage());
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (RuntimeException rex) {
            System.out.println(rex.getMessage());
            if (commandLineParameters != null && commandLineParameters.containsKey("d") && "debug".equalsIgnoreCase((String)ArgumentParser.getValue(commandLineParameters, "d", 0))) {
                rex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(1);
    }

    @Override
    public void run() {
        try {
            switch (this.operation) {
                case 7: {
                    this.returnCode = this.dumpSnapshot();
                    break;
                }
                case 2: {
                    this.returnCode = this.listen();
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.returnCode = this.table();
                    break;
                }
                default: {
                    PDU response = this.send();
                    if (this.pduType == -89 || this.pduType == -88 || this.pduType == -92 || this.pduType == -94) {
                        out.println(PDU.getTypeString(this.pduType) + " sent successfully");
                        break;
                    }
                    if (response == null) {
                        if (this.operation != 1) {
                            out.println("Request timed out.");
                        }
                        break;
                    }
                    if (response.getType() == -88) {
                        SnmpCommand.printReport(response);
                        break;
                    }
                    if (this.operation == 0) {
                        err.println("Response received with requestID=" + String.valueOf(response.getRequestID()) + ", errorIndex=" + response.getErrorIndex() + ", errorStatus=" + response.getErrorStatusText() + "(" + response.getErrorStatus() + ")");
                        SnmpCommand.printVariableBindings(response);
                        break;
                    }
                    err.println("Received something strange: requestID=" + String.valueOf(response.getRequestID()) + ", errorIndex=" + response.getErrorIndex() + ", errorStatus=" + response.getErrorStatusText() + "(" + response.getErrorStatus() + ")");
                    SnmpCommand.printVariableBindings(response);
                    break;
                }
            }
        }
        catch (MessageException mex) {
            out.println(mex.getMessage());
            this.returnCode = 1;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            this.returnCode = 1;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    private byte[] getUserEngineID() {
        OctetString ne = SnmpConfigurator.createOctetString((String)ArgumentParser.getValue(this.settings, "CE", 0), null);
        byte[] engineID = ne == null ? ((UserTarget)this.target).getAuthoritativeEngineID() : ne.getValue();
        if (engineID == null || engineID.length == 0) {
            engineID = this.snmp.discoverAuthoritativeEngineID(this.target.getAddress(), this.target.getTimeout());
        }
        return engineID;
    }

    protected static void printVersion() {
        out.println();
        out.println("SnmpCommand " + VersionInfo.getVersion() + " [SNMP4J " + VersionInfo.getVersion() + "]");
        out.println("Copyright \u00a9 2004-2018, Frank Fock");
        out.println("http://www.snmp4j.org");
        out.println();
    }

    public static void printUsage() throws IOException {
        SnmpCommand b2 = new SnmpCommand("help", new HashMap<String, List<Object>>());
        String help = b2.help("", null, true, false);
        out.println(help);
    }

    @Override
    public <A extends Address> void processMessage(TransportMapping<? super A> sourceTransport, A incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
        byte[] msg = new byte[wholeMessage.remaining()];
        wholeMessage.get(msg);
        wholeMessage.rewind();
        out.println("Packet received from " + String.valueOf(incomingAddress) + " on " + String.valueOf(sourceTransport.getListenAddress()) + ":");
        out.println(new OctetString(msg).toHexString());
    }

    public void processMessage(TransportMapping<?> sourceTransport, Address destAddress, byte[] message) {
        out.println("Packet sent to " + String.valueOf(destAddress) + " on " + String.valueOf(sourceTransport.getListenAddress()) + ":");
        out.println(new OctetString(message).toHexString());
    }

    static {
        LogFactory.setLogFactory(new ConsoleLogFactory());
        BER.setCheckSequenceLength(false);
        COMMANDS = new String[][]{{"set", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword ", "#command[s<set>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] #OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"get", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword ", "#command[s<get>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] #OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"getnext", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword ", "#command[s<getnext>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] #OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"getbulk", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword -Cr[i{=10}] -Cn[i{=0}] ", "#command[s<getbulk>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] #OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"inform", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword +Ta[s{=0.0.0.0}<(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}>] -To[s{=1.3.6.1.6.3.1.1.5.1}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Te[s{=0.0}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Ts[i{=0}] +Tg[i{=0}] +Tu[l{=0}] ", "#command[s<inform>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +OID[s<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.#]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"trap", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword +Ta[s{=0.0.0.0}<(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}>] -To[s{=1.3.6.1.6.3.1.1.5.1}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Te[s{=0.0}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Ts[i{=0}] +Tg[i{=0}] +Tu[l{=0}] ", "#command[s<trap>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +OID[s<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.#]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"v1trap", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +Ta[s{=0.0.0.0}<(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}\\.(\\d){1,3}>] -To[s{=1.3.6.1.6.3.1.1.5.1}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Te[s{=0.0}<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.]*>] +Ts[i{=0}] +Tg[i{=0}] +Tu[l{=0}] ", "#command[s<v1trap>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +OID[s<([a-zA-Z\\-0-9]*:)?[0-9a-zA-Z\\-\\.#]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"table", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword -Cr[i{=10}] -Cn[i{=0}] +Cil[s] +Ciu[s] +Ch +Ci +Cl +Cw[i] +Cf[s] +Cc[i] +Otd +OtCSV +OttCSV ", "#command[s<table>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] #OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] .. "}, {"walk", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword -Cr[i{=10}] -Cn[i{=0}] +Cil[s] +Ciu[s] +Ch +Ci +Cl +Cw[i] +Cf[s] +Cc[i] +Otd +OtCSV +OttCSV +ilo ", "#command[s<walk>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] #OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] "}, {"dump-snapshot", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] ", "#command[s<dump-snapshot>] #file[s]"}, {"create-snapshot", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword -Cr[i{=10}] -Cn[i{=0}] +Cil[s] +Ciu[s] +Ch +Ci +Cl +Cw[i] +Cf[s] +Cc[i] +Otd +OtCSV +OttCSV +ilo ", "#command[s<create-snapshot>] #file[s] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] #OID[s<([A-Z]+[a-zA-Z\\-0-9]*:)?([a-z][a-zA-Z\\-0-9])?([0-9]+[\\.][0-9]+)?[^=]*(=(\\{[iusxdnotab]\\})?.*)?>] "}, {"listen", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] +b[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] +c[s] +r[i{=1}] +t[i{=5000}] +v[s{=3}<1|2c|3>] +Ors[i{=65535}] +p +a[s<MD5|SHA|SHA224|SHA256|SHA384|SHA512>] +y[s<DES|3DES|AES128|AES192|AES256|AES192p|AES256p>] +A[s] +bc[i{=0}] +e[x] +E[x] -rsl[s{=low}<(low|basic|secure)>] +Y[s] +u[s] +l[x] +n[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2)>] +dtls-version[s{=DTLSv1.2}<DTLSv1[\\.0|\\.2|\\.3]?[,DTLSv1[\\.0|\\.2|\\.3]?]*>] +Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword ", "#command[s<listen>] #address[s<(udp|tcp|dtls|tls):.*[/[0-9]+]?>] "}, {"help", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] ", "#command[s<help>] +subject[s<all|create-snapshot|defaults|dump-snapshot|get|getbulk|getnext|inform|license|listen|oid|mib|set|smi|table|trap|usmKey|usmUser|v1trap|version|walk>]"}, {"example", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] ", "#command[s<example>] +subject[s<create-snapshot|defaults|dump-snapshot|get|getbulk|getnext|inform|license|listen|oid|mib|set|smi|table|trap|v1trap|version|walk>]"}, {"version", "+d[s{=off}<(?i)(off|error|warn|info|debug)>] +Dn +s +f[s{=3}<(1|2|3|4)>] +w[i{=79}] +h[i{=0}] ", "#command[s<version>]"}};
        packetDumpEnabled = false;
        stdoutWidth = 79;
        err = new FilterPrintStream(System.err);
        out = System.out;
        help = ResourceBundle.getBundle("org.snmp4j.tools.console.help");
        tabs = null;
        silent = false;
    }

    public class SnmpCommandMessageDispatcher
    extends MessageDispatcherImpl {
        @Override
        public <A extends Address> void processMessage(TransportMapping<? super A> sourceTransport, A incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
            if (packetDumpEnabled) {
                SnmpCommand.this.processMessage(sourceTransport, incomingAddress, wholeMessage, tmStateReference);
            }
            super.processMessage(sourceTransport, incomingAddress, wholeMessage, tmStateReference);
        }

        @Override
        protected <A extends Address> void sendMessage(TransportMapping<? super A> transport, A destAddress, byte[] message, TransportStateReference tmStateReference, long timeoutMillis, int maxRetries) throws IOException {
            super.sendMessage(transport, destAddress, message, tmStateReference, timeoutMillis, maxRetries);
            if (packetDumpEnabled) {
                SnmpCommand.this.processMessage(transport, destAddress, message);
            }
        }
    }

    class TextTableListener
    implements TableListener {
        private boolean finished;
        private TableFormatter tf;
        boolean addIndex;

        public TextTableListener(TableFormatter tf, boolean addIndex) {
            this.tf = tf;
            this.addIndex = addIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished(TableEvent event) {
            this.tf.flush();
            out.flush();
            err.println();
            err.println("Table walk completed with status " + event.getStatus() + ". Received " + String.valueOf(event.getUserObject()) + " rows.");
            Object object = event.getUserObject();
            synchronized (object) {
                this.finished = true;
                event.getUserObject().notifyAll();
            }
        }

        @Override
        public boolean next(TableEvent event) {
            int offset = this.addIndex ? 1 : 0;
            Object[] c = new Object[event.getColumns().length + offset];
            for (int i = 0; i < event.getColumns().length; ++i) {
                c[i] = event.getColumns()[i + offset];
            }
            this.tf.addRow(c);
            ((Counter32)event.getUserObject()).increment();
            return true;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    class CVSTableListener
    implements TableListener {
        private long requestTime;
        private boolean finished;

        public CVSTableListener(long time) {
            this.requestTime = time;
        }

        @Override
        public boolean next(TableEvent event) {
            if (SnmpCommand.this.operation == 5) {
                out.print(this.requestTime);
                out.print(",");
            }
            out.print("\"" + String.valueOf(event.getIndex()) + "\",");
            for (int i = 0; i < event.getColumns().length; ++i) {
                Variable v = event.getColumns()[i].getVariable();
                String value = v.toString();
                switch (v.getSyntax()) {
                    case 6: 
                    case 64: 
                    case 68: {
                        out.print("\"");
                        out.print(value);
                        out.print("\"");
                        break;
                    }
                    case 67: {
                        out.print(((AssignableFromLong)((Object)v)).toLong());
                        break;
                    }
                    default: {
                        out.print(value);
                    }
                }
                if (i + 1 >= event.getColumns().length) continue;
                out.print(",");
            }
            out.println();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished(TableEvent event) {
            Object object = event.getUserObject();
            synchronized (object) {
                this.finished = true;
                event.getUserObject().notifyAll();
            }
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    class WalkCounts {
        public int requests;
        public int objects;

        WalkCounts() {
        }
    }

    static class FilterPrintStream
    extends PrintStream {
        public FilterPrintStream(OutputStream out) {
            super(out);
        }

        @Override
        public void print(Object obj) {
            if (!silent) {
                super.print(obj);
            }
        }

        @Override
        public void print(String s) {
            if (!silent) {
                super.print(s);
            }
        }

        @Override
        public void println() {
            if (!silent) {
                super.println();
            }
        }

        @Override
        public void println(Object x) {
            if (!silent) {
                super.println(x);
            }
        }

        @Override
        public void println(String x) {
            if (!silent) {
                super.println(x);
            }
        }
    }
}

