/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.SnmpEngineEvent;
import org.snmp4j.event.SnmpEngineListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.EngineIdCacheSize;
import org.snmp4j.mp.MessageID;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.PDUFactory;

public class MPv3
implements MessageProcessingModel,
EngineIdCacheSize {
    public static final int ID = 3;
    public static final int MPv3_REPORTABLE_FLAG = 4;
    public static final int MAX_MESSAGE_ID = Integer.MAX_VALUE;
    private static final int INT_LOW_16BIT_MASK = 65535;
    public static final OctetString LOCAL_ENGINE_ID = OctetString.fromHexString("80:00:00:00:06");
    public static final int MAXLEN_ENGINE_ID = 32;
    public static final int MINLEN_ENGINE_ID = 5;
    private static final int MAX_HEADER_PAYLOAD_LENGTH = new OctetString("\u0000").getBERLength() + 3 * new Integer32(Integer.MAX_VALUE).getBERLength();
    public static final int MAX_HEADER_LENGTH = MAX_HEADER_PAYLOAD_LENGTH + BER.getBERLengthOfLength(MAX_HEADER_PAYLOAD_LENGTH) + 1;
    private SecurityProtocols securityProtocols;
    private static final LogAdapter logger = LogFactory.getLogger(MPv3.class);
    private SecurityModels securityModels;
    private final Cache cache;
    private Map<Address, OctetString> engineIDs;
    private int maxEngineIdCacheSize = SNMP4JSettings.getMaxEngineIdCacheSize();
    private byte[] localEngineID;
    private int currentMsgID = new Random().nextInt(Integer.MAX_VALUE);
    private CounterSupport counterSupport;
    protected EngineIdCacheFactory engineIdCacheFactory = new LimitedCapacityEngineIdCacheFactory();
    transient List<SnmpEngineListener> snmpEngineListeners;
    protected PDUFactory incomingPDUFactory = new PDUFactory(){

        @Override
        public PDU createPDU(Target<?> target) {
            return new ScopedPDU();
        }

        @Override
        public PDU createPDU(MessageProcessingModel messageProcessingModel) {
            return new ScopedPDU();
        }
    };

    public MPv3() {
        this(MPv3.createLocalEngineID(), null);
    }

    public MPv3(byte[] localEngineID) {
        this(localEngineID, null);
        this.setLocalEngineID(localEngineID);
    }

    public MPv3(byte[] localEngineID, PDUFactory incomingPDUFactory) {
        this(localEngineID, incomingPDUFactory, SecurityProtocols.getInstance(), SecurityModels.getInstance(), CounterSupport.getInstance());
    }

    public MPv3(USM usm) {
        this(usm.getLocalEngineID().getValue(), null, SecurityProtocols.getInstance(), SecurityModels.getCollection(new SecurityModel[]{usm}), CounterSupport.getInstance());
    }

    public MPv3(byte[] localEngineID, PDUFactory incomingPDUFactory, SecurityProtocols secProtocols, SecurityModels secModels, CounterSupport counterSupport) {
        if (incomingPDUFactory != null) {
            this.incomingPDUFactory = incomingPDUFactory;
        }
        this.engineIDs = this.engineIdCacheFactory.createEngineIdMap(this);
        this.cache = new Cache();
        if (secProtocols == null) {
            throw new NullPointerException();
        }
        this.securityProtocols = secProtocols;
        if (secModels == null) {
            throw new NullPointerException();
        }
        this.securityModels = secModels;
        if (counterSupport == null) {
            throw new NullPointerException();
        }
        this.counterSupport = counterSupport;
        this.setLocalEngineID(localEngineID);
        SecurityModel usm = secModels.getSecurityModel(new Integer32(3));
        if (usm instanceof USM) {
            this.setCurrentMsgID(MPv3.randomMsgID(((USM)usm).getEngineBoots()));
        }
    }

    public EngineIdCacheFactory getEngineIdCacheFactory() {
        return this.engineIdCacheFactory;
    }

    public void setEngineIdCacheFactory(EngineIdCacheFactory engineIdCacheFactory) {
        this.engineIDs = engineIdCacheFactory.createEngineIdMap(this);
        this.engineIdCacheFactory = engineIdCacheFactory;
    }

    @Override
    public int getMaxEngineIdCacheSize() {
        return this.maxEngineIdCacheSize;
    }

    public void setMaxEngineIdCacheSize(int maxEngineIdCacheSize) {
        this.maxEngineIdCacheSize = maxEngineIdCacheSize;
    }

    public static byte[] createLocalEngineID() {
        int enterpriseID = SNMP4JSettings.getEnterpriseID();
        byte[] engineID = new byte[]{(byte)(0x80 | enterpriseID >> 24 & 0xFF), (byte)(enterpriseID >> 16 & 0xFF), (byte)(enterpriseID >> 8 & 0xFF), (byte)(enterpriseID & 0xFF), 2};
        OctetString os = new OctetString();
        try {
            byte[] b2 = InetAddress.getLocalHost().getAddress();
            if (b2.length == 4) {
                engineID[4] = 1;
            }
            os.setValue(b2);
        }
        catch (UnknownHostException ex) {
            logger.debug((Serializable)((Object)"Local host cannot be determined for creation of local engine ID"));
            engineID[4] = 4;
            os.setValue("SNMP4J".getBytes());
        }
        OctetString ownEngineID = new OctetString(engineID);
        Random random = new Random(System.nanoTime());
        byte[] fourBytes = new byte[4];
        random.nextBytes(fourBytes);
        ownEngineID.append(os);
        ownEngineID.append(fourBytes);
        return ownEngineID.getValue();
    }

    public static byte[] createLocalEngineID(OctetString id) {
        int enterpriseID = SNMP4JSettings.getEnterpriseID();
        byte[] engineID = new byte[]{(byte)(0x80 | enterpriseID >> 24 & 0xFF), (byte)(enterpriseID >> 16 & 0xFF), (byte)(enterpriseID >> 8 & 0xFF), (byte)(enterpriseID & 0xFF), 4};
        OctetString ownEngineID = new OctetString(engineID);
        ownEngineID.append(id);
        return ownEngineID.getValue();
    }

    public void setLocalEngineID(byte[] engineID) {
        if (engineID == null || engineID.length < 5 || engineID.length > 32) {
            throw new IllegalArgumentException("Illegal (local) engine ID");
        }
        this.localEngineID = engineID;
    }

    public static int randomMsgID(int engineBoots) {
        return new Random().nextInt(Integer.MAX_VALUE) & 0xFFFF | (engineBoots & 0xFFFF) << 16;
    }

    public byte[] getLocalEngineID() {
        byte[] retval = new byte[this.localEngineID.length];
        System.arraycopy(this.localEngineID, 0, retval, 0, this.localEngineID.length);
        return retval;
    }

    public void initDefaults() {
        this.securityProtocols.addDefaultProtocols();
    }

    public AuthenticationProtocol getAuthProtocol(OID id) {
        return this.securityProtocols.getAuthenticationProtocol(id);
    }

    public PrivacyProtocol getPrivProtocol(OID id) {
        return this.securityProtocols.getPrivacyProtocol(id);
    }

    public SecurityModel getSecurityModel(int id) {
        return this.securityModels.getSecurityModel(new Integer32(id));
    }

    @Override
    public int getID() {
        return 3;
    }

    @Override
    public boolean isProtocolVersionSupported(int version) {
        return version == 3;
    }

    public boolean addEngineID(Address address, OctetString engineID) {
        if (!Arrays.equals(this.localEngineID, engineID.getValue())) {
            try {
                OctetString previousEngineID = this.addEngineIdToCache(address, engineID);
                if (!(this.snmpEngineListeners == null || previousEngineID != null && previousEngineID.equals(engineID))) {
                    this.fireEngineChanged(new SnmpEngineEvent(this, 1, engineID, address));
                }
            }
            catch (IllegalArgumentException iaex) {
                this.fireEngineChanged(new SnmpEngineEvent(this, 3, engineID, address));
                return false;
            }
            return true;
        }
        return false;
    }

    protected OctetString addEngineIdToCache(Address address, OctetString engineID) {
        if (this.maxEngineIdCacheSize > 0 && this.engineIDs.size() >= this.maxEngineIdCacheSize) {
            if (this.engineIDs.containsKey(address)) {
                return this.engineIDs.put(address, engineID);
            }
            String msg = "MPv3: Failed to add engineID '" + engineID.toHexString() + "' for address '" + String.valueOf(address) + "' to local cache because its size limit of " + this.maxEngineIdCacheSize + "has been reached";
            logger.warn((Serializable)((Object)msg));
            throw new IllegalArgumentException(msg);
        }
        return this.engineIDs.put(address, engineID);
    }

    public OctetString getEngineID(Address address) {
        return this.engineIDs.get(address);
    }

    public OctetString removeEngineID(Address address) {
        OctetString engineID = this.engineIDs.remove(address);
        if (engineID != null && this.snmpEngineListeners != null) {
            this.fireEngineChanged(new SnmpEngineEvent(this, 2, engineID, address));
        }
        return engineID;
    }

    public synchronized int getNextMessageID() {
        if (this.currentMsgID >= Integer.MAX_VALUE) {
            this.currentMsgID = 1;
        }
        return this.currentMsgID++;
    }

    public SecurityProtocols getSecurityProtocols() {
        return this.securityProtocols;
    }

    public void setSecurityProtocols(SecurityProtocols securityProtocols) {
        this.securityProtocols = securityProtocols;
    }

    @Override
    public void releaseStateReference(PduHandle pduHandle) {
        this.cache.deleteEntry(pduHandle);
    }

    @Override
    public <A extends Address> int prepareOutgoingMessage(A transportAddress, int maxMessageSize, int messageProcessingModel, int securityModel, byte[] securityName, int securityLevel, PDU pdu, boolean expectResponse, PduHandle sendPduHandle, BEROutputStream outgoingMessage, TransportStateReference tmStateReference) throws IOException {
        byte[] secEngineID;
        if (!(pdu instanceof ScopedPDU)) {
            String msg = "MPv3 only accepts ScopedPDU instances as pdu parameter";
            logger.error((Serializable)((Object)msg));
            throw new IllegalArgumentException(msg);
        }
        ScopedPDU scopedPDU = (ScopedPDU)pdu;
        SecurityModel secModel = this.securityModels.getSecurityModel(new Integer32(securityModel));
        if (secModel == null) {
            return -1402;
        }
        if (secModel.hasAuthoritativeEngineID()) {
            OctetString securityEngineID = this.engineIDs.get(transportAddress);
            if (securityEngineID != null) {
                secEngineID = securityEngineID.getValue();
                if (scopedPDU.getContextEngineID().length() == 0) {
                    switch (pdu.getType()) {
                        case -90: 
                        case -89: {
                            OctetString localEngineID = new OctetString(this.getLocalEngineID());
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("Context engine ID of scoped PDU is empty! Setting it to local engine ID: " + localEngineID.toHexString())));
                            }
                            scopedPDU.setContextEngineID(localEngineID);
                            break;
                        }
                        default: {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("Context engine ID of scoped PDU is empty! Setting it to authoritative engine ID: " + securityEngineID.toHexString())));
                            }
                            scopedPDU.setContextEngineID(new OctetString(secEngineID));
                            break;
                        }
                    }
                }
            } else {
                secEngineID = new byte[]{};
            }
        } else {
            secEngineID = new byte[]{};
        }
        if (pdu.isConfirmedPdu()) {
            if (secEngineID.length == 0) {
                if (secModel.supportsEngineIdDiscovery()) {
                    securityLevel = 1;
                    scopedPDU = (ScopedPDU)scopedPDU.clone();
                    scopedPDU.clear();
                } else if (scopedPDU.getContextEngineID() == null || scopedPDU.getContextEngineID().length() == 0) {
                    logger.warn((Serializable)((Object)"ScopedPDU with empty context engine ID"));
                } else if (!LOCAL_ENGINE_ID.equals(scopedPDU.getContextEngineID()) && this.getEngineID(transportAddress) == null) {
                    this.addEngineID(transportAddress, scopedPDU.getContextEngineID());
                }
            }
        } else if (scopedPDU.getContextEngineID().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"Context engine ID of unconfirmed scoped PDU is empty! Setting it to local engine ID"));
            }
            scopedPDU.setContextEngineID(new OctetString(this.localEngineID));
        }
        int scopedPDULength = scopedPDU.getBERLength();
        BEROutputStream scopedPdu = new BEROutputStream(ByteBuffer.allocate(scopedPDULength));
        scopedPDU.encodeBER(scopedPdu);
        HeaderData headerData = new HeaderData();
        int flags = MPv3.initHeaderDataFromSecurityLevel(securityLevel);
        if (scopedPDU.isConfirmedPdu()) {
            flags |= 4;
        } else {
            secEngineID = this.localEngineID;
        }
        int msgID = this.getNextMessageID();
        headerData.setMsgFlags(flags);
        headerData.setMsgID(msgID);
        headerData.setMsgMaxSize(maxMessageSize);
        headerData.setSecurityModel(securityModel);
        ByteBuffer globalDataBuffer = ByteBuffer.allocate(headerData.getBERLength());
        BEROutputStream globalDataOutputStream = new BEROutputStream(globalDataBuffer);
        headerData.encodeBER(globalDataOutputStream);
        BERInputStream scopedPDUInput = new BERInputStream(scopedPdu.rewind());
        SecurityParameters securityParameters = secModel.newSecurityParametersInstance();
        SecurityStateReference securityStateReference = secModel.newSecurityStateReference();
        int status = secModel.generateRequestMessage(messageProcessingModel, globalDataBuffer.array(), maxMessageSize, securityModel, secEngineID, securityName, securityLevel, scopedPDUInput, securityParameters, outgoingMessage, tmStateReference, securityStateReference);
        if (status == 0 && expectResponse) {
            this.cache.addEntry(new StateReference<A>(msgID, flags, maxMessageSize, sendPduHandle, transportAddress, null, secEngineID, secModel, securityName, securityLevel, scopedPDU.getContextEngineID().getValue(), scopedPDU.getContextName().getValue(), securityStateReference, status));
        }
        return status;
    }

    private static int initHeaderDataFromSecurityLevel(int securityLevel) {
        int flags = 0;
        switch (securityLevel) {
            case 1: {
                break;
            }
            case 2: {
                flags = 1;
                break;
            }
            case 3: {
                flags = 3;
                break;
            }
            default: {
                logger.warn((Serializable)((Object)("Unknown security level " + securityLevel + " ignored and set to authPriv(3) instead")));
                flags = 3;
            }
        }
        return flags;
    }

    @Override
    public <A extends Address> int prepareResponseMessage(int messageProcessingModel, int maxMessageSize, int securityModel, byte[] securityName, int securityLevel, PDU pdu, int maxSizeResponseScopedPDU, StateReference<A> stateReference, StatusInformation statusInformation, BEROutputStream outgoingMessage) throws IOException {
        OctetString securityEngineID;
        BEROutputStream scopedPDU;
        StateReference<?> cacheEntry = this.cache.popEntry(stateReference.getMsgID());
        if (cacheEntry == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("RFC3412 \u00a77.1 - Preparing response or internal message failed (msgID=" + String.valueOf(stateReference.getMsgID()) + ") because cached information for the msgID could not be found")));
            }
            return -1409;
        }
        int scopedPDULength = pdu.getBERLength();
        if (scopedPDULength > maxSizeResponseScopedPDU) {
            ScopedPDU tooBigPDU = new ScopedPDU((ScopedPDU)pdu);
            tooBigPDU.clear();
            tooBigPDU.setRequestID(pdu.getRequestID());
            tooBigPDU.setErrorStatus(1);
            tooBigPDU.setErrorIndex(0);
            scopedPDULength = ((PDU)tooBigPDU).getBERLength();
            scopedPDU = new BEROutputStream(ByteBuffer.allocate(scopedPDULength));
            ((PDU)tooBigPDU).encodeBER(scopedPDU);
        } else {
            scopedPDU = new BEROutputStream(ByteBuffer.allocate(scopedPDULength));
            pdu.encodeBER(scopedPDU);
        }
        HeaderData headerData = new HeaderData();
        int flags = MPv3.initHeaderDataFromSecurityLevel(securityLevel);
        headerData.setMsgFlags(flags);
        headerData.setMsgID(stateReference.getMsgID().getID());
        headerData.setMsgMaxSize(maxMessageSize);
        headerData.setSecurityModel(securityModel);
        ByteBuffer globalDataBuffer = ByteBuffer.allocate(headerData.getBERLength());
        BEROutputStream globalDataOutputStream = new BEROutputStream(globalDataBuffer);
        headerData.encodeBER(globalDataOutputStream);
        switch (pdu.getType()) {
            case -94: 
            case -92: 
            case -89: 
            case -88: {
                securityEngineID = new OctetString(this.localEngineID);
                break;
            }
            default: {
                securityEngineID = new OctetString(cacheEntry.getSecurityEngineID());
            }
        }
        BERInputStream scopedPDUInput = new BERInputStream(scopedPDU.rewind());
        SecurityModel secModel = this.securityModels.getSecurityModel(new Integer32(securityModel));
        SecurityParameters securityParameters = secModel.newSecurityParametersInstance();
        return secModel.generateResponseMessage(this.getID(), globalDataBuffer.array(), maxMessageSize, securityModel, securityEngineID.getValue(), securityName, securityLevel, scopedPDUInput, cacheEntry.getSecurityStateReference(), securityParameters, outgoingMessage);
    }

    public int sendReport(MessageDispatcher messageDispatcher, ScopedPDU pdu, int securityLevel, int securityModel, OctetString securityName, int maxSizeResponseScopedPDU, StateReference<?> stateReference, VariableBinding payload) {
        ScopedPDU reportPDU = new ScopedPDU();
        reportPDU.setType(-88);
        if (pdu != null) {
            reportPDU.setContextEngineID(pdu.getContextEngineID());
            reportPDU.setContextName(pdu.getContextName());
            reportPDU.setRequestID(pdu.getRequestID());
        } else {
            reportPDU.setContextEngineID(new OctetString(this.getLocalEngineID()));
        }
        reportPDU.add(payload);
        StatusInformation statusInformation = new StatusInformation();
        try {
            int status = messageDispatcher.returnResponsePdu(this.getID(), securityModel, securityName.getValue(), securityLevel, reportPDU, maxSizeResponseScopedPDU, stateReference, statusInformation);
            if (status != 0) {
                logger.warn((Serializable)((Object)("Error while sending report: " + status)));
                return -1400;
            }
        }
        catch (MessageException mex) {
            logger.error((Serializable)((Object)("Error while sending report: " + mex.getMessage())));
            return -1400;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <A extends Address> int prepareDataElements(MessageDispatcher messageDispatcher, A transportAddress, BERInputStream wholeMsg, TransportStateReference tmStateReference, Integer32 messageProcessingModel, Integer32 securityModel, OctetString securityName, Integer32 securityLevel, MutablePDU pdu, PduHandle sendPduHandle, Integer32 maxSizeResponseScopedPDU, StatusInformation statusInformation, MutableStateReference<A> mutableStateReference) {
        try {
            BERInputStream scopedPduStream;
            StateReference<A> stateReference = new StateReference<A>();
            if (mutableStateReference.getStateReference() != null) {
                stateReference.setTransportMapping(mutableStateReference.getStateReference().getTransportMapping());
            }
            messageProcessingModel.setValue(3);
            wholeMsg.mark(16);
            BER.MutableByte type = new BER.MutableByte();
            int length = BER.decodeHeader(wholeMsg, type);
            if (type.getValue() != 48) {
                return -1408;
            }
            long lengthOfLength = wholeMsg.getPosition();
            wholeMsg.reset();
            wholeMsg.mark(length);
            if (wholeMsg.skip(lengthOfLength) != lengthOfLength) {
                return -1408;
            }
            Integer32 snmpVersion = new Integer32();
            snmpVersion.decodeBER(wholeMsg);
            if (snmpVersion.getValue() != 3) {
                throw new RuntimeException("Internal error unexpected SNMP version read");
            }
            HeaderData header = new HeaderData();
            header.decodeBER(wholeMsg);
            securityModel.setValue(header.getSecurityModel());
            stateReference.setMsgID(header.getMsgID());
            stateReference.setMsgFlags(header.getMsgFlags());
            stateReference.setAddress(transportAddress);
            mutableStateReference.setStateReference(stateReference);
            maxSizeResponseScopedPDU.setValue(header.msgMaxSize.getValue() - MAX_HEADER_LENGTH);
            ScopedPDU scopedPdu = (ScopedPDU)this.incomingPDUFactory.createPDU(this);
            pdu.setPdu(scopedPdu);
            SecurityModel secModel = this.securityModels.getSecurityModel(securityModel);
            if (secModel == null) {
                logger.error((Serializable)((Object)("RFC3412 \u00a77.2.4 - Unsupported security model: " + String.valueOf(securityModel))));
                CounterEvent event = new CounterEvent(this, SnmpConstants.snmpUnknownSecurityModels);
                this.fireIncrementCounter(event);
                return -1402;
            }
            switch (header.getMsgFlags() & 3) {
                case 3: {
                    securityLevel.setValue(3);
                    break;
                }
                case 0: {
                    securityLevel.setValue(1);
                    break;
                }
                case 1: {
                    securityLevel.setValue(2);
                    break;
                }
                default: {
                    securityLevel.setValue(1);
                    logger.debug((Serializable)((Object)"RFC3412 \u00a77.2.5 - Invalid message (illegal msgFlags)"));
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInvalidMsgs);
                    this.fireIncrementCounter(event);
                    return -1405;
                }
            }
            statusInformation.setSecurityLevel(securityLevel);
            int secParametersPosition = (int)wholeMsg.getPosition();
            SecurityParameters secParameters = secModel.newSecurityParametersInstance();
            secParameters.decodeBER(wholeMsg);
            secParameters.setSecurityParametersPosition(secParametersPosition);
            boolean reportableFlag = (header.getMsgFlags() & 4) > 0;
            OctetString securityEngineID = new OctetString();
            SecurityStateReference secStateReference = null;
            StateReference<?> stateReference2 = this.cache.getEntry(StateReference.createMessageID(header.getMsgID()), false);
            secStateReference = stateReference2 != null ? stateReference2.getSecurityStateReference() : secModel.newSecurityStateReference();
            wholeMsg.reset();
            BEROutputStream scopedPDU = new BEROutputStream();
            int status = secModel.processIncomingMsg(snmpVersion.getValue(), header.getMsgMaxSize() - MAX_HEADER_LENGTH, secParameters, secModel, securityLevel.getValue(), wholeMsg, tmStateReference, securityEngineID, securityName, scopedPDU, maxSizeResponseScopedPDU, secStateReference, statusInformation);
            wholeMsg.close();
            if (status == 0) {
                try {
                    scopedPduStream = new BERInputStream(scopedPDU.rewind());
                    scopedPdu.decodeBER(scopedPduStream);
                    sendPduHandle.setTransactionID(scopedPdu.getRequestID().getValue());
                    if (securityEngineID.length() > 0 && scopedPdu.isResponsePdu()) {
                        this.addEngineID(transportAddress, securityEngineID);
                    }
                }
                catch (IOException iox) {
                    logger.warn((Serializable)((Object)("ASN.1 parse error: " + iox.getMessage())));
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpInASNParseErrs);
                    this.fireIncrementCounter(event);
                    return -1408;
                }
                if ((scopedPdu.getContextEngineID() == null || scopedPdu.getContextEngineID().length() == 0) && scopedPdu.getType() != -94 && scopedPdu.getType() != -88) {
                    CounterEvent event = new CounterEvent(this, SnmpConstants.snmpUnknownPDUHandlers);
                    this.fireIncrementCounter(event);
                    VariableBinding errorIndication = new VariableBinding(event.getOid(), event.getCurrentValue());
                    statusInformation.setErrorIndication(errorIndication);
                    status = -1415;
                }
            }
            stateReference.setSecurityName(securityName.getValue());
            stateReference.setSecurityEngineID(securityEngineID.getValue());
            stateReference.setSecurityLevel(securityLevel.getValue());
            stateReference.setSecurityModel(secModel);
            stateReference.setSecurityStateReference(secStateReference);
            stateReference.setPduHandle(sendPduHandle);
            if (status != 0) {
                if (!reportableFlag) return status;
                if (statusInformation.getErrorIndication() == null) return status;
                try {
                    if (scopedPDU.getBuffer() != null) {
                        scopedPduStream = new BERInputStream(scopedPDU.rewind());
                        scopedPdu.decodeBER(scopedPduStream);
                    } else {
                        scopedPdu = null;
                    }
                }
                catch (IOException iox) {
                    logger.warn(iox);
                    scopedPdu = null;
                }
                StateReference<A> stateReference3 = new StateReference<A>(header.getMsgID(), header.getMsgFlags(), maxSizeResponseScopedPDU.getValue(), sendPduHandle, transportAddress, null, securityEngineID.getValue(), secModel, securityName.getValue(), securityLevel.getValue(), scopedPdu == null ? new byte[]{} : scopedPdu.getContextEngineID().getValue(), scopedPdu == null ? new byte[]{} : scopedPdu.getContextName().getValue(), secStateReference, status);
                secStateReference.setCachedForResponseProcessing(true);
                this.cache.addEntry(stateReference3);
                int reportStatus = this.sendReport(messageDispatcher, scopedPdu, statusInformation.getSecurityLevel().getValue(), secModel.getID(), securityName, maxSizeResponseScopedPDU.getValue(), stateReference, statusInformation.getErrorIndication());
                if (reportStatus == 0) return status;
                logger.warn((Serializable)((Object)("Sending report failed with error code: " + reportStatus)));
                return status;
            }
            stateReference.setContextEngineID(scopedPdu.getContextEngineID().getValue());
            stateReference.setContextName(scopedPdu.getContextName().getValue());
            stateReference.setMaxSizeResponseScopedPDU(maxSizeResponseScopedPDU.getValue());
            if (scopedPdu.getType() == -94 || scopedPdu.getType() == -88) {
                StateReference<?> stateReference4 = this.cache.popEntry(StateReference.createMessageID(header.getMsgID()));
                if (stateReference4 == null) {
                    if (!logger.isDebugEnabled()) return -1409;
                    logger.debug((Serializable)((Object)("RFC3412 \u00a77.2.10 - Received PDU (msgID=" + header.getMsgID() + ") is a response or internal class message, but cached information for the msgID could not be found")));
                    return -1409;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("RFC3412 \u00a77.2.10 - Received PDU (msgID=" + header.getMsgID() + ") is a response or an internal class message. PduHandle.transactionID = " + stateReference4.getPduHandle().getTransactionID())));
                }
                sendPduHandle.copyFrom(stateReference4.getPduHandle());
                if (scopedPdu.getType() == -88) {
                    statusInformation.setContextEngineID(scopedPdu.getContextEngineID().getValue());
                    statusInformation.setContextName(scopedPdu.getContextName().getValue());
                    statusInformation.setSecurityLevel(securityLevel);
                    if (stateReference4.getSecurityEngineID().length != 0 && !securityEngineID.equalsValue(stateReference4.getSecurityEngineID()) || secModel.getID() != stateReference4.getSecurityModel().getID() || !securityName.equalsValue(stateReference4.getSecurityName()) && securityName.length() != 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("RFC 3412 \u00a77.2.11 - Received report message does not match sent message. Cache entry is: " + String.valueOf(stateReference4) + ", received secName=" + String.valueOf(securityName) + ",secModel=" + String.valueOf(secModel) + ",secEngineID=" + String.valueOf(securityEngineID))));
                        }
                        mutableStateReference.setStateReference(null);
                        return -1410;
                    }
                    if (!this.addEngineID((Address)stateReference4.getAddress(), securityEngineID) && logger.isWarnEnabled()) {
                        logger.warn((Serializable)((Object)("Engine ID '" + String.valueOf(securityEngineID) + "' could not be added to engine ID cache for target address '" + String.valueOf(stateReference4.getAddress()) + "' because engine ID matches local engine ID or cache size limit is reached")));
                    }
                    mutableStateReference.setStateReference(null);
                    logger.debug((Serializable)((Object)"MPv3 finished"));
                    return 0;
                }
                if (scopedPdu.getType() == -94) {
                    if (!securityEngineID.equalsValue(stateReference4.getSecurityEngineID()) && stateReference4.getSecurityEngineID().length != 0 || secModel.getID() != stateReference4.getSecurityModel().getID() || !securityName.equalsValue(stateReference4.getSecurityName()) || securityLevel.getValue() != stateReference4.getSecurityLevel() || !scopedPdu.getContextEngineID().equalsValue(stateReference4.getContextEngineID()) && stateReference4.getContextEngineID().length != 0 || !scopedPdu.getContextName().equalsValue(stateReference4.getContextName()) && stateReference4.getContextName().length != 0) {
                        logger.debug((Serializable)((Object)"RFC 3412 \u00a77.2.12.b - Received response message does not match sent message"));
                        mutableStateReference.setStateReference(null);
                        return -1410;
                    }
                    mutableStateReference.setStateReference(null);
                    logger.debug((Serializable)((Object)"MPv3 finished"));
                    return 0;
                }
            } else {
                logger.debug((Serializable)((Object)("RFC3412 \u00a77.2.10 - Received PDU is NOT a response or internal class message -> unchanged PduHandle = " + String.valueOf(sendPduHandle))));
            }
            switch (scopedPdu.getType()) {
                case -96: 
                case -95: 
                case -93: 
                case -91: 
                case -90: {
                    if (securityEngineID.length() == 0) {
                        logger.debug((Serializable)((Object)"Received confirmed message with 0 length security engine ID"));
                    } else if (!securityEngineID.equalsValue(this.localEngineID)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("RFC3412 \u00a77.2.13.a - Security engine ID " + securityEngineID.toHexString() + " does not match local engine ID " + new OctetString(this.localEngineID).toHexString())));
                        }
                        mutableStateReference.setStateReference(null);
                        return -1406;
                    }
                    int cacheStatus = this.cache.addEntry(stateReference);
                    if (cacheStatus == -1404) {
                        mutableStateReference.setStateReference(null);
                        return 0;
                    }
                    secStateReference.setCachedForResponseProcessing(true);
                    return 0;
                }
                case -92: 
                case -89: {
                    mutableStateReference.setStateReference(null);
                    return 0;
                }
            }
            return -1400;
        }
        catch (IOException iox) {
            logger.warn((Serializable)((Object)("MPv3 parse error: " + iox.getMessage())));
            if (!logger.isDebugEnabled()) return -1408;
            iox.printStackTrace();
            return -1408;
        }
    }

    public void setSecurityModels(SecurityModels securityModels) {
        this.securityModels = securityModels;
    }

    public SecurityModels getSecurityModels() {
        return this.securityModels;
    }

    protected void fireIncrementCounter(CounterEvent e) {
        if (this.counterSupport != null) {
            this.counterSupport.fireIncrementCounter(e);
        }
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    public void setCounterSupport(CounterSupport counterSupport) {
        if (counterSupport == null) {
            throw new NullPointerException();
        }
        this.counterSupport = counterSupport;
    }

    public synchronized void addSnmpEngineListener(SnmpEngineListener l) {
        List<SnmpEngineListener> listeners = this.snmpEngineListeners;
        listeners = listeners == null ? new ArrayList<SnmpEngineListener>() : new ArrayList<SnmpEngineListener>(this.snmpEngineListeners);
        listeners.add(l);
        this.snmpEngineListeners = listeners;
    }

    public synchronized void removeSnmpEngineListener(SnmpEngineListener l) {
        List<SnmpEngineListener> listeners = this.snmpEngineListeners;
        if (listeners != null) {
            listeners = new ArrayList<SnmpEngineListener>(listeners);
            listeners.remove(l);
            this.snmpEngineListeners = listeners;
        }
    }

    public int getEngineIdCacheSize() {
        return this.engineIDs.size();
    }

    @Deprecated
    public PDU createPDU(Target<?> target) {
        return this.incomingPDUFactory.createPDU(target);
    }

    public int getNextMsgID() {
        return this.currentMsgID;
    }

    public void setCurrentMsgID(int nextMsgID) {
        this.currentMsgID = nextMsgID;
    }

    protected void fireEngineChanged(SnmpEngineEvent engineEvent) {
        if (this.snmpEngineListeners != null) {
            List<SnmpEngineListener> listeners = this.snmpEngineListeners;
            for (SnmpEngineListener listener : listeners) {
                listener.engineChanged(engineEvent);
            }
        }
    }

    private static class LimitedCapacityEngineIdCacheFactory
    implements EngineIdCacheFactory {
        private LimitedCapacityEngineIdCacheFactory() {
        }

        @Override
        public Map<Address, OctetString> createEngineIdMap(EngineIdCacheSize cacheSize) {
            HashMap map = new HashMap();
            return Collections.synchronizedMap(map);
        }
    }

    public static interface EngineIdCacheFactory {
        public Map<Address, OctetString> createEngineIdMap(EngineIdCacheSize var1);
    }

    protected static class Cache {
        private final Map<PduHandle, StateReference<?>> entries = new WeakHashMap(25);
        private final Map<MessageID, WeakReference<PduHandle>> msgIdToPduHandleMapping = new WeakHashMap<MessageID, WeakReference<PduHandle>>(25);

        protected Cache() {
        }

        public synchronized int addEntry(StateReference<?> entry) {
            StateReference<?> existing;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Adding cache entry: " + String.valueOf(entry))));
            }
            if ((existing = this.entries.get(entry.getPduHandle())) != null) {
                existing.setPduHandle(entry.getPduHandle());
                if (existing.equals(entry)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Doubled message: " + String.valueOf(entry))));
                    }
                    existing.setPduHandle(null);
                    return -1404;
                }
                if (existing.equalsExceptMsgID(entry)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Adding previous message IDs " + String.valueOf(existing.getMessageIDs()) + " to new entry " + String.valueOf(entry))));
                    }
                    entry.addMessageIDs(existing.getMessageIDs());
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("New entry does not match existing, although request ID is the same " + String.valueOf(entry) + " != " + String.valueOf(existing))));
                }
                existing.setPduHandle(null);
            }
            PduHandle key = entry.getPduHandle();
            entry.setPduHandle(null);
            this.entries.put(key, entry);
            WeakReference<PduHandle> pduHandleReference = new WeakReference<PduHandle>(key);
            this.msgIdToPduHandleMapping.put(entry.getMsgID(), pduHandleReference);
            if (entry.getMessageIDs() != null) {
                for (MessageID id : entry.getMessageIDs()) {
                    this.msgIdToPduHandleMapping.put(id, pduHandleReference);
                }
            }
            return 0;
        }

        public synchronized boolean deleteEntry(PduHandle pduHandle) {
            StateReference<?> e = this.entries.remove(pduHandle);
            if (e != null) {
                this.msgIdToPduHandleMapping.remove(e.getMsgID());
                if (e.getMessageIDs() != null) {
                    for (MessageID messageID : e.getMessageIDs()) {
                        this.msgIdToPduHandleMapping.remove(messageID);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Serializable)((Object)("Removed msgId retry cache sub-entry: " + String.valueOf(messageID) + " from msgIdToPduHandleMapping: " + String.valueOf(pduHandle))));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Removed cache entry: " + String.valueOf(e) + " for " + String.valueOf(pduHandle))));
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn((Serializable)((Object)("Cache entry for pduHandle " + String.valueOf(pduHandle) + " prematurely garbage collected")));
            }
            return e != null;
        }

        public synchronized StateReference<?> getEntry(MessageID messageID, boolean removeFoundEntry) {
            WeakReference<PduHandle> pduHandleReference = this.msgIdToPduHandleMapping.get(messageID);
            if (pduHandleReference != null) {
                StateReference<?> e;
                PduHandle pduHandle = (PduHandle)pduHandleReference.get();
                if (pduHandle != null && (e = this.entries.get(pduHandle)) != null && e.isMatchingMessageID(messageID)) {
                    if (removeFoundEntry) {
                        this.deleteEntry(pduHandle);
                        this.entries.remove(pduHandle);
                        e.setPduHandle(pduHandle);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Removed cache entry on getEntry: " + String.valueOf(e) + " for msgID " + String.valueOf(messageID))));
                        }
                    }
                    return e;
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("PduHandle for messageID " + String.valueOf(messageID) + " not found in MPv3.Cache")));
            }
            return null;
        }

        public synchronized StateReference<?> popEntry(MessageID messageID) {
            return this.getEntry(messageID, true);
        }
    }

    public static class HeaderData
    implements BERSerializable {
        public static final byte FLAG_AUTH = 1;
        public static final byte FLAG_PRIV = 2;
        Integer32 msgID = new Integer32(0);
        Integer32 msgMaxSize = new Integer32(Integer.MAX_VALUE);
        OctetString msgFlags = new OctetString(new byte[1]);
        Integer32 securityModel = new Integer32(0);

        public void setMsgID(int msgID) {
            this.msgID.setValue(msgID);
        }

        public int getMsgID() {
            return this.msgID.getValue();
        }

        public void setMsgMaxSize(int msgMaxSize) {
            this.msgMaxSize.setValue(msgMaxSize);
        }

        public int getMsgMaxSize() {
            return this.msgMaxSize.getValue();
        }

        public void setMsgFlags(int flags) {
            this.msgFlags.getValue()[0] = (byte)flags;
        }

        public int getMsgFlags() {
            return this.msgFlags.getValue()[0] & 0xFF;
        }

        public void setSecurityModel(int model) {
            this.securityModel.setValue(model);
        }

        public int getSecurityModel() {
            return this.securityModel.getValue();
        }

        @Override
        public int getBERPayloadLength() {
            int length = this.msgID.getBERLength();
            length += this.msgMaxSize.getBERLength();
            length += this.msgFlags.getBERLength();
            return length += this.securityModel.getBERLength();
        }

        @Override
        public int getBERLength() {
            int length = this.getBERPayloadLength();
            length += BER.getBERLengthOfLength(length) + 1;
            return length;
        }

        @Override
        public void decodeBER(BERInputStream message) throws IOException {
            BER.MutableByte type = new BER.MutableByte();
            int length = BER.decodeHeader(message, type);
            if (type.getValue() != 48) {
                throw new IOException("Unexpected sequence header type: " + type.getValue());
            }
            long startPos = message.getPosition();
            this.msgID.decodeBER(message);
            this.msgMaxSize.decodeBER(message);
            if (this.msgMaxSize.getValue() < 484) {
                throw new IOException("Invalid msgMaxSize: " + String.valueOf(this.msgMaxSize));
            }
            this.msgFlags.decodeBER(message);
            if (this.msgFlags.length() != 1) {
                throw new IOException("Message flags length != 1: " + this.msgFlags.length());
            }
            this.securityModel.decodeBER(message);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("SNMPv3 header decoded: msgId=" + String.valueOf(this.msgID) + ", msgMaxSize=" + String.valueOf(this.msgMaxSize) + ", msgFlags=" + this.msgFlags.toHexString() + ", secModel=" + String.valueOf(this.securityModel))));
            }
            BER.checkSequenceLength(length, (int)(message.getPosition() - startPos), this);
        }

        @Override
        public void encodeBER(OutputStream outputStream) throws IOException {
            BER.encodeHeader(outputStream, 48, this.getBERPayloadLength());
            this.msgID.encodeBER(outputStream);
            this.msgMaxSize.encodeBER(outputStream);
            this.msgFlags.encodeBER(outputStream);
            this.securityModel.encodeBER(outputStream);
        }
    }

    protected static class CacheEntry<A extends Address>
    extends StateReference<A> {
        private static final long serialVersionUID = 8698046643337640719L;
        int msgID;
        long transactionID;
        byte[] secEngineID;
        SecurityModel secModel;
        byte[] secName;
        int secLevel;
        byte[] contextEngineID;
        byte[] contextName;
        SecurityStateReference secStateReference;
        int errorCode;

        public CacheEntry(int msgID, long reqID, byte[] secEngineID, SecurityModel secModel, byte[] secName, int secLevel, byte[] contextEngineID, byte[] contextName, SecurityStateReference secStateReference, int errorCode) {
            this.msgID = msgID;
            this.transactionID = reqID;
            this.secEngineID = secEngineID;
            this.secModel = secModel;
            this.secName = secName;
            this.secLevel = secLevel;
            this.contextEngineID = contextEngineID;
            this.contextName = contextName;
            this.secStateReference = secStateReference;
            this.errorCode = errorCode;
        }

        @Override
        public String toString() {
            return "CacheEntry{msgID=" + this.msgID + ", transactionID=" + this.transactionID + ", secEngineID=" + String.valueOf(OctetString.fromByteArray(this.secEngineID)) + ", secModel=" + String.valueOf(this.secModel) + ", secName=" + String.valueOf(OctetString.fromByteArray(this.secName)) + ", secLevel=" + this.secLevel + ", contextEngineID=" + String.valueOf(OctetString.fromByteArray(this.contextEngineID)) + ", contextName=" + String.valueOf(OctetString.fromByteArray(this.contextName)) + ", secStateReference=" + String.valueOf(this.secStateReference) + ", errorCode=" + this.errorCode + "}";
        }
    }
}

