/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Session;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentConfigManager;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.example.SampleAgent;
import org.snmp4j.agent.io.DefaultMOPersistenceProvider;
import org.snmp4j.agent.io.ImportMode;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.ext.StaticMOGroup;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.agent.mo.snmp.dh.DHKickstartParametersImpl;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.cfg.EngineBootsCounterFile;
import org.snmp4j.cfg.EngineBootsProvider;
import org.snmp4j.log.JavaLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.ThreadPool;

public class SnapshotAgent {
    public static final String COMMAND_LINE_OPTIONS = "-c[s{=SnapshotAgent.cfg}] -bc[s{=SnapshotAgent.bc}] +dhks[s] +u[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2|TLSv1.3)>] +dtls-version[s{=TLSv1.2}<(TLSv1.0|TLSv1.2)>]+Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword +ts[s] +cfg[s] +x ";
    public static final String COMMAND_LINE_PARAMS = "#snapshotFile[s] #address[s<(udp|tcp|tls|dtls):.*[/[0-9]+]?>] ..";
    private static final LogAdapter logger;
    protected String address;
    protected File snapshot;
    protected List<StaticMOGroup> groups = new ArrayList<StaticMOGroup>();
    protected AgentConfigManager agent;
    protected MOServer server;
    private final String configFile;
    private final File bootCounterFile;

    public SnapshotAgent(Map<String, List<Object>> args2) throws IOException {
        List<Object> snapshotPaths;
        File snapshot;
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        SNMP4JSettings.setReportSecurityLevelStrategy(SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded);
        try {
            logger.info("Max supported AES key length is " + Cipher.getMaxAllowedKeyLength("AES"));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("AES privacy not supported by this VM: ", e);
        }
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        String configFilename = null;
        if (args2.containsKey("cfg")) {
            configFilename = (String)ArgumentParser.getValue(args2, "cfg", 0);
        }
        this.configFile = (String)args2.get("c").get(0);
        this.bootCounterFile = new File((String)args2.get("bc").get(0));
        EngineBootsCounterFile engineBootsCounterFile = new EngineBootsCounterFile(this.bootCounterFile);
        OctetString ownEngineId = engineBootsCounterFile.getEngineId(new OctetString(MPv3.createLocalEngineID()));
        List<Object> tlsVersions = args2.get("tls-version");
        if (tlsVersions != null && !tlsVersions.isEmpty()) {
            System.setProperty("org.snmp4j.arg.tlsVersion", (String)tlsVersions.get(0));
        }
        if (!(snapshot = new File((String)(snapshotPaths = args2.get("snapshotFile")).get(0))).canRead()) {
            logger.fatal("Snapshot file cannot be read: " + String.valueOf(snapshot));
            return;
        }
        MOInputFactory configurationFactory = null;
        configurationFactory = this.createMOInputFactory(configFilename, ImportMode.restoreChanges);
        String dhKickstartInfoPath = (String)ArgumentParser.getFirstValue(args2.get("dhks"));
        DefaultMOPersistenceProvider persistenceProvider = new DefaultMOPersistenceProvider(moServers, this.configFile);
        this.setupAgent(args2, persistenceProvider, engineBootsCounterFile, ownEngineId, moServers, this.createMOInputFactory(configFilename, ImportMode.replaceCreate), args2.get("address"), dhKickstartInfoPath);
        this.snapshot = snapshot;
    }

    protected MOInputFactory createMOInputFactory(String configFilename, ImportMode importMode) {
        InputStream configInputStream = SampleAgent.class.getResourceAsStream("SampleAgentConfig.properties");
        Properties props = new Properties();
        if (configFilename != null) {
            try {
                configInputStream = new FileInputStream(configFilename);
            }
            catch (FileNotFoundException ex1) {
                logger.error("Config file '" + configFilename + "' not found: " + ex1.getMessage(), ex1);
                throw new RuntimeException(ex1);
            }
        }
        try {
            props.load(configInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MOInputFactory configurationFactory = () -> new PropertyMOInput(props, (VariableProvider)this.agent, importMode);
        return configurationFactory;
    }

    protected void setupAgent(final Map<String, List<Object>> args2, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider, OctetString engineID, MOServer[] moServers, MOInputFactory configurationFactory, List<Object> listenAddress, String dhKickstartInfoPath) {
        final MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        this.addListenAddresses(messageDispatcher, listenAddress);
        List<Object> dhKickstartParameters = Collections.emptyList();
        if (dhKickstartInfoPath != null) {
            File dhKickstartInfoFile = new File(dhKickstartInfoPath);
            if (dhKickstartInfoFile.canRead()) {
                try {
                    Properties kickstartProperties = new Properties();
                    FileInputStream fileInputStream = new FileInputStream(dhKickstartInfoFile);
                    kickstartProperties.load(fileInputStream);
                    fileInputStream.close();
                    dhKickstartParameters = DHKickstartParametersImpl.readFromProperties("org.snmp4j.", kickstartProperties);
                }
                catch (IOException iox) {
                    logger.error("Failed to load Diffie Hellman kickstart parameters from '" + dhKickstartInfoPath + "': " + iox.getMessage(), iox);
                }
            } else {
                logger.warn((Serializable)((Object)("Diffie Hellman kickstart parameters file cannot be read: " + String.valueOf(dhKickstartInfoFile))));
            }
        }
        final SnmpConfigurator snmpConfigurator = new SnmpConfigurator(true);
        this.agent = new AgentConfigManager(engineID, messageDispatcher, null, moServers, ThreadPool.create("SampleAgent", 3), configurationFactory, persistenceProvider, engineBootsProvider, null, dhKickstartParameters){

            @Override
            protected Session createSnmpSession(MessageDispatcher dispatcher) {
                Session session = super.createSnmpSession(dispatcher);
                snmpConfigurator.configure(session, this.getUsm(), messageDispatcher, args2);
                return session;
            }
        };
        this.agent.setContext(new SecurityModels(), new SecurityProtocols(SecurityProtocols.SecurityProtocolSet.maxCompatibility), new CounterSupport());
    }

    public void run() {
        this.agent.initialize();
        SNMPv2MIB context1SNMPv2MIB = new SNMPv2MIB(new OctetString(), new OID(), new Integer32(0));
        this.registerManagedObjects();
        this.agent.registerShutdownHook();
        this.agent.run();
    }

    protected void addListenAddresses(MessageDispatcher md, List<Object> addresses) {
        for (Object addressString : addresses) {
            Address address = GenericAddress.parse(addressString.toString());
            if (address == null) {
                logger.fatal("Could not parse address string '" + String.valueOf(addressString) + "'");
                return;
            }
            TransportMapping<Address> tm = TransportMappings.getInstance().createTransportMapping(address);
            if (tm != null) {
                md.addTransportMapping(tm);
                continue;
            }
            logger.warn((Serializable)((Object)("No transport mapping available for address '" + String.valueOf(address) + "'.")));
        }
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
    }

    protected void addUsmUser(USM usm) {
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("cpublic"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("cpublic"), new OctetString("v1v2group"), 3);
        vacm.addGroup(3, new OctetString("SHADES"), new OctetString("v3group"), 3);
        vacm.addGroup(3, new OctetString("TEST"), new OctetString("v3test"), 3);
        vacm.addGroup(3, new OctetString("SHA"), new OctetString("v3restricted"), 3);
        vacm.addGroup(3, new OctetString("v3notify"), new OctetString("v3restricted"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3group"), new OctetString(), 3, 3, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addAccess(new OctetString("v3restricted"), new OctetString(), 3, 1, 1, new OctetString("restrictedReadView"), new OctetString("restrictedWriteView"), new OctetString("restrictedNotifyView"), 3);
        vacm.addAccess(new OctetString("v3test"), new OctetString(), 3, 3, 1, new OctetString("testReadView"), new OctetString("testWriteView"), new OctetString("testNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("restrictedNotifyView"), new OID("1.3.6.1.6.3.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testReadView"), new OID("1.3.6.1.2.1.1"), new OctetString(), 2, 3);
        vacm.addViewTreeFamily(new OctetString("testWriteView"), new OID("1.3.6.1.2.1"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("testNotifyView"), new OID("1.3.6.1.2"), new OctetString(), 1, 3);
    }

    protected void registerManagedObjects() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.snapshot);
            ObjectInputStream ois = new ObjectInputStream(fis);
            List l = (List)ois.readObject();
            ois.close();
            logger.info("Snapshot file '" + String.valueOf(this.snapshot) + "' contains " + l.size() + " objects.");
            OctetString ctx = new OctetString();
            SortedMap<OID, OID> rootsCopy = SnapshotAgent.getSubtreeRoots(l);
            logger.info("Identified the following sub-trees " + String.valueOf(rootsCopy));
            for (OID root : rootsCopy.keySet()) {
                ArrayList<VariableBinding> subtree = new ArrayList<VariableBinding>();
                for (VariableBinding vb : l) {
                    if (vb.getOid().size() < root.size() || vb.getOid().leftMostCompare(root.size(), root) != 0) continue;
                    subtree.add(vb);
                }
                StaticMOGroup group = new StaticMOGroup(root, subtree.toArray(new VariableBinding[0]));
                DefaultMOContextScope scope = new DefaultMOContextScope(ctx, root, true, root.nextPeer(), false);
                MOServerLookupEvent lookupEvent = new MOServerLookupEvent(this, null, new DefaultMOQuery(scope, false), MOServerLookupEvent.IntendedUse.register, true);
                ManagedObject<?> mo = this.server.lookup(lookupEvent.getQuery(), null, lookupEvent);
                if (mo != null) {
                    logger.warn((Serializable)((Object)("Could not register snapshot subtree '" + String.valueOf(root) + "' with " + String.valueOf(subtree) + " because ManagedObject " + String.valueOf(mo) + " is already registered")));
                    for (VariableBinding vb : subtree) {
                        group = new StaticMOGroup(vb.getOid(), new VariableBinding[]{vb});
                        scope = new DefaultMOContextScope(ctx, vb.getOid(), true, vb.getOid().nextPeer(), false);
                        lookupEvent = new MOServerLookupEvent(this, null, new DefaultMOQuery(scope, false), MOServerLookupEvent.IntendedUse.register, true);
                        mo = this.server.lookup(lookupEvent.getQuery(), null, lookupEvent);
                        if (mo != null) {
                            logger.warn((Serializable)((Object)("Could not register single OID at " + String.valueOf(vb.getOid()) + " because ManagedObject " + String.valueOf(mo) + " is already registered.")));
                            continue;
                        }
                        this.groups.add(group);
                        this.server.register(group, null);
                        logger.info("Registered snapshot subtree '" + String.valueOf(root) + "' with " + String.valueOf(vb));
                        lookupEvent.completedUse(group);
                    }
                    continue;
                }
                this.groups.add(group);
                this.server.register(group, null);
                logger.info("Registered snapshot subtree '" + String.valueOf(root) + "' with " + String.valueOf(subtree));
                lookupEvent.completedUse(group);
            }
        }
        catch (Exception ex) {
            logger.error("Error while reading snapshot file '" + String.valueOf(this.snapshot) + "':" + ex.getMessage(), ex);
        }
    }

    static SortedMap<OID, OID> getSubtreeRoots(List<VariableBinding> l) {
        TreeMap<OID, OID> roots = new TreeMap<OID, OID>();
        for (VariableBinding vb : l) {
            OID rootCandidate;
            if (roots.isEmpty()) {
                OID rootCandidate2 = vb.getOid().trim();
                if (rootCandidate2.size() < 2) continue;
                roots.put(rootCandidate2, rootCandidate2);
                continue;
            }
            boolean rootFound = false;
            for (OID rootCandidate3 : roots.keySet()) {
                if (vb.getOid().startsWith(rootCandidate3)) {
                    rootFound = true;
                    break;
                }
                OID newRootCandidate = vb.getOid().trim();
                if (!rootCandidate3.startsWith(newRootCandidate)) continue;
                roots.remove(rootCandidate3);
                roots.put(newRootCandidate, newRootCandidate);
                rootFound = true;
            }
            if (rootFound || (rootCandidate = vb.getOid().trim()).size() < 2) continue;
            roots.put(rootCandidate, rootCandidate);
        }
        logger.info("Identified the following sub-tree candidates: " + String.valueOf(roots));
        TreeMap<OID, OID> rootsCopy = new TreeMap<OID, OID>();
        for (OID k : roots.keySet()) {
            if (k.size() <= 1) continue;
            OID sk = new OID(k.getValue(), 0, k.size() - 1);
            while (sk.size() > 0 && roots.get(sk) == null) {
                sk.trim(1);
            }
            if (sk.size() != 0) continue;
            rootsCopy.put(k, k);
        }
        return rootsCopy;
    }

    protected void unregisterManagedObjects() {
        for (StaticMOGroup mo : this.groups) {
            this.server.unregister(mo, null);
        }
    }

    public static void main(String[] args2) {
        ArgumentParser parser = new ArgumentParser(COMMAND_LINE_OPTIONS, COMMAND_LINE_PARAMS);
        try {
            Map<String, List<Object>> commandLineParameters = parser.parse(args2);
            if (commandLineParameters.containsKey("x")) {
                SNMP4JSettings.setExtensibilityEnabled(true);
            }
            SnapshotAgent snapshotAgent = new SnapshotAgent(commandLineParameters);
            SecurityProtocols.getInstance().addDefaultProtocols();
            snapshotAgent.run();
        }
        catch (IOException | ParseException ex) {
            ex.printStackTrace();
        }
    }

    static {
        LogFactory.setLogFactory(new JavaLogFactory());
        logger = LogFactory.getLogger(SnapshotAgent.class);
    }
}

