/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp.tc;

import java.io.IOException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpEngineIDTC
implements TextualConvention<OctetString> {
    private OctetString snmpEngineID;

    public SnmpEngineIDTC(OctetString snmpEngineID) {
        this.snmpEngineID = snmpEngineID;
    }

    @Override
    public String getModuleName() {
        return "SNMP-FRAMEWORK-MIB";
    }

    @Override
    public String getName() {
        return "SnmpEngineID";
    }

    @Override
    public MOScalar<OctetString> createScalar(OID oid, MOAccess access, OctetString value) {
        return new SnmpEngineIdScalar(oid, access, value);
    }

    @Override
    public MOColumn<OctetString> createColumn(int columnID, int syntax, MOAccess access, OctetString defaultValue, boolean mutableInService) {
        return new SnmpEngineIdColumn(columnID, syntax, access, defaultValue, mutableInService);
    }

    @Override
    public OctetString createInitialValue() {
        return this.snmpEngineID;
    }

    private class SnmpEngineIdScalar
    extends MOScalar<OctetString> {
        public SnmpEngineIdScalar(OID id, MOAccess access, OctetString value) {
            super(id, access, value);
        }

        @Override
        public synchronized void load(MOInput input) throws IOException {
            super.load(input);
            if (((OctetString)this.getValue()).length() == 0) {
                this.setValue(SnmpEngineIDTC.this.snmpEngineID);
            }
        }

        @Override
        public synchronized void save(MOOutput output) throws IOException {
            OctetString engineID = (OctetString)this.getValue();
            if (engineID == null || engineID.equals(SnmpEngineIDTC.this.snmpEngineID)) {
                output.writeVariable(new OctetString());
            } else {
                super.save(output);
            }
        }
    }

    private class SnmpEngineIdColumn
    extends MOMutableColumn<OctetString> {
        public SnmpEngineIdColumn(int columnID, int syntax, MOAccess access, OctetString defaultValue, boolean mutableInService) {
            super(columnID, syntax, access, defaultValue, mutableInService);
        }

        @Override
        public Variable getRestoreValue(Variable[] rowValues, int column) {
            Variable variable = rowValues[column];
            if (variable == null || !(variable instanceof OctetString) || ((OctetString)variable).length() == 0) {
                return SnmpEngineIDTC.this.snmpEngineID;
            }
            return rowValues[column];
        }

        @Override
        public Variable getStoreValue(MOTableRow row, int column) {
            if (SnmpEngineIDTC.this.snmpEngineID.equals(row.getValue(column))) {
                return new OctetString();
            }
            return row.getValue(column);
        }
    }
}

