/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.util.GregorianCalendar;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.snmp.DateAndTime;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class DateAndTimeScalar<T extends OctetString>
extends MOScalar<T> {
    private boolean localtime;

    public DateAndTimeScalar(OID oid, MOAccess access, T value) {
        this(oid, access, value, false);
    }

    public DateAndTimeScalar(OID oid, MOAccess access, T value, boolean localtime) {
        super(oid, access, value);
        this.localtime = localtime;
    }

    @Override
    public int isValueOK(SubRequest<?> sreq) {
        return DateAndTime.validateDateAndTime(sreq.getVariableBinding().getVariable());
    }

    @Override
    public T getValue() {
        OctetString value = (OctetString)super.getValue();
        if (this.localtime) {
            DateAndTime.makeDateAndTime(new GregorianCalendar(), value);
        }
        return (T)value;
    }

    public void setCalendar(GregorianCalendar calendar) {
        this.setValue(DateAndTime.makeDateAndTime(calendar, this.getValue()));
    }

    public GregorianCalendar getCalendar() {
        return DateAndTime.makeCalendar((OctetString)this.getValue());
    }
}

