/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.db.sample;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import jetbrains.exodus.env.Environments;
import org.jetbrains.annotations.NotNull;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Session;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentConfigManager;
import org.snmp4j.agent.AgentState;
import org.snmp4j.agent.AgentStateListener;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.db.MOXodusPersistence;
import org.snmp4j.agent.db.MOXodusPersistenceProvider;
import org.snmp4j.agent.io.ImportMode;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.snmp.dh.DHKickstartParametersImpl;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.DTLSTM;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.SnmpConfigurator;
import org.snmp4j.util.ThreadPool;

public class SampleAgent
implements AgentStateListener<AgentConfigManager> {
    public static final String COMMAND_LINE_OPTIONS = "-c[s{=SampleAgent.cfg}] +dhks[s] +u[s] +tls-trust-ca[s] +tls-peer-id[s] +tls-local-id[s] +tls-version[s{=TLSv1}<(TLSv1|TLSv1.1|TLSv1.2|TLSv1.3)>] +dtls-version[s{=TLSv1.2}<(TLSv1.0|TLSv1.2)>]+Djavax.net.ssl.keyStore +Djavax.net.ssl.keyStorePassword +Djavax.net.ssl.trustStore +Djavax.net.ssl.trustStorePassword +ts[s] +cfg[s] ";
    public static final String COMMAND_LINE_PARAMS = "#address[s<(udp|tcp|tls|dtls):.*[/[0-9]+]?>] ..";
    private static final LogAdapter logger;
    protected AgentConfigManager agent;
    protected MOServer server;
    private final String configFile;
    private final MOXodusPersistence moXodusPersistence;
    protected Properties tableSizeLimits;

    public SampleAgent(Map<String, List<Object>> args2) {
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        try {
            logger.info("Max supported AES key length is " + Cipher.getMaxAllowedKeyLength("AES"));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("AES privacy not supported by this VM: ", e);
        }
        this.server = new DefaultMOServer();
        MOServer[] moServers = new MOServer[]{this.server};
        String configFilename = null;
        if (args2.containsKey("cfg")) {
            configFilename = (String)ArgumentParser.getValue(args2, "cfg", 0);
        }
        this.configFile = (String)args2.get("c").get(0);
        this.moXodusPersistence = new MOXodusPersistence(moServers, Environments.newInstance(this.configFile));
        List<Object> tlsVersions = args2.get("tls-version");
        if (tlsVersions != null && tlsVersions.size() > 0) {
            System.setProperty("org.snmp4j.arg.tlsVersion", (String)tlsVersions.get(0));
        }
        MOInputFactory configurationFactory = null;
        if (!this.moXodusPersistence.isContextLoadable(null)) {
            configurationFactory = this.createMOInputFactory(configFilename, ImportMode.restoreChanges);
        }
        this.tableSizeLimits = SampleAgent.getTableSizeLimitsProperties(args2);
        String dhKickstartInfoPath = (String)ArgumentParser.getFirstValue(args2.get("dhks"));
        this.setupAgent(args2, moServers, configurationFactory, args2.get("address"), dhKickstartInfoPath);
    }

    protected static Properties getTableSizeLimitsProperties(Map<String, List<Object>> args2) {
        InputStream tableSizeLimitsInputStream = SampleAgent.class.getResourceAsStream("SampleAgentTableSizeLimits.properties");
        if (args2.containsKey("ts")) {
            try {
                tableSizeLimitsInputStream = new FileInputStream((String)ArgumentParser.getValue(args2, "ts", 0));
            }
            catch (FileNotFoundException ex1) {
                ex1.printStackTrace();
            }
        }
        Properties tableSizeLimits = new Properties();
        try {
            tableSizeLimits.load(tableSizeLimitsInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return tableSizeLimits;
    }

    @NotNull
    protected MOInputFactory createMOInputFactory(String configFilename, ImportMode importMode) {
        InputStream configInputStream = SampleAgent.class.getResourceAsStream("SampleAgentConfig.properties");
        Properties props = new Properties();
        if (configFilename != null) {
            try {
                configInputStream = new FileInputStream(configFilename);
            }
            catch (FileNotFoundException ex1) {
                logger.error("Config file '" + configFilename + "' not found: " + ex1.getMessage(), ex1);
                throw new RuntimeException(ex1);
            }
        }
        try {
            props.load(configInputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        MOInputFactory configurationFactory = () -> new PropertyMOInput(props, (VariableProvider)this.agent, importMode);
        return configurationFactory;
    }

    protected SampleAgent(Map<String, List<Object>> args2, MOServer[] moServers, MOXodusPersistence xodusPersistence, Properties tableSizeLimits, ImportMode importMode) {
        this.server = new DefaultMOServer();
        this.moXodusPersistence = xodusPersistence;
        List<Object> tlsVersions = args2.get("tls-version");
        if (tlsVersions != null && tlsVersions.size() > 0) {
            System.setProperty("org.snmp4j.arg.tlsVersion", (String)tlsVersions.get(0));
        }
        String configFilename = null;
        if (args2.containsKey("cfg")) {
            configFilename = (String)ArgumentParser.getValue(args2, "cfg", 0);
        }
        this.configFile = (String)args2.get("c").get(0);
        this.tableSizeLimits = tableSizeLimits;
        String dhKickstartInfoPath = (String)ArgumentParser.getFirstValue(args2.get("dhks"));
        this.setupAgent(args2, moServers, this.createMOInputFactory(configFilename, importMode), args2.get("address"), dhKickstartInfoPath);
    }

    protected void setupAgent(final Map<String, List<Object>> args2, MOServer[] moServers, MOInputFactory configurationFactory, List<Object> listenAddress, String dhKickstartInfoPath) {
        final MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
        this.addListenAddresses(messageDispatcher, listenAddress);
        List<Object> dhKickstartParameters = Collections.emptyList();
        if (dhKickstartInfoPath != null) {
            File dhKickstartInfoFile = new File(dhKickstartInfoPath);
            if (dhKickstartInfoFile.canRead()) {
                try {
                    Properties kickstartProperties = new Properties();
                    FileInputStream fileInputStream = new FileInputStream(dhKickstartInfoFile);
                    kickstartProperties.load(fileInputStream);
                    fileInputStream.close();
                    dhKickstartParameters = DHKickstartParametersImpl.readFromProperties("org.snmp4j.", kickstartProperties);
                }
                catch (IOException iox) {
                    logger.error("Failed to load Diffie Hellman kickstart parameters from '" + dhKickstartInfoPath + "': " + iox.getMessage(), iox);
                }
            } else {
                logger.warn((Serializable)((Object)("Diffie Hellman kickstart parameters file cannot be read: " + String.valueOf(dhKickstartInfoFile))));
            }
        }
        MOXodusPersistenceProvider moXodusPersistenceProvider = new MOXodusPersistenceProvider(this.moXodusPersistence);
        OctetString defaultEngineID = new OctetString(MPv3.createLocalEngineID());
        OctetString engineID = moXodusPersistenceProvider.getEngineId(defaultEngineID);
        final SnmpConfigurator snmpConfigurator = new SnmpConfigurator(true);
        this.agent = new AgentConfigManager(engineID, messageDispatcher, null, moServers, ThreadPool.create("SampleAgent", 3), configurationFactory, moXodusPersistenceProvider, moXodusPersistenceProvider, null, dhKickstartParameters){

            @Override
            protected Session createSnmpSession(MessageDispatcher dispatcher) {
                Session session = super.createSnmpSession(dispatcher);
                snmpConfigurator.configure(session, this.getUsm(), messageDispatcher, args2);
                return session;
            }
        };
        this.agent.addAgentStateListener(this);
    }

    protected void addListenAddresses(MessageDispatcher md, List<Object> addresses) {
        for (Object addressString : addresses) {
            Address address = GenericAddress.parse(addressString.toString());
            if (address == null) {
                logger.fatal("Could not parse address string '" + String.valueOf(addressString) + "'");
                return;
            }
            TransportMapping<Address> tm = TransportMappings.getInstance().createTransportMapping(address);
            if (tm != null) {
                if (tm instanceof DTLSTM) {
                    ((DTLSTM)tm).setServerEnabled(true);
                }
                md.addTransportMapping(tm);
                continue;
            }
            logger.warn((Serializable)((Object)("No transport mapping available for address '" + String.valueOf(address) + "'.")));
        }
    }

    public void run() {
        this.agent.initialize();
        this.agent.setupProxyForwarder();
        this.registerMIBs();
        this.agent.setTableSizeLimits(this.tableSizeLimits);
        this.agent.registerShutdownHook();
        this.agent.run();
    }

    protected MOFactory getFactory() {
        return DefaultMOFactory.getInstance();
    }

    protected void registerMIBs() {
    }

    public static void main(String[] args2) {
        ArgumentParser parser = new ArgumentParser(COMMAND_LINE_OPTIONS, COMMAND_LINE_PARAMS);
        try {
            Map<String, List<Object>> commandLineParameters = parser.parse(args2);
            SampleAgent sampleAgent = new SampleAgent(commandLineParameters);
            SecurityProtocols.getInstance().addDefaultProtocols();
            sampleAgent.run();
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public void agentStateChanged(AgentConfigManager agentConfigManager, AgentState newState) {
        switch (newState.getState()) {
            case 10: {
                this.moXodusPersistence.registerChangeListenersWithServer(this.server);
                break;
            }
            case -1: {
                this.moXodusPersistence.unregisterChangeListenersWithServer(this.server);
            }
        }
    }

    static {
        LogFactory.setLogFactory(new ConsoleLogFactory());
        SNMP4JSettings.setSecretLoggingEnabled(true);
        logger = LogFactory.getLogger(SampleAgent.class);
    }
}

