/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.Map;
import java.util.TreeMap;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.smi.OctetString;

public class ProxyMap {
    private Map<ProxyKey, ProxyForwarder> proxies = new TreeMap<ProxyKey, ProxyForwarder>();

    public ProxyForwarder add(ProxyForwarder proxyForwarder, OctetString contextEngineID, int proxyType) {
        return this.proxies.put(new ProxyKey(contextEngineID, proxyType), proxyForwarder);
    }

    public ProxyForwarder remove(OctetString contextEngineID, int proxyType) {
        return this.proxies.remove(new ProxyKey(contextEngineID, proxyType));
    }

    public ProxyForwarder get(OctetString contextEngineID, int proxyType) {
        ProxyForwarder proxy = this.proxies.get(new ProxyKey(contextEngineID, proxyType));
        if (proxy == null) {
            proxy = this.proxies.get(new ProxyKey(null, proxyType));
        }
        return proxy;
    }

    static class ProxyKey
    implements Comparable<ProxyKey> {
        private OctetString contextEngineID;
        private int proxyType;

        ProxyKey(OctetString contextEngineID, int proxyType) {
            this.contextEngineID = contextEngineID;
            this.proxyType = proxyType;
        }

        @Override
        public int compareTo(ProxyKey other) {
            if (this.contextEngineID == null && other.contextEngineID != null || other.contextEngineID == null && this.contextEngineID != null || other.contextEngineID == null && this.contextEngineID == null || this.contextEngineID.equals(other.contextEngineID)) {
                if (this.proxyType == 0 || other.proxyType == 0) {
                    return 0;
                }
                return this.proxyType - other.proxyType;
            }
            return this.contextEngineID.compareTo(other.contextEngineID);
        }
    }
}

