/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import jetbrains.exodus.system.JVMConstants;
import jetbrains.exodus.util.SafeByteBufferCleaner;
import jetbrains.exodus.util.UnsafeHolder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/util/SafeByteBufferCleaner;", "", "()V", "cleanMethod", "Ljava/lang/reflect/Method;", "dbbCleanerMethod", "dbbFreeMethod", "directByteBufferClass", "Ljava/lang/Class;", "invokeCleanerMethod", "clean", "", "buffer", "Ljava/nio/ByteBuffer;", "getDirectByteBufferCleanerMethod", "getDirectByteBufferFreeMethod", "getDirectByteBufferMethod", "name", "", "xodus-utils"})
public final class SafeByteBufferCleaner {
    @NotNull
    public static final SafeByteBufferCleaner INSTANCE = new SafeByteBufferCleaner();
    @Nullable
    private static final Method invokeCleanerMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged(invokeCleanerMethod.1.INSTANCE);
    @NotNull
    private static final Class<?> directByteBufferClass;
    @Nullable
    private static final Method dbbFreeMethod;
    @Nullable
    private static final Method dbbCleanerMethod;
    @Nullable
    private static final Method cleanMethod;

    private SafeByteBufferCleaner() {
    }

    @JvmStatic
    public static final void clean(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        try {
            UnsafeHolder.INSTANCE.doPrivileged((Function0)new Function0<Unit>(buffer){
                final /* synthetic */ ByteBuffer $buffer;
                {
                    this.$buffer = $buffer;
                    super(0);
                }

                public final void invoke() {
                    if (JVMConstants.INSTANCE.getIS_JAVA9_OR_HIGHER() && SafeByteBufferCleaner.access$getInvokeCleanerMethod$p() != null) {
                        try {
                            Object[] objectArray = new Object[]{this.$buffer};
                            SafeByteBufferCleaner.access$getInvokeCleanerMethod$p().invoke(UnsafeHolder.INSTANCE.getTheUnsafe(), objectArray);
                            return;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                    if (Intrinsics.areEqual(this.$buffer.getClass().getSimpleName(), "MappedByteBufferAdapter")) {
                        if (!JVMConstants.getIS_ANDROID()) {
                            throw new RuntimeException("MappedByteBufferAdapter only supported for Android");
                        }
                        Method method = SafeByteBufferCleaner.access$getDbbFreeMethod$p();
                        if (method != null) {
                            method.invoke((Object)this.$buffer, new Object[0]);
                        }
                    } else if (SafeByteBufferCleaner.access$getDbbCleanerMethod$p() != null && SafeByteBufferCleaner.access$getCleanMethod$p() != null) {
                        Object cleaner;
                        Object object = cleaner = SafeByteBufferCleaner.access$getDbbCleanerMethod$p().invoke((Object)this.$buffer, new Object[0]);
                        if (object != null) {
                            Object it = object;
                            boolean bl = false;
                            SafeByteBufferCleaner.access$getCleanMethod$p().invoke(cleaner, new Object[0]);
                        }
                    } else if (JVMConstants.getIS_ANDROID()) {
                        Method method = SafeByteBufferCleaner.access$getDbbFreeMethod$p();
                        if (method != null) {
                            method.invoke((Object)this.$buffer, new Object[0]);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    private final Method getDirectByteBufferFreeMethod() {
        return this.getDirectByteBufferMethod("cleaner");
    }

    private final Method getDirectByteBufferCleanerMethod() {
        return this.getDirectByteBufferMethod("cleaner");
    }

    private final Method getDirectByteBufferMethod(String name) {
        Method method;
        try {
            Method $this$getDirectByteBufferMethod_u24lambda_u2d0 = method = directByteBufferClass.getMethod(name, new Class[0]);
            boolean bl = false;
            $this$getDirectByteBufferMethod_u24lambda_u2d0.setAccessible(true);
        }
        catch (Throwable t) {
            method = null;
        }
        return method;
    }

    public static final /* synthetic */ Method access$getInvokeCleanerMethod$p() {
        return invokeCleanerMethod;
    }

    public static final /* synthetic */ Method access$getDbbFreeMethod$p() {
        return dbbFreeMethod;
    }

    public static final /* synthetic */ Method access$getDbbCleanerMethod$p() {
        return dbbCleanerMethod;
    }

    public static final /* synthetic */ Method access$getCleanMethod$p() {
        return cleanMethod;
    }

    public static final /* synthetic */ Method access$getDirectByteBufferFreeMethod(SafeByteBufferCleaner $this) {
        return $this.getDirectByteBufferFreeMethod();
    }

    public static final /* synthetic */ Method access$getDirectByteBufferCleanerMethod(SafeByteBufferCleaner $this) {
        return $this.getDirectByteBufferCleanerMethod();
    }

    static {
        Object t = UnsafeHolder.INSTANCE.doPrivileged(directByteBufferClass.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(t, "doPrivileged { Class.for\u2026.nio.DirectByteBuffer\") }");
        directByteBufferClass = (Class)t;
        dbbFreeMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged(dbbFreeMethod.1.INSTANCE);
        dbbCleanerMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged(dbbCleanerMethod.1.INSTANCE);
        cleanMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged(cleanMethod.1.INSTANCE);
    }
}

