/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.bindings.CompressedUnsignedLongArrayByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.SingleByteIterable;
import jetbrains.exodus.log.TooBigLoggableException;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.ChildReferenceMutable;
import jetbrains.exodus.tree.patricia.ChildReferenceSet;
import jetbrains.exodus.tree.patricia.ImmutableNode;
import jetbrains.exodus.tree.patricia.ImmutableNodeKt;
import jetbrains.exodus.tree.patricia.MutableNodeKt;
import jetbrains.exodus.tree.patricia.MutableNodeSaveContext;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0010\u0018\u00002\u00020\u0001:\u0001GB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0000J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0001H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010 \u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u000e\u0010 \u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010#\u001a\u00020$J\u0018\u0010-\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0012J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u000201J\u0016\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020$2\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020\u00002\u0006\u0010/\u001a\u00020$2\u0006\u00100\u001a\u000201J\u0006\u00103\u001a\u00020\u000fJ\b\u00104\u001a\u00020\u000fH\u0016J\u000e\u00105\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020*J\u000e\u00106\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0012J\u0016\u00107\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020*2\u0006\u00108\u001a\u000209J\u0018\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\u00020\u00162\u0006\u0010;\u001a\u00020$2\u0006\u0010<\u001a\u00020=H\u0002J\u0016\u0010?\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0000J\u0016\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0000J\u0010\u0010A\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010B\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0000J\u0012\u0010C\u001a\u00020\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0016\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020\u0012J\u0016\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020$R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006H"}, d2={"Ljetbrains/exodus/tree/patricia/MutableNode;", "Ljetbrains/exodus/tree/patricia/NodeBase;", "origin", "Ljetbrains/exodus/tree/patricia/ImmutableNode;", "(Ljetbrains/exodus/tree/patricia/ImmutableNode;)V", "keySequence", "Ljetbrains/exodus/ByteIterable;", "(Ljetbrains/exodus/ByteIterable;)V", "value", "children", "Ljetbrains/exodus/tree/patricia/ChildReferenceSet;", "(Ljetbrains/exodus/ByteIterable;Ljetbrains/exodus/ByteIterable;Ljetbrains/exodus/tree/patricia/ChildReferenceSet;)V", "getChildren$xodus_environment", "()Ljetbrains/exodus/tree/patricia/ChildReferenceSet;", "isRoot", "", "()Z", "loggableType", "", "getLoggableType", "()B", "addRightChild", "", "b", "child", "copyChildrenFrom", "node", "getAddress", "", "getChild", "tree", "Ljetbrains/exodus/tree/patricia/PatriciaTreeBase;", "getChildren", "Ljetbrains/exodus/tree/patricia/NodeChildren;", "Ljetbrains/exodus/tree/patricia/NodeChildrenIterator;", "pos", "", "getChildrenCount", "getChildrenLast", "getChildrenRange", "getMutableCopy", "mutableTree", "Ljetbrains/exodus/tree/patricia/PatriciaTreeMutable;", "getRef", "Ljetbrains/exodus/tree/patricia/ChildReference;", "getRightChild", "hang", "firstByte", "tail", "Ljetbrains/exodus/ByteIterator;", "hangRight", "hasChildren", "isMutable", "mergeWithSingleChild", "removeChild", "save", "context", "Ljetbrains/exodus/tree/patricia/MutableNodeSaveContext;", "saveChildrenV1", "childrenCount", "nodeStream", "Ljetbrains/exodus/util/LightOutputStream;", "saveChildrenV2", "setChild", "index", "setKeySequence", "setRightChild", "setValue", "splitKey", "prefixLength", "nextByte", "MutableNodeChildrenIterator", "xodus-environment"})
public class MutableNode
extends NodeBase {
    @NotNull
    private final ChildReferenceSet children;

    @NotNull
    public final ChildReferenceSet getChildren$xodus_environment() {
        return this.children;
    }

    public MutableNode(@NotNull ImmutableNode origin) {
        Intrinsics.checkNotNullParameter(origin, "origin");
        super(origin.keySequence, origin.value);
        this.children = new ChildReferenceSet();
        this.copyChildrenFrom(origin);
    }

    public MutableNode(@NotNull ByteIterable keySequence) {
        Intrinsics.checkNotNullParameter(keySequence, "keySequence");
        this(keySequence, null, new ChildReferenceSet());
    }

    public MutableNode(@NotNull ByteIterable keySequence, @Nullable ByteIterable value, @NotNull ChildReferenceSet children) {
        Intrinsics.checkNotNullParameter(keySequence, "keySequence");
        Intrinsics.checkNotNullParameter(children, "children");
        super(keySequence, value);
        this.children = children;
    }

    public void setKeySequence(@NotNull ByteIterable keySequence) {
        Intrinsics.checkNotNullParameter(keySequence, "keySequence");
        this.keySequence = keySequence;
    }

    public void setValue(@Nullable ByteIterable value) {
        this.value = value;
    }

    @Override
    public long getAddress() {
        return -1L;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    @NotNull
    public MutableNode getMutableCopy(@NotNull PatriciaTreeMutable mutableTree) {
        Intrinsics.checkNotNullParameter(mutableTree, "mutableTree");
        return this;
    }

    @NotNull
    public final ChildReference getRef(int pos) {
        ChildReference childReference = this.children.referenceAt(pos);
        Intrinsics.checkNotNullExpressionValue(childReference, "children.referenceAt(pos)");
        return childReference;
    }

    @Override
    @Nullable
    public NodeBase getChild(@NotNull PatriciaTreeBase tree, byte b2) {
        ChildReference ref;
        Intrinsics.checkNotNullParameter(tree, "tree");
        ChildReference childReference = ref = this.children.get(b2);
        return childReference == null ? null : childReference.getNode(tree);
    }

    @Override
    @NotNull
    public NodeChildren getChildren() {
        return new NodeChildren(this){
            final /* synthetic */ MutableNode this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public NodeChildrenIterator iterator() {
                return this.this$0.getChildren$xodus_environment().isEmpty() ? (NodeChildrenIterator)this.this$0.new NodeBase.EmptyNodeChildrenIterator() : (NodeChildrenIterator)new MutableNodeChildrenIterator(this.this$0, this.this$0.getChildren$xodus_environment());
            }
        };
    }

    @Override
    @NotNull
    public NodeChildrenIterator getChildren(byte b2) {
        int index2 = this.children.searchFor(b2);
        if (index2 < 0) {
            return new NodeBase.EmptyNodeChildrenIterator();
        }
        ChildReferenceSet.ChildReferenceIterator childReferenceIterator = this.children.iterator(index2);
        Intrinsics.checkNotNullExpressionValue(childReferenceIterator, "children.iterator(index)");
        return new MutableNodeChildrenIterator(this, childReferenceIterator);
    }

    @Override
    @NotNull
    public NodeChildrenIterator getChildrenLast() {
        return this.getChildren(this.children.size());
    }

    @NotNull
    public final NodeChildrenIterator getChildren(int pos) {
        ChildReferenceSet.ChildReferenceIterator childReferenceIterator = this.children.iterator(pos);
        Intrinsics.checkNotNullExpressionValue(childReferenceIterator, "children.iterator(pos)");
        return new MutableNodeChildrenIterator(this, childReferenceIterator);
    }

    @Override
    @NotNull
    public NodeChildrenIterator getChildrenRange(byte b2) {
        if (this.children.isEmpty()) {
            return new NodeBase.EmptyNodeChildrenIterator();
        }
        int index2 = this.children.searchFor(b2);
        if (index2 < 0) {
            index2 = -index2 - 1;
        }
        ChildReferenceSet.ChildReferenceIterator childReferenceIterator = this.children.iterator(index2);
        Intrinsics.checkNotNullExpressionValue(childReferenceIterator, "children.iterator(index)");
        return new MutableNodeChildrenIterator(this, childReferenceIterator);
    }

    @Override
    public int getChildrenCount() {
        return this.children.size();
    }

    public final boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public final void setChild(byte b2, @NotNull MutableNode child) {
        Intrinsics.checkNotNullParameter(child, "child");
        int index2 = this.children.searchFor(b2);
        if (index2 < 0) {
            this.children.insertAt(-index2 - 1, new ChildReferenceMutable(b2, child));
        } else {
            ChildReference ref = this.children.referenceAt(index2);
            if (ref.isMutable()) {
                if (ref == null) {
                    throw new NullPointerException("null cannot be cast to non-null type jetbrains.exodus.tree.patricia.ChildReferenceMutable");
                }
                ((ChildReferenceMutable)ref).child = child;
            } else {
                this.children.setAt(index2, new ChildReferenceMutable(b2, child));
            }
        }
    }

    public final void setChild(int index2, @NotNull MutableNode child) {
        Intrinsics.checkNotNullParameter(child, "child");
        ChildReference ref = this.children.referenceAt(index2);
        if (ref.isMutable()) {
            if (ref == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.exodus.tree.patricia.ChildReferenceMutable");
            }
            ((ChildReferenceMutable)ref).child = child;
        } else {
            this.children.setAt(index2, new ChildReferenceMutable(ref.firstByte, child));
        }
    }

    @Nullable
    public final NodeBase getRightChild(@NotNull PatriciaTreeBase tree, byte b2) {
        Intrinsics.checkNotNullParameter(tree, "tree");
        ChildReference childReference = this.children.getRight();
        if (childReference == null) {
            return null;
        }
        ChildReference ref = childReference;
        int firstByte = ImmutableNodeKt.getUnsigned(ref.firstByte);
        int rightByte = ImmutableNodeKt.getUnsigned(b2);
        if (!(rightByte >= firstByte)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return rightByte > firstByte ? null : ref.getNode(tree);
    }

    public final void addRightChild(byte b2, @NotNull MutableNode child) {
        Intrinsics.checkNotNullParameter(child, "child");
        ChildReference right = this.children.getRight();
        if (!(right == null || ImmutableNodeKt.getUnsigned(right.firstByte) < ImmutableNodeKt.getUnsigned(b2))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.children.putRight(new ChildReferenceMutable(b2, child));
    }

    public final void setRightChild(byte b2, @NotNull MutableNode child) {
        Intrinsics.checkNotNullParameter(child, "child");
        ChildReference right = this.children.getRight();
        if (!(right != null && ImmutableNodeKt.getUnsigned(right.firstByte) == ImmutableNodeKt.getUnsigned(b2))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.children.setAt(this.children.size() - 1, new ChildReferenceMutable(b2, child));
    }

    public final boolean removeChild(byte b2) {
        return this.children.remove(b2);
    }

    @NotNull
    public final MutableNode splitKey(int prefixLength, byte nextByte) {
        ByteIterable byteIterable;
        ByteIterable byteIterable2;
        byte[] keyBytes = this.keySequence.getBytesUnsafe();
        switch (prefixLength) {
            case 0: {
                byteIterable2 = ByteIterable.EMPTY;
                break;
            }
            case 1: {
                byteIterable2 = SingleByteIterable.getIterable(keyBytes[0]);
                break;
            }
            default: {
                byteIterable2 = new ArrayByteIterable(keyBytes, prefixLength);
            }
        }
        ByteIterable prefixKey = byteIterable2;
        Intrinsics.checkNotNullExpressionValue(prefixKey, "prefixKey");
        MutableNode prefix = new MutableNode(prefixKey);
        int suffixLength = this.keySequence.getLength() - prefixLength - 1;
        switch (suffixLength) {
            case 0: {
                byteIterable = ByteIterable.EMPTY;
                break;
            }
            case 1: {
                byteIterable = SingleByteIterable.getIterable(keyBytes[prefixLength + 1]);
                break;
            }
            default: {
                byteIterable = this.keySequence.subIterable(prefixLength + 1, suffixLength);
            }
        }
        ByteIterable suffixKey = byteIterable;
        Intrinsics.checkNotNullExpressionValue(suffixKey, "suffixKey");
        MutableNode suffix = new MutableNode(suffixKey, this.value, this.children);
        prefix.setChild(nextByte, suffix);
        return prefix;
    }

    @NotNull
    public final MutableNode splitKey(int prefixLength, int nextByte) {
        return this.splitKey(prefixLength, (byte)nextByte);
    }

    public final void mergeWithSingleChild(@NotNull PatriciaTreeMutable tree) {
        Intrinsics.checkNotNullParameter(tree, "tree");
        ChildReference childReference = (ChildReference)this.getChildren().iterator().next();
        if (childReference == null) {
            throw new IllegalStateException("A child is expected");
        }
        ChildReference ref = childReference;
        ByteIterable[] byteIterableArray = ref.getNode(tree);
        Intrinsics.checkNotNullExpressionValue(byteIterableArray, "ref.getNode(tree)");
        ByteIterable[] child = byteIterableArray;
        this.value = child.value;
        byteIterableArray = new ByteIterable[]{this.keySequence, SingleByteIterable.getIterable(ref.firstByte), child.keySequence};
        this.keySequence = new CompoundByteIterable(byteIterableArray);
        this.copyChildrenFrom((NodeBase)child);
    }

    @NotNull
    public final MutableNode hang(byte firstByte, @NotNull ByteIterator tail) {
        Intrinsics.checkNotNullParameter(tail, "tail");
        MutableNode result = new MutableNode(new ArrayByteIterable(tail));
        this.setChild(firstByte, result);
        return result;
    }

    @NotNull
    public final MutableNode hang(int firstByte, @NotNull ByteIterator tail) {
        Intrinsics.checkNotNullParameter(tail, "tail");
        return this.hang((byte)firstByte, tail);
    }

    @NotNull
    public final MutableNode hangRight(byte firstByte, @NotNull ByteIterator tail) {
        Intrinsics.checkNotNullParameter(tail, "tail");
        MutableNode result = new MutableNode(new ArrayByteIterable(tail));
        this.addRightChild(firstByte, result);
        return result;
    }

    @NotNull
    public final MutableNode hangRight(int firstByte, @NotNull ByteIterator tail) {
        Intrinsics.checkNotNullParameter(tail, "tail");
        return this.hangRight((byte)firstByte, tail);
    }

    public final long save(@NotNull PatriciaTreeMutable tree, @NotNull MutableNodeSaveContext context) {
        Object value;
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(context, "context");
        LightOutputStream nodeStream = context.newNodeStream();
        if (this.hasKey()) {
            CompressedUnsignedLongByteIterable.fillBytes(this.keySequence.getLength(), nodeStream);
            ByteIterableBase.fillBytes(this.keySequence, nodeStream);
        }
        ByteIterable byteIterable = this.value;
        if (byteIterable != null) {
            value = byteIterable;
            boolean bl = false;
            CompressedUnsignedLongByteIterable.fillBytes(value.getLength(), nodeStream);
            ByteIterableBase.fillBytes((ByteIterable)value, nodeStream);
        }
        int childrenCount = this.getChildrenCount();
        if (childrenCount > 0) {
            if (tree.getUseV1Format() || childrenCount < 2) {
                Intrinsics.checkNotNullExpressionValue(nodeStream, "nodeStream");
                this.saveChildrenV1(childrenCount, nodeStream);
            } else {
                Intrinsics.checkNotNullExpressionValue(nodeStream, "nodeStream");
                this.saveChildrenV2(childrenCount, nodeStream);
            }
        }
        value = tree.getLog();
        Intrinsics.checkNotNullExpressionValue(value, "tree.getLog()");
        Object log = value;
        byte type = this.getLoggableType();
        int structureId = tree.getStructureId();
        ArrayByteIterable arrayByteIterable = nodeStream.asArrayByteIterable();
        Intrinsics.checkNotNullExpressionValue(arrayByteIterable, "nodeStream.asArrayByteIterable()");
        ByteIterable mainIterable = arrayByteIterable;
        long startAddress = context.startAddress;
        long result = 0L;
        if (!this.isRoot()) {
            result = ((Log)log).write(type, structureId, mainIterable);
            if (startAddress == -1L) {
                context.startAddress = result;
            }
            return result;
        }
        ByteIterable[] iterables = new ByteIterable[3];
        iterables[0] = context.preliminaryRootData;
        if (startAddress == -1L) {
            iterables[1] = mainIterable;
            result = ((Log)log).write(type, structureId, new CompoundByteIterable(iterables, 2));
            return result;
        }
        boolean singleFile = ((Log)log).isLastWrittenFileAddress(startAddress);
        int pos = 0;
        if (!singleFile) {
            pos = 1;
            iterables[2] = mainIterable;
        } else {
            iterables[1] = mainIterable;
            result = ((Log)log).tryWrite(type, structureId, new CompoundByteIterable(iterables, 2));
            if (result >= 0L) {
                return result;
            }
            pos = 1;
            iterables[2] = mainIterable;
        }
        type = MutableNodeKt.access$plus(type, (byte)16);
        iterables[pos] = CompressedUnsignedLongByteIterable.getIterable(((Log)log).getWrittenHighAddress() - startAddress);
        ByteIterable data = new CompoundByteIterable(iterables, pos + 2);
        long l = result = singleFile ? ((Log)log).writeContinuously(type, structureId, data) : ((Log)log).tryWrite(type, structureId, data);
        if (result < 0L) {
            if (!singleFile) {
                iterables[pos] = CompressedUnsignedLongByteIterable.getIterable(((Log)log).getWrittenHighAddress() - startAddress);
                result = ((Log)log).writeContinuously(type, structureId, new CompoundByteIterable(iterables, pos + 2));
                if (result >= 0L) {
                    return result;
                }
            }
            throw new TooBigLoggableException();
        }
        return result;
    }

    protected boolean isRoot() {
        return false;
    }

    private final void copyChildrenFrom(NodeBase node) {
        int childrenCount = node.getChildrenCount();
        this.children.clear(childrenCount);
        if (childrenCount > 0) {
            Iterator iterator2 = node.getChildren().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                ChildReference child = (ChildReference)iterator2.next();
                this.children.setAt(i, KodusKt.getNotNull(child));
            }
        }
    }

    private final byte getLoggableType() {
        byte result = 12;
        if (this.hasKey()) {
            result = MutableNodeKt.access$plus(result, (byte)1);
        }
        if (this.hasValue()) {
            result = MutableNodeKt.access$plus(result, (byte)2);
        }
        if (this.hasChildren()) {
            result = MutableNodeKt.access$plus(result, (byte)4);
        }
        if (this.isRoot()) {
            result = MutableNodeKt.access$plus(result, (byte)8);
        }
        return result;
    }

    private final void saveChildrenV1(int childrenCount, LightOutputStream nodeStream) {
        Iterator iterator2 = ((Iterable)this.children).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        ChildReference r = (ChildReference)iterator2.next();
        boolean bl = false;
        int n = CompressedUnsignedLongArrayByteIterable.logarithm(r.suffixAddress);
        while (iterator2.hasNext()) {
            ChildReference r2 = (ChildReference)iterator2.next();
            $i$a$-maxOf-MutableNode$saveChildrenV1$bytesPerAddress$1 = false;
            int n2 = CompressedUnsignedLongArrayByteIterable.logarithm(r2.suffixAddress);
            if (n >= n2) continue;
            n = n2;
        }
        int bytesPerAddress = n;
        CompressedUnsignedLongByteIterable.fillBytes((childrenCount << 3) + bytesPerAddress - 1, nodeStream);
        for (ChildReference ref : this.children) {
            nodeStream.write(ref.firstByte);
            LongBinding.writeUnsignedLong(ref.suffixAddress, bytesPerAddress, nodeStream);
        }
    }

    private final void saveChildrenV2(int childrenCount, LightOutputStream nodeStream) {
        int n;
        ChildReferenceSet.ChildReferenceIterator childReferenceIterator = ((Iterable)this.children).iterator();
        if (!childReferenceIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        ChildReference r42422 = (ChildReference)childReferenceIterator.next();
        boolean bl = false;
        long r42422 = r42422.suffixAddress;
        while (childReferenceIterator.hasNext()) {
            ChildReference r332 = (ChildReference)childReferenceIterator.next();
            boolean bl2 = false;
            long r332 = r332.suffixAddress;
            if (r42422 <= r332) continue;
            r42422 = r332;
        }
        long baseAddress = r42422;
        Iterator r42422 = ((Iterable)this.children).iterator();
        if (!r42422.hasNext()) {
            throw new NoSuchElementException();
        }
        ChildReference r22322 = (ChildReference)r42422.next();
        boolean bl3 = false;
        int r22322 = CompressedUnsignedLongArrayByteIterable.logarithm(r22322.suffixAddress - baseAddress);
        while (r42422.hasNext()) {
            ChildReference childReference = (ChildReference)r42422.next();
            boolean bl4 = false;
            int n2 = CompressedUnsignedLongArrayByteIterable.logarithm(childReference.suffixAddress - baseAddress);
            if (r22322 >= n2) continue;
            r22322 = n2;
        }
        int bytesPerAddress = r22322;
        if (childrenCount <= 32) {
            int n3;
            Iterator r22322 = ((Iterable)this.children).iterator();
            if (!r22322.hasNext()) {
                throw new NoSuchElementException();
            }
            ChildReference childReference = (ChildReference)r22322.next();
            boolean bl32 = false;
            int n4 = CompressedUnsignedLongArrayByteIterable.logarithm(childReference.suffixAddress);
            while (r22322.hasNext()) {
                ChildReference r3 = (ChildReference)r22322.next();
                boolean bl5 = false;
                n = CompressedUnsignedLongArrayByteIterable.logarithm(r3.suffixAddress);
                if (n3 >= n) continue;
                n3 = n;
            }
            int bytesPerAddressV1 = n3;
            if (bytesPerAddress == bytesPerAddressV1 || (bytesPerAddressV1 - bytesPerAddress) * childrenCount <= CompressedUnsignedLongByteIterable.getCompressedSize(baseAddress) + 1) {
                this.saveChildrenV1(childrenCount, nodeStream);
                return;
            }
        }
        CompressedUnsignedLongByteIterable.fillBytes((childrenCount + 257 << 3) + bytesPerAddress - 1, nodeStream);
        CompressedUnsignedLongByteIterable.fillBytes(baseAddress, nodeStream);
        if (childrenCount < 256) {
            if (childrenCount <= 32) {
                for (Object ref : this.children) {
                    nodeStream.write(ref.firstByte);
                }
            } else {
                Object ref;
                ref = new long[]{0L, 0L, 0L, 0L};
                Object bitset = ref;
                ref = this.children.iterator();
                while (ref.hasNext()) {
                    ChildReference ref2 = ref.next();
                    int n5 = ImmutableNodeKt.getUnsigned(ref2.firstByte);
                    n = n5 / 64;
                    bitset[n] = bitset[n] + (1L << n5 % 64);
                }
                Object $this$forEach$iv = bitset;
                boolean $i$f$forEach = false;
                for (long element$iv : $this$forEach$iv) {
                    long l = element$iv;
                    boolean bl4 = false;
                    LongBinding.writeUnsignedLong(l, 8, nodeStream);
                }
            }
        }
        for (Object ref : this.children) {
            LongBinding.writeUnsignedLong(ref.suffixAddress - baseAddress, bytesPerAddress, nodeStream);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u001c\u001a\u00020\u000fH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0016J\t\u0010\u001e\u001a\u00020\u0015H\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ljetbrains/exodus/tree/patricia/MutableNode$MutableNodeChildrenIterator;", "Ljetbrains/exodus/tree/patricia/NodeChildrenIterator;", "node", "Ljetbrains/exodus/tree/patricia/MutableNode;", "refs", "Ljetbrains/exodus/tree/patricia/ChildReferenceSet;", "(Ljetbrains/exodus/tree/patricia/MutableNode;Ljetbrains/exodus/tree/patricia/ChildReferenceSet;)V", "Ljetbrains/exodus/tree/patricia/ChildReferenceSet$ChildReferenceIterator;", "(Ljetbrains/exodus/tree/patricia/MutableNode;Ljetbrains/exodus/tree/patricia/ChildReferenceSet$ChildReferenceIterator;)V", "_node", "index", "", "getIndex", "()I", "isMutable", "", "()Z", "key", "Ljetbrains/exodus/ByteIterable;", "getKey", "()Ljetbrains/exodus/ByteIterable;", "Ljetbrains/exodus/tree/patricia/ChildReference;", "getNode", "()Ljetbrains/exodus/tree/patricia/ChildReference;", "parentNode", "getParentNode", "()Ljetbrains/exodus/tree/patricia/MutableNode;", "ref", "hasNext", "hasPrev", "next", "nextInPlace", "", "prev", "prevInPlace", "remove", "", "xodus-environment"})
    private static final class MutableNodeChildrenIterator
    implements NodeChildrenIterator {
        @NotNull
        private final MutableNode _node;
        @NotNull
        private final ChildReferenceSet.ChildReferenceIterator refs;
        @NotNull
        private final ByteIterable key;
        @Nullable
        private ChildReference ref;
        private final boolean isMutable;

        @Override
        @NotNull
        public ByteIterable getKey() {
            return this.key;
        }

        public MutableNodeChildrenIterator(@NotNull MutableNode node, @NotNull ChildReferenceSet refs) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(refs, "refs");
            this.isMutable = true;
            this._node = node;
            Object object = refs.iterator();
            Intrinsics.checkNotNullExpressionValue(object, "refs.iterator()");
            this.refs = object;
            object = node.keySequence;
            Intrinsics.checkNotNullExpressionValue(object, "node.keySequence");
            this.key = object;
        }

        public MutableNodeChildrenIterator(@NotNull MutableNode node, @NotNull ChildReferenceSet.ChildReferenceIterator refs) {
            Intrinsics.checkNotNullParameter(node, "node");
            Intrinsics.checkNotNullParameter(refs, "refs");
            this.isMutable = true;
            this._node = node;
            this.refs = refs;
            this.ref = refs.currentRef();
            ByteIterable byteIterable = node.keySequence;
            Intrinsics.checkNotNullExpressionValue(byteIterable, "node.keySequence");
            this.key = byteIterable;
        }

        @Override
        public boolean hasNext() {
            return this.refs.hasNext();
        }

        @Override
        @NotNull
        public ChildReference next() {
            ChildReference childReference;
            ChildReference it = childReference = this.refs.next();
            boolean bl = false;
            this.ref = it;
            ChildReference childReference2 = childReference;
            Intrinsics.checkNotNullExpressionValue(childReference2, "refs.next().also { this.ref = it }");
            return childReference2;
        }

        @Override
        public boolean hasPrev() {
            return this.refs.getIndex() > 0;
        }

        @Override
        @NotNull
        public ChildReference prev() {
            ChildReference childReference;
            ChildReference it = childReference = this.refs.prev();
            boolean bl = false;
            this.ref = it;
            ChildReference childReference2 = childReference;
            Intrinsics.checkNotNullExpressionValue(childReference2, "refs.prev().also { this.ref = it }");
            return childReference2;
        }

        @Override
        public boolean isMutable() {
            return this.isMutable;
        }

        @NotNull
        public Void nextInPlace() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Void prevInPlace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            this._node.removeChild(KodusKt.getNotNull(this.ref).firstByte);
        }

        @Override
        @Nullable
        public ChildReference getNode() {
            return this.ref;
        }

        @Override
        @NotNull
        public MutableNode getParentNode() {
            return this._node;
        }

        @Override
        public int getIndex() {
            return this.refs.getIndex();
        }
    }
}

