/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Loggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePageMutable;
import org.jetbrains.annotations.NotNull;

class LeafNode
extends BaseLeafNode {
    @NotNull
    private final RandomAccessLoggable loggable;
    private final int keyLength;

    LeafNode(@NotNull RandomAccessLoggable loggable) {
        this.loggable = loggable;
        ByteIterableWithAddress data = loggable.getData();
        int keyLength = data.getCompressedUnsignedInt();
        int keyRecordSize = CompressedUnsignedLongByteIterable.getCompressedSize(keyLength);
        this.keyLength = (keyLength << 3) + keyRecordSize;
    }

    @Override
    public long getAddress() {
        return this.loggable.getAddress();
    }

    public int getType() {
        return this.loggable.getType();
    }

    @Override
    public int compareKeyTo(@NotNull ByteIterable iterable2) {
        return this.loggable.getData().compareTo(this.getKeyRecordSize(), this.getKeyLength(), iterable2);
    }

    @Override
    public int compareValueTo(@NotNull ByteIterable iterable2) {
        return this.loggable.getData().compareTo(this.getKeyRecordSize() + this.getKeyLength(), this.getValueLength(), iterable2);
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.loggable.getData().subIterable(this.getKeyRecordSize(), this.getKeyLength());
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        int valueLength = this.getValueLength();
        if (valueLength == 0) {
            return ArrayByteIterable.EMPTY;
        }
        return this.loggable.getData().subIterable(this.getKeyRecordSize() + this.getKeyLength(), valueLength);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    Loggable getLoggable() {
        return this.loggable;
    }

    @NotNull
    ByteIterableWithAddress getRawValue(int offset) {
        return this.loggable.getData().clone(this.getKeyRecordSize() + this.getKeyLength() + offset);
    }

    private int getKeyLength() {
        return this.keyLength >>> 3;
    }

    private int getKeyRecordSize() {
        return this.keyLength & 7;
    }

    private int getValueLength() {
        return this.loggable.getDataLength() - this.getKeyRecordSize() - this.getKeyLength();
    }

    protected void doReclaim(@NotNull BTreeReclaimTraverser context, int leafIndex) {
        long keyAddress = context.currentNode.getKeyAddress(leafIndex);
        if (keyAddress == this.loggable.getAddress()) {
            BTreeMutable tree = context.mainTree;
            tree.addExpiredLoggable(keyAddress);
            BasePageMutable node = context.currentNode.getMutableCopy(tree);
            node.set(leafIndex, tree.createMutableLeaf(this.getKey(), this.getValue()), null);
            context.wasReclaim = true;
            context.setPage(node);
        }
    }

    protected void reclaim(@NotNull BTreeReclaimTraverser context) {
        int index2;
        int leafIndex;
        ByteIterable keyIterable;
        block13: {
            keyIterable = this.getKey();
            if (!context.canMoveDown() && context.canMoveRight()) {
                int cmp = context.compareCurrent(keyIterable);
                if (cmp > 0) {
                    return;
                }
                if (cmp == 0) {
                    leafIndex = context.currentPos;
                } else {
                    context.moveRight();
                    leafIndex = context.getNextSibling(keyIterable, this.loggable.getAddress());
                }
                if (leafIndex >= 0) {
                    this.doReclaim(context, leafIndex);
                    context.moveTo(leafIndex + 1);
                    return;
                }
                if (context.canMoveTo(-leafIndex - 1)) {
                    return;
                }
            }
            if (context.canMoveUp()) {
                block12: {
                    do {
                        context.popAndMutate();
                        context.moveRight();
                        index2 = context.getNextSibling(keyIterable);
                        if (index2 >= 0) break block12;
                    } while (!context.canMoveTo(-index2 - 1) && context.canMoveUp());
                    context.moveTo(Math.max(-index2 - 2, 0));
                    break block13;
                }
                context.pushChild(index2);
            }
        }
        while (context.canMoveDown()) {
            index2 = context.getNextSibling(keyIterable);
            if (index2 < 0) {
                index2 = Math.max(-index2 - 2, 0);
            }
            context.pushChild(index2);
        }
        leafIndex = context.getNextSibling(keyIterable);
        if (leafIndex >= 0) {
            this.doReclaim(context, leafIndex);
            context.moveTo(leafIndex + 1);
        } else {
            context.moveTo(-leafIndex - 1);
        }
    }
}

