/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.btree.BTreeDupMutable;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import org.jetbrains.annotations.NotNull;

class DupLeafNodeMutable
extends BaseLeafNodeMutable {
    protected long address = -1L;
    protected final ByteIterable key;
    protected final BTreeDupMutable dupTree;

    DupLeafNodeMutable(@NotNull ByteIterable key, @NotNull BTreeDupMutable dupTree) {
        this.key = key;
        this.dupTree = dupTree;
    }

    @Override
    public boolean isDupLeaf() {
        return true;
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        return this.dupTree.key;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public long save(ITree mainTree) {
        if (this.address != -1L) {
            throw new IllegalStateException("Leaf already saved");
        }
        this.address = mainTree.getLog().write(((BTreeMutable)mainTree).getLeafType(), mainTree.getStructureId(), new CompoundByteIterable(new ByteIterable[]{CompressedUnsignedLongByteIterable.getIterable(this.key.getLength()), this.key}));
        return this.address;
    }

    @Override
    public boolean delete(ByteIterable value) {
        throw new UnsupportedOperationException("Supported by dup node only");
    }

    @Override
    public String toString() {
        return "DLN* {key:" + this.getKey().toString() + "} @ " + this.getAddress();
    }
}

