/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.management;

import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.management.StatisticsItem;
import org.jetbrains.annotations.NotNull;

public class Statistics<T extends Enum> {
    @NotNull
    private final Map<String, StatisticsItem> items = new HashMap<String, StatisticsItem>();
    @NotNull
    private final StatisticsItem[] builtInItems;
    @NotNull
    private final T[] keys;

    public Statistics(@NotNull T[] keys2) {
        this.builtInItems = new StatisticsItem[keys2.length];
        this.keys = keys2;
    }

    @NotNull
    public StatisticsItem getStatisticsItem(@NotNull T key) {
        return this.builtInItems[((Enum)key).ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StatisticsItem getStatisticsItem(@NotNull String statisticsName) {
        StatisticsItem result;
        Map<String, StatisticsItem> map = this.items;
        synchronized (map) {
            result = this.items.get(statisticsName);
        }
        if (result == null) {
            result = this.createNewItem(statisticsName);
            boolean wasPut = false;
            Map<String, StatisticsItem> map2 = this.items;
            synchronized (map2) {
                if (!this.items.containsKey(statisticsName)) {
                    this.items.put(statisticsName, result);
                    wasPut = true;
                }
            }
            if (wasPut) {
                SharedTimer.registerPeriodicTask(result);
            }
        }
        return result;
    }

    @NotNull
    protected StatisticsItem createNewBuiltInItem(@NotNull T key) {
        return new StatisticsItem(this);
    }

    protected void createAllStatisticsItems() {
        for (T key : this.keys) {
            this.builtInItems[((Enum)key).ordinal()] = this.createStatisticsItem(key);
        }
    }

    @NotNull
    protected StatisticsItem createNewItem(@NotNull String statisticsName) {
        return new StatisticsItem(this);
    }

    protected StatisticsItem createStatisticsItem(@NotNull T key) {
        StatisticsItem created = this.createNewBuiltInItem(key);
        SharedTimer.registerPeriodicTask(created);
        return created;
    }
}

