/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.DataIterator;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public final class CompressedUnsignedLongByteIterable
extends ByteIterableBase {
    private static final int ITERABLES_CACHE_SIZE = 65536;
    private static final ByteIterable[] ITERABLES_CACHE = new ByteIterable[65536];
    private final long l;

    private CompressedUnsignedLongByteIterable(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        this.l = l;
    }

    public static ByteIterable getIterable(long l) {
        if (l < 65536L) {
            return ITERABLES_CACHE[(int)l];
        }
        return new CompressedUnsignedLongByteIterable(l);
    }

    public static void fillBytes(long l, LightOutputStream output) {
        byte b2;
        if (l < 0L) {
            throw new IllegalArgumentException(String.valueOf(l));
        }
        while (true) {
            b2 = (byte)(l & 0x7FL);
            if ((l >>= 7) == 0L) break;
            output.write(b2);
        }
        output.write(b2 | 0x80);
    }

    public static long getLong(ByteIterable iterable2) {
        return CompressedUnsignedLongByteIterable.getLong(iterable2.iterator());
    }

    public static long getLong(ByteIterator iterator2) {
        long result = 0L;
        int shift = 0;
        do {
            byte b2 = iterator2.next();
            result += (long)(b2 & 0x7F) << shift;
            if ((b2 & 0x80) != 0) {
                return result;
            }
            shift += 7;
        } while (iterator2.hasNext());
        return CompressedUnsignedLongByteIterable.throwBadCompressedNumber();
    }

    public static int getInt(ByteIterable iterable2) {
        return CompressedUnsignedLongByteIterable.getInt(iterable2.iterator());
    }

    public static int getInt(ByteIterator iterator2) {
        int result = 0;
        int shift = 0;
        do {
            byte b2 = iterator2.next();
            result += (b2 & 0x7F) << shift;
            if ((b2 & 0x80) != 0) {
                return result;
            }
            shift += 7;
        } while (iterator2.hasNext());
        return CompressedUnsignedLongByteIterable.throwBadCompressedNumber();
    }

    public static int getInt(@NotNull DataIterator iterator2) {
        byte b2 = iterator2.next();
        if ((b2 & 0x80) != 0) {
            return b2 & 0x7F;
        }
        int result = b2 & 0x7F;
        int shift = 7;
        while (true) {
            b2 = iterator2.next();
            result += (b2 & 0x7F) << shift;
            if ((b2 & 0x80) != 0) {
                return result;
            }
            shift += 7;
        }
    }

    public static int getCompressedSize(long l) {
        if (l < 128L) {
            return 1;
        }
        if (l < 16384L) {
            return 2;
        }
        l >>= 21;
        int result = 3;
        while (l > 0L) {
            ++result;
            l >>= 7;
        }
        return result;
    }

    @Override
    protected ByteIterator getIterator() {
        return new ByteIterator(){
            private boolean goon = true;
            private long l = CompressedUnsignedLongByteIterable.access$000(CompressedUnsignedLongByteIterable.this);

            @Override
            public boolean hasNext() {
                return this.goon;
            }

            @Override
            public byte next() {
                byte b2 = (byte)(this.l & 0x7FL);
                this.l >>= 7;
                this.goon = this.l > 0L;
                if (!this.goon) {
                    b2 = (byte)(b2 | 0x80);
                }
                return b2;
            }

            @Override
            public long skip(long bytes) {
                for (long i = 0L; i < bytes; ++i) {
                    if (this.goon) {
                        this.l >>= 7;
                    } else {
                        return i;
                    }
                    this.goon = this.l > 0L;
                }
                return bytes;
            }
        };
    }

    private static int throwBadCompressedNumber() {
        throw new ExodusException("Bad compressed number");
    }

    static /* synthetic */ long access$000(CompressedUnsignedLongByteIterable x0) {
        return x0.l;
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            CompressedUnsignedLongByteIterable.ITERABLES_CACHE[i] = new ArrayByteIterable(new CompressedUnsignedLongByteIterable(i));
        }
    }
}

