/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashMap;
import jetbrains.exodus.io.SharedMappedByteBuffer;
import jetbrains.exodus.system.OperatingSystem;
import jetbrains.exodus.util.SharedRandomAccessFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedMappedFilesCache {
    private static final Object syncObject = new Object();
    @Nullable
    private static volatile SharedMappedFilesCache theCache = null;
    private final long freePhysicalMemoryThreshold;
    private final ConcurrentLinkedQueue<SharedMappedByteBuffer> obsoleteQueue;
    private final LinkedHashMap<File, SharedMappedByteBuffer> cache;

    private SharedMappedFilesCache(long freePhysicalMemoryThreshold) {
        this.freePhysicalMemoryThreshold = freePhysicalMemoryThreshold;
        this.obsoleteQueue = new ConcurrentLinkedQueue();
        this.cache = new LinkedHashMap<File, SharedMappedByteBuffer>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<File, SharedMappedByteBuffer> eldest) {
                return SharedMappedFilesCache.this.isOSOverloaded();
            }

            @Override
            public SharedMappedByteBuffer remove(Object key) {
                SharedMappedByteBuffer obsolete = (SharedMappedByteBuffer)super.remove(key);
                if (obsolete != null) {
                    SharedMappedFilesCache.this.obsoleteQueue.offer(obsolete);
                }
                return obsolete;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createInstance(long freePhysicalMemoryThreshold) {
        if (theCache == null) {
            Object object = syncObject;
            synchronized (object) {
                if (theCache == null) {
                    theCache = new SharedMappedFilesCache(freePhysicalMemoryThreshold);
                }
            }
        }
    }

    @NotNull
    static SharedMappedFilesCache getInstance() {
        SharedMappedFilesCache result = theCache;
        if (result == null) {
            throw new ExodusException("SharedMappedFilesCache instance should be created explicitly");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        SharedMappedFilesCache oldCache;
        Iterator iterator2 = syncObject;
        synchronized (iterator2) {
            oldCache = theCache;
            theCache = null;
        }
        if (oldCache != null) {
            for (SharedMappedByteBuffer buffer : oldCache.cache.values()) {
                buffer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    SharedMappedByteBuffer getFileBuffer(@NotNull SharedRandomAccessFile file) throws IOException {
        try {
            File key = file.getFile();
            LinkedHashMap<File, SharedMappedByteBuffer> linkedHashMap = this.cache;
            // MONITORENTER : linkedHashMap
            SharedMappedByteBuffer result = (SharedMappedByteBuffer)this.cache.get(key);
            if (result != null) {
                result.employ();
                SharedMappedByteBuffer sharedMappedByteBuffer = result;
                // MONITOREXIT : linkedHashMap
                return sharedMappedByteBuffer;
            }
            // MONITOREXIT : linkedHashMap
            result = new SharedMappedByteBuffer(file);
            result.employ();
            Object object = this.cache;
            // MONITORENTER : object
            SharedMappedByteBuffer obsolete = this.cache.put(key, result);
            // MONITOREXIT : object
            if (obsolete != null) {
                this.obsoleteQueue.offer(obsolete);
            }
            object = result;
            return object;
        }
        finally {
            this.freeObsoleteBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileBuffer(@NotNull File file) {
        try {
            SharedMappedByteBuffer obsolete;
            LinkedHashMap<File, SharedMappedByteBuffer> linkedHashMap = this.cache;
            synchronized (linkedHashMap) {
                obsolete = this.cache.remove(file);
            }
            if (obsolete != null) {
                this.obsoleteQueue.offer(obsolete);
            }
        }
        finally {
            this.freeObsoleteBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDirectory(@NotNull File dir) {
        try {
            ArrayList result = new ArrayList();
            ArrayList<File> obsoleteFiles = new ArrayList<File>();
            LinkedHashMap<File, SharedMappedByteBuffer> linkedHashMap = this.cache;
            synchronized (linkedHashMap) {
                for (File file : this.cache.keySet()) {
                    if (!file.getParentFile().equals(dir)) continue;
                    obsoleteFiles.add(file);
                    result.add(this.cache.get(file));
                }
                for (File file : obsoleteFiles) {
                    this.cache.remove(file);
                }
            }
            for (SharedMappedByteBuffer obsolete : result) {
                this.obsoleteQueue.offer(obsolete);
            }
        }
        finally {
            this.freeObsoleteBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeObsoleteBuffers() {
        while (true) {
            SharedMappedByteBuffer obsolete;
            if ((obsolete = this.obsoleteQueue.poll()) != null) {
                obsolete.close();
                continue;
            }
            if (!this.isOSOverloaded()) break;
            LinkedHashMap<File, SharedMappedByteBuffer> linkedHashMap = this.cache;
            synchronized (linkedHashMap) {
                if (this.cache.size() == 0) {
                    break;
                }
                this.cache.removeEldest();
            }
        }
    }

    private boolean isOSOverloaded() {
        return OperatingSystem.getFreePhysicalMemorySize() < this.freePhysicalMemoryThreshold;
    }
}

