/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataWriter;

public abstract class AbstractDataWriter
implements DataWriter {
    private boolean open = false;

    protected AbstractDataWriter() {
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final void sync() {
        if (this.open) {
            this.syncImpl();
        }
    }

    @Override
    public void syncDirectory() {
    }

    @Override
    public final void close() {
        if (this.open) {
            this.closeImpl();
            this.open = false;
        }
    }

    @Override
    public void clear() {
        this.close();
        this.clearImpl();
    }

    @Override
    public final Block openOrCreateBlock(long address, long length) {
        if (this.open) {
            throw new IllegalStateException("Can't create blocks with open data writer");
        }
        Block result = this.openOrCreateBlockImpl(address, length);
        this.open = true;
        return result;
    }

    protected abstract void syncImpl();

    protected abstract void closeImpl();

    protected abstract void clearImpl();

    protected abstract Block openOrCreateBlockImpl(long var1, long var3);
}

