/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.execution.locks.CriticalSection;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.TransactionAcquireTimeoutException;
import org.jetbrains.annotations.NotNull;

final class ReentrantTransactionDispatcher {
    private final int availablePermits;
    @NotNull
    private final Map<Thread, Integer> threadPermits;
    @NotNull
    private final NavigableMap<Long, Condition> regularQueue;
    @NotNull
    private final NavigableMap<Long, Condition> nestedQueue;
    @NotNull
    private final CriticalSection criticalSection;
    private long acquireOrder;
    private int acquiredPermits;

    ReentrantTransactionDispatcher(int maxSimultaneousTransactions) {
        if (maxSimultaneousTransactions < 1) {
            throw new IllegalArgumentException("maxSimultaneousTransactions < 1");
        }
        this.availablePermits = maxSimultaneousTransactions;
        this.threadPermits = new HashMap<Thread, Integer>();
        this.regularQueue = new TreeMap<Long, Condition>();
        this.nestedQueue = new TreeMap<Long, Condition>();
        this.criticalSection = new CriticalSection(false);
        this.acquireOrder = 0L;
        this.acquiredPermits = 0;
    }

    int getAvailablePermits() {
        try (CriticalSection ignored = this.criticalSection.enter();){
            int n = this.availablePermits - this.acquiredPermits;
            return n;
        }
    }

    int acquireTransaction(@NotNull Thread thread2) {
        try (CriticalSection ignored = this.criticalSection.enter();){
            int currentThreadPermits = this.getThreadPermitsToAcquire(thread2);
            this.waitForPermits(thread2, currentThreadPermits > 0 ? this.nestedQueue : this.regularQueue, 1, currentThreadPermits);
        }
        return 1;
    }

    int acquireExclusiveTransaction(@NotNull Thread thread2) {
        try (CriticalSection ignored = this.criticalSection.enter();){
            int currentThreadPermits = this.getThreadPermitsToAcquire(thread2);
            if (currentThreadPermits == 0) {
                this.waitForPermits(thread2, this.regularQueue, this.availablePermits, 0);
                int n = this.availablePermits;
                return n;
            }
            this.waitForPermits(thread2, this.nestedQueue, 1, currentThreadPermits);
        }
        return 1;
    }

    void acquireTransaction(@NotNull ReadWriteTransaction txn, @NotNull Environment env) {
        int acquiredPermits;
        Thread creatingThread = txn.getCreatingThread();
        if (txn.isExclusive()) {
            if (txn.isGCTransaction()) {
                int gcTransactionAcquireTimeout = env.getEnvironmentConfig().getGcTransactionAcquireTimeout();
                acquiredPermits = this.tryAcquireExclusiveTransaction(creatingThread, gcTransactionAcquireTimeout);
                if (acquiredPermits == 0) {
                    throw new TransactionAcquireTimeoutException(gcTransactionAcquireTimeout);
                }
            } else {
                acquiredPermits = this.acquireExclusiveTransaction(creatingThread);
            }
            if (acquiredPermits == 1) {
                txn.setExclusive(false);
            }
        } else {
            acquiredPermits = this.acquireTransaction(creatingThread);
        }
        txn.setAcquiredPermits(acquiredPermits);
    }

    void releaseTransaction(@NotNull Thread thread2, int permits) {
        try (CriticalSection ignored = this.criticalSection.enter();){
            int currentThreadPermits = this.getThreadPermits(thread2);
            if (permits > currentThreadPermits) {
                throw new ExodusException("Can't release more permits than it was acquired");
            }
            this.acquiredPermits -= permits;
            if ((currentThreadPermits -= permits) == 0) {
                this.threadPermits.remove(thread2);
            } else {
                this.threadPermits.put(thread2, currentThreadPermits);
            }
            this.notifyNextWaiters();
        }
    }

    void releaseTransaction(@NotNull ReadWriteTransaction txn) {
        this.releaseTransaction(txn.getCreatingThread(), txn.getAcquiredPermits());
    }

    void downgradeTransaction(@NotNull Thread thread2, int permits) {
        if (permits > 1) {
            try (CriticalSection ignored = this.criticalSection.enter();){
                int currentThreadPermits = this.getThreadPermits(thread2);
                if (permits > currentThreadPermits) {
                    throw new ExodusException("Can't release more permits than it was acquired");
                }
                this.acquiredPermits -= permits - 1;
                this.threadPermits.put(thread2, currentThreadPermits -= permits - 1);
                this.notifyNextWaiters();
            }
        }
    }

    void downgradeTransaction(@NotNull ReadWriteTransaction txn) {
        this.downgradeTransaction(txn.getCreatingThread(), txn.getAcquiredPermits());
        txn.setAcquiredPermits(1);
    }

    int getThreadPermits(@NotNull Thread thread2) {
        Integer result = this.threadPermits.get(thread2);
        return result == null ? 0 : result;
    }

    private void waitForPermits(@NotNull Thread thread2, @NotNull NavigableMap<Long, Condition> queue, int permits, int currentThreadPermits) {
        Condition condition = this.criticalSection.newCondition();
        long currentOrder = this.acquireOrder++;
        queue.put(currentOrder, condition);
        while (this.acquiredPermits > this.availablePermits - permits || (Long)queue.firstKey() != currentOrder) {
            condition.awaitUninterruptibly();
        }
        queue.pollFirstEntry();
        this.acquiredPermits += permits;
        this.threadPermits.put(thread2, currentThreadPermits + permits);
        if (this.acquiredPermits < this.availablePermits) {
            this.notifyNextWaiters();
        }
    }

    private int tryAcquireExclusiveTransaction(@NotNull Thread thread2, int timeout) {
        long nanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        try (CriticalSection ignored = this.criticalSection.enter();){
            if (this.getThreadPermits(thread2) > 0) {
                throw new ExodusException("Exclusive transaction can't be nested");
            }
            Condition condition = this.criticalSection.newCondition();
            long currentOrder = this.acquireOrder++;
            this.regularQueue.put(currentOrder, condition);
            while (this.acquiredPermits > 0 || (Long)this.regularQueue.firstKey() != currentOrder) {
                try {
                    if ((nanos = condition.awaitNanos(nanos)) >= 0L) continue;
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (this.acquiredPermits == 0 && (Long)this.regularQueue.firstKey() == currentOrder) {
                this.regularQueue.pollFirstEntry();
                this.acquiredPermits = this.availablePermits;
                this.threadPermits.put(thread2, this.availablePermits);
                int n = this.availablePermits;
                return n;
            }
            this.regularQueue.remove(currentOrder);
            this.notifyNextWaiters();
        }
        return 0;
    }

    private void notifyNextWaiters() {
        if (!ReentrantTransactionDispatcher.notifyNextWaiter(this.nestedQueue)) {
            ReentrantTransactionDispatcher.notifyNextWaiter(this.regularQueue);
        }
    }

    private int getThreadPermitsToAcquire(@NotNull Thread thread2) {
        int currentThreadPermits = this.getThreadPermits(thread2);
        if (currentThreadPermits == this.availablePermits) {
            throw new ExodusException("No more permits are available to acquire a transaction");
        }
        return currentThreadPermits;
    }

    private static boolean notifyNextWaiter(@NotNull NavigableMap<Long, Condition> queue) {
        if (!queue.isEmpty()) {
            queue.firstEntry().getValue().signal();
            return true;
        }
        return false;
    }
}

