/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.MetaTreeImpl;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.TransactionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadonlyTransaction
extends TransactionBase {
    @Nullable
    private final Runnable beginHook;

    public ReadonlyTransaction(@NotNull EnvironmentImpl env, boolean exclusive, @Nullable Runnable beginHook) {
        super(env, exclusive);
        this.beginHook = this.getWrappedBeginHook(beginHook);
        env.holdNewestSnapshotBy(this, false);
    }

    ReadonlyTransaction(@NotNull TransactionBase origin) {
        super(origin.getEnvironment(), false);
        this.beginHook = null;
        this.setMetaTree(origin.getMetaTree());
        EnvironmentImpl env = this.getEnvironment();
        env.registerTransaction(this);
    }

    ReadonlyTransaction(@NotNull EnvironmentImpl env, long highAddress) {
        super(env, false);
        this.beginHook = () -> {
            this.setMetaTree(MetaTreeImpl.create(env, highAddress));
            env.registerTransaction(this);
        };
        env.holdNewestSnapshotBy(this, false);
    }

    @Override
    public void setCommitHook(@Nullable Runnable hook) {
        throw new ReadonlyTransactionException();
    }

    @Override
    void storeRemoved(@NotNull StoreImpl store) {
        throw new ReadonlyTransactionException();
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }

    @Override
    public void abort() {
        this.checkIsFinished();
        this.getEnvironment().finishTransaction(this);
    }

    @Override
    public boolean commit() {
        if (!this.isExclusive()) {
            throw new ReadonlyTransactionException();
        }
        return true;
    }

    @Override
    public boolean flush() {
        throw new ReadonlyTransactionException();
    }

    @Override
    public void revert() {
        throw new ReadonlyTransactionException();
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    @Override
    @Nullable
    Runnable getBeginHook() {
        return this.beginHook;
    }
}

