/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.File;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.crypto.KryptKt;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.entitystore.MetaServer;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.ContextualEnvironmentImpl;
import jetbrains.exodus.env.CopyEnvironmentKt;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.io.FileDataWriter;
import jetbrains.exodus.io.SharedOpenFilesCache;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogConfig;
import jetbrains.exodus.log.LogUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J%\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\r\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\r\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\r\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\r\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\r\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J\u0018\u0010\r\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\r\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J%\u0010\u0017\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0018"}, d2={"Ljetbrains/exodus/env/Environments;", "", "()V", "newContextualInstance", "Ljetbrains/exodus/env/ContextualEnvironment;", "dir", "Ljava/io/File;", "ec", "Ljetbrains/exodus/env/EnvironmentConfig;", "config", "Ljetbrains/exodus/log/LogConfig;", "", "subDir", "newInstance", "T", "Ljetbrains/exodus/env/EnvironmentImpl;", "envCreator", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljetbrains/exodus/env/EnvironmentImpl;", "Ljetbrains/exodus/env/Environment;", "log", "Ljetbrains/exodus/log/Log;", "newLogInstance", "prepare", "xodus-environment"})
public final class Environments {
    @NotNull
    public static final Environments INSTANCE = new Environments();

    private Environments() {
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull String dir, @NotNull String subDir, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(subDir, "subDir");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (Environment)INSTANCE.prepare((Function0)new Function0<EnvironmentImpl>(dir, subDir, ec){
            final /* synthetic */ String $dir;
            final /* synthetic */ String $subDir;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$dir = $dir;
                this.$subDir = $subDir;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final EnvironmentImpl invoke() {
                return new EnvironmentImpl(Environments.newLogInstance(new File(this.$dir, this.$subDir), this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull String dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        return Environments.newInstance(dir, new EnvironmentConfig());
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull Log log, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(log, "log");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (Environment)INSTANCE.prepare((Function0)new Function0<EnvironmentImpl>(log, ec){
            final /* synthetic */ Log $log;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$log = $log;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final EnvironmentImpl invoke() {
                return new EnvironmentImpl(this.$log, this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull String dir, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (Environment)INSTANCE.prepare((Function0)new Function0<EnvironmentImpl>(dir, ec){
            final /* synthetic */ String $dir;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$dir = $dir;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final EnvironmentImpl invoke() {
                return new EnvironmentImpl(Environments.newLogInstance(new File(this.$dir), this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull File dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        return Environments.newInstance(dir, new EnvironmentConfig());
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull File dir, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (Environment)INSTANCE.prepare((Function0)new Function0<EnvironmentImpl>(dir, ec){
            final /* synthetic */ File $dir;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$dir = $dir;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final EnvironmentImpl invoke() {
                return new EnvironmentImpl(Environments.newLogInstance(this.$dir, this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull LogConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        return Environments.newInstance(config, new EnvironmentConfig());
    }

    @JvmStatic
    @NotNull
    public static final Environment newInstance(@NotNull LogConfig config, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (Environment)INSTANCE.prepare((Function0)new Function0<EnvironmentImpl>(config, ec){
            final /* synthetic */ LogConfig $config;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$config = $config;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final EnvironmentImpl invoke() {
                return new EnvironmentImpl(Environments.newLogInstance(this.$config, this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final <T extends EnvironmentImpl> T newInstance(@NotNull Function0<? extends T> envCreator) {
        Intrinsics.checkNotNullParameter(envCreator, "envCreator");
        return INSTANCE.prepare(envCreator);
    }

    @JvmStatic
    @NotNull
    public static final ContextualEnvironment newContextualInstance(@NotNull String dir, @NotNull String subDir, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(subDir, "subDir");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (ContextualEnvironment)INSTANCE.prepare((Function0)new Function0<ContextualEnvironmentImpl>(dir, subDir, ec){
            final /* synthetic */ String $dir;
            final /* synthetic */ String $subDir;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$dir = $dir;
                this.$subDir = $subDir;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final ContextualEnvironmentImpl invoke() {
                return new ContextualEnvironmentImpl(Environments.newLogInstance(new File(this.$dir, this.$subDir), this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final ContextualEnvironment newContextualInstance(@NotNull String dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        return Environments.newContextualInstance(dir, new EnvironmentConfig());
    }

    @JvmStatic
    @NotNull
    public static final ContextualEnvironment newContextualInstance(@NotNull String dir, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (ContextualEnvironment)INSTANCE.prepare((Function0)new Function0<ContextualEnvironmentImpl>(dir, ec){
            final /* synthetic */ String $dir;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$dir = $dir;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final ContextualEnvironmentImpl invoke() {
                return new ContextualEnvironmentImpl(Environments.newLogInstance(new File(this.$dir), this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final ContextualEnvironment newContextualInstance(@NotNull File dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        return Environments.newContextualInstance(dir, new EnvironmentConfig());
    }

    @JvmStatic
    @NotNull
    public static final ContextualEnvironment newContextualInstance(@NotNull File dir, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (ContextualEnvironment)INSTANCE.prepare((Function0)new Function0<ContextualEnvironmentImpl>(dir, ec){
            final /* synthetic */ File $dir;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$dir = $dir;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final ContextualEnvironmentImpl invoke() {
                return new ContextualEnvironmentImpl(Environments.newLogInstance(this.$dir, this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final ContextualEnvironment newContextualInstance(@NotNull LogConfig config, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(ec, "ec");
        return (ContextualEnvironment)INSTANCE.prepare((Function0)new Function0<ContextualEnvironmentImpl>(config, ec){
            final /* synthetic */ LogConfig $config;
            final /* synthetic */ EnvironmentConfig $ec;
            {
                this.$config = $config;
                this.$ec = $ec;
                super(0);
            }

            @NotNull
            public final ContextualEnvironmentImpl invoke() {
                return new ContextualEnvironmentImpl(Environments.newLogInstance(this.$config, this.$ec), this.$ec);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final Log newLogInstance(@NotNull File dir, @NotNull EnvironmentConfig ec) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(ec, "ec");
        LogConfig logConfig = new LogConfig().setLocation(dir.getPath());
        Intrinsics.checkNotNullExpressionValue(logConfig, "LogConfig().setLocation(dir.path)");
        return Environments.newLogInstance(logConfig, ec);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Log newLogInstance(@NotNull LogConfig config, @NotNull EnvironmentConfig ec) {
        StreamCipherProvider streamCipherProvider;
        LogConfig logConfig;
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(ec, "ec");
        LogConfig $this$newLogInstance_u24lambda_u2d1 = logConfig = config;
        boolean bl = false;
        Long maxMemory = ec.getMemoryUsage();
        if (maxMemory != null) {
            $this$newLogInstance_u24lambda_u2d1.setMemoryUsage(maxMemory);
        } else {
            $this$newLogInstance_u24lambda_u2d1.setMemoryUsagePercentage(ec.getMemoryUsagePercentage());
        }
        $this$newLogInstance_u24lambda_u2d1.setReaderWriterProvider(ec.getLogDataReaderWriterProvider());
        if ($this$newLogInstance_u24lambda_u2d1.isReadonlyReaderWriterProvider()) {
            ec.setEnvIsReadonly(true);
            ec.setEnvFailFastInReadonly(true);
            ec.setGcEnabled(false);
            $this$newLogInstance_u24lambda_u2d1.setLockIgnored(true);
        }
        $this$newLogInstance_u24lambda_u2d1.setFileSize(ec.getLogFileSize());
        $this$newLogInstance_u24lambda_u2d1.setLockTimeout(ec.getLogLockTimeout());
        $this$newLogInstance_u24lambda_u2d1.setCachePageSize(ec.getLogCachePageSize());
        $this$newLogInstance_u24lambda_u2d1.setCacheOpenFilesCount(ec.getLogCacheOpenFilesCount());
        $this$newLogInstance_u24lambda_u2d1.setDurableWrite(ec.getLogDurableWrite());
        $this$newLogInstance_u24lambda_u2d1.setSharedCache(ec.isLogCacheShared());
        $this$newLogInstance_u24lambda_u2d1.setNonBlockingCache(ec.isLogCacheNonBlocking());
        $this$newLogInstance_u24lambda_u2d1.setCacheUseSoftReferences(ec.getLogCacheUseSoftReferences());
        $this$newLogInstance_u24lambda_u2d1.setCacheGenerationCount(ec.getLogCacheGenerationCount());
        $this$newLogInstance_u24lambda_u2d1.setCleanDirectoryExpected(ec.isLogCleanDirectoryExpected());
        $this$newLogInstance_u24lambda_u2d1.setClearInvalidLog(ec.isLogClearInvalid());
        $this$newLogInstance_u24lambda_u2d1.setWarmup(ec.getLogCacheWarmup());
        $this$newLogInstance_u24lambda_u2d1.setSyncPeriod(ec.getLogSyncPeriod());
        $this$newLogInstance_u24lambda_u2d1.setFullFileReadonly(ec.isLogFullFileReadonly());
        LogConfig logConfig2 = $this$newLogInstance_u24lambda_u2d1;
        String string = ec.getCipherId();
        if (string == null) {
            streamCipherProvider = null;
        } else {
            void cipherId;
            String string2 = string;
            LogConfig logConfig3 = logConfig2;
            boolean bl2 = false;
            streamCipherProvider = KryptKt.newCipherProvider((String)cipherId);
            logConfig2 = logConfig3;
        }
        logConfig2.setCipherProvider(streamCipherProvider);
        $this$newLogInstance_u24lambda_u2d1.setCipherKey(ec.getCipherKey());
        $this$newLogInstance_u24lambda_u2d1.setCipherBasicIV(ec.getCipherBasicIV());
        $this$newLogInstance_u24lambda_u2d1.setUseV1Format(ec.getUseVersion1Format());
        return Environments.newLogInstance(logConfig);
    }

    @JvmStatic
    @NotNull
    public static final Log newLogInstance(@NotNull LogConfig config) {
        LogConfig logConfig;
        Intrinsics.checkNotNullParameter(config, "config");
        LogConfig it = logConfig = config;
        boolean bl = false;
        SharedOpenFilesCache.setSize(config.getCacheOpenFilesCount());
        LogConfig logConfig2 = logConfig;
        return new Log(logConfig2);
    }

    private final <T extends EnvironmentImpl> T prepare(Function0<? extends T> envCreator) {
        MetaServer metaServer;
        EnvironmentConfig ec;
        Object env;
        block8: {
            env = null;
            env = envCreator.invoke();
            EnvironmentConfig environmentConfig = ((EnvironmentImpl)env).getEnvironmentConfig();
            Intrinsics.checkNotNullExpressionValue(environmentConfig, "env.environmentConfig");
            ec = environmentConfig;
            if (Intrinsics.areEqual(ec.getLogDataReaderWriterProvider(), "jetbrains.exodus.io.FileDataReaderWriterProvider") && ec.getEnvCompactOnOpen() && ((EnvironmentImpl)env).getLog().getNumberOfFiles() > 1L) {
                String string = ((EnvironmentImpl)env).getLocation();
                Intrinsics.checkNotNullExpressionValue(string, "env.location");
                String location = string;
                File tempDir = new File(location, Intrinsics.stringPlus("compactTemp", System.currentTimeMillis()));
                boolean bl = false;
                if (!tempDir.mkdir()) {
                    EnvironmentImpl.loggerError(Intrinsics.stringPlus("Failed to create temporary directory: ", tempDir));
                } else if (tempDir.getFreeSpace() < ((EnvironmentImpl)env).getDiskUsage()) {
                    EnvironmentImpl.loggerError(Intrinsics.stringPlus("Not enough free disk space to compact the database: ", location));
                    tempDir.delete();
                } else {
                    CopyEnvironmentKt.copyTo(env, tempDir, false, null, prepare.1.1.INSTANCE);
                    long[] files = ((EnvironmentImpl)env).getLog().getAllFileAddresses();
                    ((EnvironmentImpl)env).close();
                    Object[] $this$forEach$iv = files;
                    boolean $i$f$forEach = false;
                    for (long element$iv : $this$forEach$iv) {
                        long fileAddress = element$iv;
                        boolean bl2 = false;
                        File file = new File(location, LogUtil.getLogFilename(fileAddress));
                        if (FileDataWriter.Companion.renameFile(file)) continue;
                        EnvironmentImpl.loggerError(Intrinsics.stringPlus("Failed to rename file: ", file));
                        break block8;
                    }
                    $this$forEach$iv = LogUtil.listFiles(tempDir);
                    Intrinsics.checkNotNullExpressionValue($this$forEach$iv, "listFiles(tempDir)");
                    $this$forEach$iv = $this$forEach$iv;
                    $i$f$forEach = false;
                    for (long element$iv : $this$forEach$iv) {
                        File file = (File)element$iv;
                        boolean bl3 = false;
                        if (file.renameTo(new File(location, file.getName()))) continue;
                        throw new ExodusException(Intrinsics.stringPlus("Failed to rename file: ", file));
                    }
                    env = envCreator.invoke();
                }
            }
        }
        ((EnvironmentImpl)env).getGC().getUtilizationProfile().load();
        MetaServer metaServer2 = metaServer = ec.getMetaServer();
        if (metaServer2 != null) {
            metaServer2.start(env);
        }
        return (T)((EnvironmentImpl)env);
    }
}

