/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.ConcurrentModificationException;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.ReadWriteTransaction;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.tree.ITreeCursor;
import org.jetbrains.annotations.NotNull;

final class CursorImpl
implements Cursor {
    private static final String CANT_DELETE_MODIFIED_MSG = "Can't delete (pair not found in mutable tree)";
    @NotNull
    private final StoreImpl store;
    @NotNull
    private final TransactionBase txn;
    private final long txnHighAddress;
    private ITreeCursor treeCursor;
    private boolean isClosed;

    CursorImpl(@NotNull StoreImpl store, @NotNull TransactionBase txn) {
        this.store = store;
        this.txn = txn;
        this.txnHighAddress = txn.getHighAddress();
        this.treeCursor = null;
        this.isClosed = false;
    }

    @Override
    public boolean getNext() {
        this.checkTreeCursor();
        return this.treeCursor.getNext();
    }

    @Override
    public boolean getNextDup() {
        this.checkTreeCursor();
        return this.treeCursor.getNextDup();
    }

    @Override
    public boolean getNextNoDup() {
        this.checkTreeCursor();
        return this.treeCursor.getNextNoDup();
    }

    @Override
    public boolean getPrev() {
        this.checkTreeCursor();
        return this.treeCursor.getPrev();
    }

    @Override
    public boolean getPrevDup() {
        this.checkTreeCursor();
        return this.treeCursor.getPrevDup();
    }

    @Override
    public boolean getPrevNoDup() {
        this.checkTreeCursor();
        return this.treeCursor.getPrevNoDup();
    }

    @Override
    public boolean getLast() {
        this.checkTreeCursor();
        return this.treeCursor.getLast();
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        this.checkTreeCursor();
        return this.treeCursor.getKey();
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        this.checkTreeCursor();
        return this.treeCursor.getValue();
    }

    @Override
    public ByteIterable getSearchKey(@NotNull ByteIterable key) {
        this.checkTreeCursor();
        return this.treeCursor.getSearchKey(key);
    }

    @Override
    public ByteIterable getSearchKeyRange(@NotNull ByteIterable key) {
        this.checkTreeCursor();
        return this.treeCursor.getSearchKeyRange(key);
    }

    @Override
    public boolean getSearchBoth(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        this.checkTreeCursor();
        return this.treeCursor.getSearchBoth(key, value);
    }

    @Override
    public ByteIterable getSearchBothRange(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        this.checkTreeCursor();
        return this.treeCursor.getSearchBothRange(key, value);
    }

    @Override
    public int count() {
        this.checkTreeCursor();
        return this.treeCursor.count();
    }

    @Override
    public boolean isMutable() {
        this.checkTreeCursor();
        return this.treeCursor.isMutable();
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.treeCursor != null) {
                this.treeCursor.close();
            }
        }
    }

    @Override
    public boolean deleteCurrent() {
        ReadWriteTransaction txn = EnvironmentImpl.throwIfReadonly(this.txn, "Can't delete a key/value pair of cursor in read-only transaction");
        if (this.treeCursor == null) {
            this.treeCursor = txn.getMutableTree(this.store).openCursor();
        } else if (!this.treeCursor.isMutable()) {
            ByteIterable key = this.treeCursor.getKey();
            ByteIterable value = this.treeCursor.getValue();
            ITreeCursor newCursor = txn.getMutableTree(this.store).openCursor();
            if (newCursor.getSearchBoth(key, value)) {
                this.treeCursor = newCursor;
            } else {
                throw new ConcurrentModificationException(CANT_DELETE_MODIFIED_MSG);
            }
        }
        return this.treeCursor.deleteCurrent();
    }

    private void checkTreeCursor() {
        if (this.treeCursor == null) {
            this.treeCursor = this.txn.getTree(this.store).openCursor();
        }
        if (this.txnHighAddress != this.txn.getHighAddress()) {
            throw new ExodusException("Cursor holds an obsolete database snapshot. Check if txn.flush() or txn.commit() is called.");
        }
    }
}

