/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.Closeable;
import java.util.NoSuchElementException;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.env.BitmapImpl;
import jetbrains.exodus.env.BitmapImplKt;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\fH\u0002J\t\u0010\"\u001a\u00020\u001eH\u0096\u0002J\u000e\u0010\u0013\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\fH\u0016J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020\u001cH\u0002J\b\u0010'\u001a\u00020\u001cH\u0002R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ljetbrains/exodus/env/BitmapIterator;", "Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "Ljava/io/Closeable;", "txn", "Ljetbrains/exodus/env/Transaction;", "store", "Ljetbrains/exodus/env/StoreImpl;", "direction", "", "(Ljetbrains/exodus/env/Transaction;Ljetbrains/exodus/env/StoreImpl;I)V", "bitIndex", "current", "", "Ljava/lang/Long;", "cursor", "Ljetbrains/exodus/env/Cursor;", "getCursor", "()Ljetbrains/exodus/env/Cursor;", "key", "next", "getStore", "()Ljetbrains/exodus/env/StoreImpl;", "setStore", "(Ljetbrains/exodus/env/StoreImpl;)V", "getTxn", "()Ljetbrains/exodus/env/Transaction;", "value", "close", "", "getSearchBit", "", "bit", "getSearchKey", "searchKey", "hasNext", "()Ljava/lang/Long;", "nextLong", "remove", "setNext", "setNextBitIndex", "xodus-environment"})
public final class BitmapIterator
implements LongIterator,
Closeable {
    @NotNull
    private final Transaction txn;
    @NotNull
    private StoreImpl store;
    private final int direction;
    @NotNull
    private final Cursor cursor;
    @Nullable
    private Long current;
    @Nullable
    private Long next;
    private long key;
    private long value;
    private int bitIndex;

    public BitmapIterator(@NotNull Transaction txn, @NotNull StoreImpl store, int direction) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        Intrinsics.checkNotNullParameter(store, "store");
        this.txn = txn;
        this.store = store;
        this.direction = direction;
        Cursor cursor = this.store.openCursor(this.txn);
        Intrinsics.checkNotNullExpressionValue(cursor, "store.openCursor(txn)");
        this.cursor = cursor;
        this.bitIndex = 1;
        if (this.direction != 1 && this.direction != -1) {
            throw new IllegalArgumentException("direction can only be 1 or -1");
        }
    }

    public /* synthetic */ BitmapIterator(Transaction transaction, StoreImpl storeImpl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(transaction, storeImpl, n);
    }

    @NotNull
    public final Transaction getTxn() {
        return this.txn;
    }

    @NotNull
    public final StoreImpl getStore() {
        return this.store;
    }

    public final void setStore(@NotNull StoreImpl storeImpl) {
        Intrinsics.checkNotNullParameter(storeImpl, "<set-?>");
        this.store = storeImpl;
    }

    @NotNull
    public final Cursor getCursor() {
        return this.cursor;
    }

    @Override
    public void remove() {
        Long l = this.current;
        if (l != null) {
            long l2;
            long current = ((Number)l).longValue();
            boolean bl = false;
            ArrayByteIterable keyEntry = LongBinding.longToCompressedEntry(BitmapImplKt.getKey(current));
            ByteIterable byteIterable = this.getStore().get(this.getTxn(), keyEntry);
            long bitmap = byteIterable == null ? 0L : (l2 = BitmapImpl.Companion.getAsLong$xodus_environment(byteIterable));
            long it = bitmap ^ 1L << BitmapImplKt.getIndex(current);
            boolean bl2 = false;
            boolean bl3 = it == 0L ? this.getStore().delete(this.getTxn(), keyEntry) : this.getStore().put(this.getTxn(), keyEntry, BitmapImpl.Companion.getAsEntry$xodus_environment(it));
            this.current = null;
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.setNext();
        }
        return this.next != null;
    }

    @Override
    @NotNull
    public Long next() {
        return this.nextLong();
    }

    @Override
    public long nextLong() {
        if (this.hasNext()) {
            this.current = this.next;
            Long l = this.next;
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                this.setNext();
                return it;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    private final void setNext() {
        while (this.value == 0L && (this.direction == 1 ? this.cursor.getNext() : this.cursor.getPrev())) {
            this.key = LongBinding.compressedEntryToLong(this.cursor.getKey());
            ByteIterable byteIterable = this.cursor.getValue();
            Intrinsics.checkNotNullExpressionValue(byteIterable, "cursor.value");
            this.value = BitmapImpl.Companion.getAsLong$xodus_environment(byteIterable);
            this.bitIndex = this.direction == 1 ? 0 : 63;
        }
        if (this.value != 0L) {
            this.setNextBitIndex();
            this.next = (this.key << 6) + (long)this.bitIndex;
            this.value -= 1L << this.bitIndex;
        } else {
            this.next = null;
            this.cursor.close();
        }
    }

    private final void setNextBitIndex() {
        while ((this.value & 1L << this.bitIndex) == 0L) {
            this.bitIndex += this.direction;
        }
    }

    public final boolean getSearchBit(long bit) {
        long searchKey = BitmapImplKt.getKey(bit);
        int searchIndex = BitmapImplKt.getIndex(bit);
        if (this.getSearchKey(searchKey)) {
            int n;
            long navigatedKey;
            this.key = navigatedKey = LongBinding.compressedEntryToLong(this.cursor.getKey());
            ByteIterable byteIterable = this.cursor.getValue();
            Intrinsics.checkNotNullExpressionValue(byteIterable, "cursor.value");
            this.value = BitmapImpl.Companion.getAsLong$xodus_environment(byteIterable);
            if (navigatedKey != searchKey) {
                n = this.direction > 0 ? 0 : 63;
            } else {
                if (this.direction > 0) {
                    this.value = this.value >> searchIndex << searchIndex;
                } else {
                    int shiftBits = 64 - searchIndex - 1;
                    this.value = this.value << shiftBits >>> shiftBits;
                }
                n = searchIndex;
            }
            this.bitIndex = n;
            this.setNext();
            return true;
        }
        return false;
    }

    private final boolean getSearchKey(long searchKey) {
        boolean navigated;
        boolean bl = navigated = this.cursor.getSearchKeyRange(LongBinding.longToCompressedEntry(searchKey)) != null;
        if (this.direction < 0 && LongBinding.compressedEntryToLong(this.cursor.getKey()) != searchKey) {
            navigated = this.cursor.getPrev();
        }
        return navigated;
    }
}

