/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.util.SpinAllocator;

public class LongArrayListSpinAllocator {
    private static final int INITIAL_CAPACITY = 1024;
    private static final int MAXIMUM_KEEPING_CAPACITY = 8192;
    private static final SpinAllocator<LongArrayList> allocator = new SpinAllocator<LongArrayList>(new Creator(), new Disposer());

    private LongArrayListSpinAllocator() {
    }

    public static LongArrayList alloc() {
        return allocator.alloc();
    }

    public static void dispose(LongArrayList instance) {
        allocator.dispose(instance);
    }

    private static class Disposer
    implements SpinAllocator.IDisposer<LongArrayList> {
        private Disposer() {
        }

        @Override
        public void disposeInstance(LongArrayList instance) {
            instance.clear();
            if (instance.getCapacity() > 8192) {
                instance.setCapacity(1024);
            }
        }
    }

    private static class Creator
    implements SpinAllocator.ICreator<LongArrayList> {
        private Creator() {
        }

        @Override
        public LongArrayList createInstance() {
            return new LongArrayList(1024);
        }
    }
}

