/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.util;

import jetbrains.exodus.core.dataStructures.IntArrayList;
import jetbrains.exodus.util.SpinAllocator;

public class IntArrayListSpinAllocator {
    private static final int INITIAL_CAPACITY = 1024;
    private static final int MAXIMUM_KEEPING_CAPACITY = 8192;
    private static final SpinAllocator<IntArrayList> allocator = new SpinAllocator<IntArrayList>(new Creator(), new Disposer());

    private IntArrayListSpinAllocator() {
    }

    public static IntArrayList alloc() {
        return allocator.alloc();
    }

    public static void dispose(IntArrayList instance) {
        allocator.dispose(instance);
    }

    private static class Disposer
    implements SpinAllocator.IDisposer<IntArrayList> {
        private Disposer() {
        }

        @Override
        public void disposeInstance(IntArrayList instance) {
            instance.clear();
            if (instance.getCapacity() > 8192) {
                instance.setCapacity(1024);
            }
        }
    }

    private static class Creator
    implements SpinAllocator.ICreator<IntArrayList> {
        private Creator() {
        }

        @Override
        public IntArrayList createInstance() {
            return new IntArrayList(1024);
        }
    }
}

