/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.FieldIndex;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.Table;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlobsTable
extends Table {
    private final Store primaryStore;
    private final FieldIndex allBlobsIndex;

    public BlobsTable(@NotNull PersistentEntityStoreImpl store, @NotNull PersistentStoreTransaction txn, @NotNull String name, @NotNull StoreConfig primaryConfig) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        Environment env = store.getEnvironment();
        this.primaryStore = env.openStore(name, primaryConfig, envTxn);
        this.allBlobsIndex = FieldIndex.fieldIndex(txn, name);
        store.trackTableCreation(this.primaryStore, txn);
    }

    @Nullable
    public ByteIterable get(@NotNull Transaction txn, @NotNull PropertyKey propertyKey) {
        return this.primaryStore.get(txn, PropertyKey.propertyKeyToEntry(propertyKey));
    }

    @Nullable
    public ByteIterable get(@NotNull Transaction txn, long localId, int blobId) {
        return this.get(txn, new PropertyKey(localId, blobId));
    }

    public void put(@NotNull Transaction txn, long localId, int blobId, @NotNull ByteIterable value) {
        this.primaryStore.put(txn, PropertyKey.propertyKeyToEntry(new PropertyKey(localId, blobId)), value);
        this.allBlobsIndex.put(txn, blobId, localId);
    }

    public void delete(@NotNull Transaction txn, long localId, int blobId) {
        ArrayByteIterable key = PropertyKey.propertyKeyToEntry(new PropertyKey(localId, blobId));
        boolean success = this.primaryStore.delete(txn, key) && this.allBlobsIndex.remove(txn, blobId, localId);
        BlobsTable.checkStatus(success, "Failed to delete");
    }

    public Store getPrimaryIndex() {
        return this.primaryStore;
    }

    public FieldIndex getAllBlobsIndex() {
        return this.allBlobsIndex;
    }

    @Override
    public boolean canBeCached() {
        return !this.primaryStore.getConfig().temporaryEmpty && !this.allBlobsIndex.getStore().getConfig().temporaryEmpty;
    }
}

