/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.cached;

import java.util.Arrays;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.cached.SingleTypeSortedEntityIdArrayCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.SingleTypeSortedSetEntityIdCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.cached.iterator.EntityIdArrayIteratorNullTypeId;
import jetbrains.exodus.entitystore.iterate.cached.iterator.OrderedEntityIdCollectionIterator;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseEntityIdArrayIteratorNullTypeId;
import jetbrains.exodus.entitystore.iterate.cached.iterator.ReverseOrderedEntityIdCollectionIterator;
import jetbrains.exodus.entitystore.iterate.util.LongArrayIterator;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.entitystore.util.ImmutableSingleTypeEntityIdBitSet;
import jetbrains.exodus.entitystore.util.ImmutableSingleTypeEntityIdCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleTypeUnsortedEntityIdArrayCachedInstanceIterable
extends CachedInstanceIterable {
    private final int typeId;
    private final long[] localIds;
    @Nullable
    private EntityIdSet idSet;
    private final long min;
    private final long max;

    public SingleTypeUnsortedEntityIdArrayCachedInstanceIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int typeId, long[] localIds, @Nullable EntityIdSet idSet2, long min, long max) {
        super(txn, source);
        this.typeId = typeId;
        this.localIds = localIds;
        this.idSet = idSet2;
        this.min = min;
        this.max = max;
    }

    @Override
    public int getEntityTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    protected CachedInstanceIterable orderById() {
        ImmutableSingleTypeEntityIdBitSet set;
        long range;
        int length;
        if (this.typeId != Integer.MIN_VALUE && (length = this.localIds.length) > 1 && this.min >= 0L && (range = this.max - this.min + 1L) < Integer.MAX_VALUE && range <= 64L * (long)length && (set = new ImmutableSingleTypeEntityIdBitSet(this.typeId, this.min, this.max, this.localIds, length)).count() == length) {
            return new SingleTypeSortedSetEntityIdCachedInstanceIterable(this.txnGetter.getTxn(this), this.getSource(), this.typeId, set);
        }
        Arrays.sort(this.localIds);
        return new SingleTypeSortedEntityIdArrayCachedInstanceIterable(this.txnGetter.getTxn(this), this.getSource(), this.typeId, this.localIds, this.idSet);
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.localIds.length;
    }

    @Override
    protected boolean containsImpl(@NotNull EntityId entityId) {
        EntityIdSet ids = this.idSet;
        if (ids != null) {
            return ids.contains(entityId);
        }
        return super.containsImpl(entityId);
    }

    @Override
    protected int indexOfImpl(@NotNull EntityId entityId) {
        if (this.typeId == entityId.getTypeId()) {
            return LongArrayList.indexOf(this.localIds, entityId.getLocalId());
        }
        return -1;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        if (this.typeId == Integer.MIN_VALUE) {
            return new EntityIdArrayIteratorNullTypeId(this, this.localIds.length);
        }
        return new OrderedEntityIdCollectionIterator(this, new ImmutableSingleTypeEntityIdCollection(this.typeId, this.localIds));
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        if (this.typeId == Integer.MIN_VALUE) {
            return new ReverseEntityIdArrayIteratorNullTypeId(this, this.localIds.length);
        }
        return new ReverseOrderedEntityIdCollectionIterator(this, new ImmutableSingleTypeEntityIdCollection(this.typeId, this.localIds));
    }

    @Override
    @NotNull
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        EntityIdSet result = this.idSet;
        if (result != null) {
            return result;
        }
        result = this.typeId == Integer.MIN_VALUE ? EntityIdSetFactory.newSet().add(null) : this.toSetImpl();
        this.idSet = result;
        return result;
    }

    @NotNull
    private EntityIdSet toSetImpl() {
        long range;
        int length;
        if (this.typeId != Integer.MIN_VALUE && (length = this.localIds.length) > 1 && this.min >= 0L && (range = this.max - this.min + 1L) < Integer.MAX_VALUE && range <= 64L * (long)length) {
            return new ImmutableSingleTypeEntityIdBitSet(this.typeId, this.min, this.max, new LongArrayIterator(this.localIds));
        }
        EntityIdSet result = EntityIdSetFactory.newSet();
        for (long localId : this.localIds) {
            result = result.add(this.typeId, localId);
        }
        return result;
    }
}

