/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.PropertyRangeOrValueIterableBase;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorCounter;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorIsEmptyChecker;
import jetbrains.exodus.entitystore.iterate.UpdatablePropertiesCachedInstanceIterable;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.env.Cursor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0006\u0012\u0004\u0018\u00010\f \u000e*\r\u0012\u0004\u0012\u00020\r\u0018\u00010\b\u00a8\u0006\u00010\b\u00a8\u0006\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/exodus/entitystore/iterate/PropertyValueIterable;", "Ljetbrains/exodus/entitystore/iterate/PropertyRangeOrValueIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "entityTypeId", "", "propertyId", "value", "", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;IILjava/lang/Comparable;)V", "forceCached", "", "", "", "kotlin.jvm.PlatformType", "valueClass", "Ljava/lang/Class;", "canBeCached", "countImpl", "", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "getReverseIteratorImpl", "Ljetbrains/exodus/entitystore/EntityIterator;", "isEmptyImpl", "nonCachedHasFastCountAndIsEmpty", "Companion", "PropertyValueIterator", "xodus-entity-store"})
public final class PropertyValueIterable
extends PropertyRangeOrValueIterableBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Comparable value;
    @NotNull
    private final Class<Comparable<?>> valueClass;
    private boolean forceCached;

    public PropertyValueIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId, @NotNull Comparable<?> value) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        Intrinsics.checkNotNullParameter(value, "value");
        super(txn, entityTypeId, propertyId);
        this.value = PropertyTypes.toLowerCase(value);
        this.valueClass = value.getClass();
    }

    @Override
    public boolean canBeCached() {
        return this.forceCached || this.value instanceof Boolean || super.canBeCached();
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        EntityIterableBase it = this.getPropertyValueIndex();
        if (it.isCachedInstance()) {
            EntityIteratorBase entityIteratorBase;
            UpdatablePropertiesCachedInstanceIterable cached = (UpdatablePropertiesCachedInstanceIterable)it;
            if (!Intrinsics.areEqual(this.value.getClass(), cached.getPropertyValueClass())) {
                EntityIteratorBase entityIteratorBase2 = EntityIteratorBase.EMPTY;
                Intrinsics.checkNotNullExpressionValue(entityIteratorBase2, "{\n                Entity\u2026rBase.EMPTY\n            }");
                entityIteratorBase = entityIteratorBase2;
            } else {
                Comparable comparable = this.value;
                if (comparable == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
                }
                entityIteratorBase = cached.getPropertyValueIterator(comparable);
            }
            return entityIteratorBase;
        }
        Cursor cursor = this.openCursor(txn);
        if (cursor == null) {
            EntityIteratorBase entityIteratorBase = EntityIteratorBase.EMPTY;
            Intrinsics.checkNotNullExpressionValue(entityIteratorBase, "EMPTY");
            return entityIteratorBase;
        }
        Cursor valueIdx = cursor;
        return new PropertyValueIterator(valueIdx, false);
    }

    @Override
    @NotNull
    public EntityIterator getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        EntityIterableBase it = this.getPropertyValueIndex();
        if (it.isCachedInstance()) {
            EntityIterator entityIterator;
            UpdatablePropertiesCachedInstanceIterable cached = (UpdatablePropertiesCachedInstanceIterable)it;
            if (!Intrinsics.areEqual(this.value.getClass(), cached.getPropertyValueClass())) {
                EntityIteratorBase entityIteratorBase = EntityIteratorBase.EMPTY;
                Intrinsics.checkNotNullExpressionValue(entityIteratorBase, "{\n                Entity\u2026rBase.EMPTY\n            }");
                entityIterator = entityIteratorBase;
            } else {
                this.forceCached = true;
                EntityIterator entityIterator2 = this.getOrCreateCachedInstance(txn).getReverseIteratorImpl(txn);
                Intrinsics.checkNotNullExpressionValue(entityIterator2, "{\n                forceC\u2026orImpl(txn)\n            }");
                entityIterator = entityIterator2;
            }
            return entityIterator;
        }
        Cursor cursor = this.openCursor(txn);
        if (cursor == null) {
            EntityIteratorBase entityIteratorBase = EntityIteratorBase.EMPTY;
            Intrinsics.checkNotNullExpressionValue(entityIteratorBase, "EMPTY");
            return entityIteratorBase;
        }
        Cursor valueIdx = cursor;
        return new PropertyValueIterator(valueIdx, true);
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        int entityTypeId = this.getEntityTypeId();
        int propertyId = this.getPropertyId();
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        EntityIterableType entityIterableType = EntityIterableType.ENTITIES_BY_PROP_VALUE;
        return new ConstantEntityIterableHandle(propertyId, entityTypeId, this, persistentEntityStoreImpl, entityIterableType){
            final /* synthetic */ int $propertyId;
            final /* synthetic */ int $entityTypeId;
            final /* synthetic */ PropertyValueIterable this$0;
            {
                this.$propertyId = $propertyId;
                this.$entityTypeId = $entityTypeId;
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            public int[] getPropertyIds() {
                int[] nArray = new int[]{this.$propertyId};
                return nArray;
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkNotNullParameter(builder, "builder");
                super.toString(builder);
                builder.append(this.$entityTypeId);
                builder.append('-');
                builder.append(this.$propertyId);
                builder.append('-');
                builder.append(PropertyValueIterable.access$getValue$p(this.this$0).toString());
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkNotNullParameter(hash, "hash");
                hash.apply(this.$entityTypeId);
                hash.applyDelimiter();
                hash.apply(this.$propertyId);
                hash.applyDelimiter();
                hash.apply(PropertyValueIterable.access$getValue$p(this.this$0).toString());
            }

            public int getEntityTypeId() {
                return this.$entityTypeId;
            }

            public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propId, @Nullable Comparable<?> oldValue, @Nullable Comparable<?> newValue) {
                Intrinsics.checkNotNullParameter(id, "id");
                return this.$propertyId == propId && this.$entityTypeId == id.getTypeId() && (this.isValueMatched(oldValue) || this.isValueMatched(newValue));
            }

            private final boolean isValueMatched(Comparable<?> value) {
                if (value == null) {
                    return false;
                }
                if (value instanceof ComparableSet) {
                    return ((ComparableSet)value).containsItem(PropertyValueIterable.access$getValue$p(this.this$0));
                }
                if (!Intrinsics.areEqual(value.getClass(), PropertyValueIterable.access$getValueClass$p(this.this$0))) {
                    return false;
                }
                return PropertyTypes.toLowerCase(value).compareTo(PropertyValueIterable.access$getValue$p(this.this$0)) == 0;
            }
        };
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        ArrayByteIterable key = this.getStore().getPropertyTypes().dataToPropertyValue(this.value).dataToEntry();
        Cursor valueIdx = this.openCursor(txn);
        return valueIdx == null ? 0L : new SingleKeyCursorCounter(valueIdx, key).getCount();
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        ArrayByteIterable key = this.getStore().getPropertyTypes().dataToPropertyValue(this.value).dataToEntry();
        Cursor valueIdx = this.openCursor(txn);
        return valueIdx == null || new SingleKeyCursorIsEmptyChecker(valueIdx, key).isEmpty();
    }

    private static final EntityIterableBase _init_$lambda-0(PersistentStoreTransaction txn, PersistentEntityStoreImpl $noName_1, Object[] parameters) {
        try {
            Intrinsics.checkNotNullExpressionValue(txn, "txn");
            Object object = parameters[0];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Object object2 = parameters[1];
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Object object3 = parameters[2];
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return new PropertyValueIterable(txn, Integer.parseInt((String)object), Integer.parseInt((String)object2), Long.valueOf(Long.parseLong((String)object3)));
        }
        catch (NumberFormatException e) {
            Intrinsics.checkNotNullExpressionValue(txn, "txn");
            Object object = parameters[0];
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Object object4 = parameters[1];
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Object object5 = parameters[2];
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Comparable<*>");
            }
            return new PropertyValueIterable(txn, Integer.parseInt((String)object), Integer.parseInt((String)object4), (Comparable)object5);
        }
    }

    public static final /* synthetic */ Class access$getValueClass$p(PropertyValueIterable $this) {
        return $this.valueClass;
    }

    static {
        EntityIterableBase.registerType(EntityIterableType.ENTITIES_BY_PROP_VALUE, PropertyValueIterable::_init_$lambda-0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/entitystore/iterate/PropertyValueIterable$Companion;", "", "()V", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/entitystore/iterate/PropertyValueIterable$PropertyValueIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "cursor", "Ljetbrains/exodus/env/Cursor;", "reverse", "", "(Ljetbrains/exodus/entitystore/iterate/PropertyValueIterable;Ljetbrains/exodus/env/Cursor;Z)V", "hasNext", "getReverse", "()Z", "valueBytes", "Ljetbrains/exodus/ArrayByteIterable;", "checkHasNext", "", "success", "hasNextImpl", "nextIdImpl", "Ljetbrains/exodus/entitystore/EntityId;", "xodus-entity-store"})
    private final class PropertyValueIterator
    extends EntityIteratorBase {
        private final boolean reverse;
        private boolean hasNext;
        @NotNull
        private final ArrayByteIterable valueBytes;

        public PropertyValueIterator(Cursor cursor, boolean reverse) {
            Intrinsics.checkNotNullParameter(PropertyValueIterable.this, "this$0");
            Intrinsics.checkNotNullParameter(cursor, "cursor");
            super(PropertyValueIterable.this);
            this.reverse = reverse;
            this.setCursor(cursor);
            ComparableBinding binding = this.getStore().getPropertyTypes().dataToPropertyValue(PropertyValueIterable.this.value).getBinding();
            ArrayByteIterable arrayByteIterable = binding.objectToEntry(PropertyValueIterable.this.value);
            Intrinsics.checkNotNullExpressionValue(arrayByteIterable, "binding.objectToEntry(value)");
            this.valueBytes = arrayByteIterable;
            ByteIterable entry = cursor.getSearchKey(this.valueBytes);
            if (entry != null) {
                if (this.reverse) {
                    if (cursor.getNextNoDup()) {
                        this.checkHasNext(cursor.getPrev());
                    } else {
                        this.checkHasNext(cursor.getLast());
                    }
                } else {
                    this.checkHasNext(true);
                }
            }
        }

        public /* synthetic */ PropertyValueIterator(Cursor cursor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(cursor, bl);
        }

        public final boolean getReverse() {
            return this.reverse;
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                PersistentEntityId persistentEntityId;
                PropertyValueIterable.this.explain(EntityIterableType.ENTITIES_BY_PROP_VALUE);
                Cursor cursor = this.getCursor();
                PersistentEntityId it = persistentEntityId = new PersistentEntityId(PropertyValueIterable.this.getEntityTypeId(), LongBinding.compressedEntryToLong(cursor.getValue()));
                boolean bl = false;
                this.checkHasNext(this.getReverse() ? cursor.getPrevNoDup() : cursor.getNextDup());
                return persistentEntityId;
            }
            return null;
        }

        private final void checkHasNext(boolean success) {
            this.hasNext = success && this.valueBytes.compareTo(this.getCursor().getKey()) == 0;
        }
    }
}

