/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\"\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/entitystore/iterate/IndexEntry;", "T", "", "localId", "", "(J)V", "getLocalId", "()J", "propValue", "getPropValue", "()Ljava/lang/Comparable;", "compareTo", "", "other", "isEqual", "", "right", "(Ljava/lang/Comparable;)Z", "isLessThanOrEqual", "max", "xodus-entity-store"})
abstract class IndexEntry<T extends Comparable<? super T>>
implements Comparable<IndexEntry<T>> {
    private final long localId;

    public IndexEntry(long localId) {
        this.localId = localId;
    }

    public final long getLocalId() {
        return this.localId;
    }

    @NotNull
    public abstract T getPropValue();

    @Override
    public int compareTo(@NotNull IndexEntry<T> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int result = this.getPropValue().compareTo(other.getPropValue());
        if (result == 0) {
            if (this.localId < other.localId) {
                result = -1;
            } else if (this.localId > other.localId) {
                result = 1;
            }
        }
        return result;
    }

    public boolean isEqual(@NotNull T right) {
        Intrinsics.checkNotNullParameter(right, "right");
        return Intrinsics.areEqual(this.getPropValue(), right);
    }

    public boolean isLessThanOrEqual(@NotNull T max) {
        Intrinsics.checkNotNullParameter(max, "max");
        return this.getPropValue().compareTo(max) <= 0;
    }
}

