/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0014R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/entitystore/iterate/FieldIndexIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "it", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "entityTypeId", "", "fieldId", "iterable", "", "Ljetbrains/exodus/core/dataStructures/Pair;", "", "(Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;IILjava/lang/Iterable;)V", "entityId", "Ljetbrains/exodus/entitystore/EntityId;", "iterator", "", "advance", "", "hasNextImpl", "", "nextIdImpl", "xodus-entity-store"})
public final class FieldIndexIterator
extends EntityIteratorBase {
    private final int entityTypeId;
    private final int fieldId;
    @NotNull
    private final Iterator<Pair<Integer, Long>> iterator;
    @Nullable
    private EntityId entityId;

    public FieldIndexIterator(@NotNull EntityIterableBase it, int entityTypeId, int fieldId, @NotNull Iterable<? extends Pair<Integer, Long>> iterable2) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNullParameter(iterable2, "iterable");
        super(it);
        this.entityTypeId = entityTypeId;
        this.fieldId = fieldId;
        this.iterator = iterable2.iterator();
        this.advance();
    }

    @Override
    protected boolean hasNextImpl() {
        return this.entityId != null;
    }

    @Override
    @Nullable
    protected EntityId nextIdImpl() {
        if (this.hasNextImpl()) {
            EntityId entityId = this.entityId;
            this.advance();
            return entityId;
        }
        return null;
    }

    private final void advance() {
        this.entityId = null;
        if (this.iterator.hasNext()) {
            Pair<Integer, Long> next = this.iterator.next();
            Integer n = next.getFirst();
            int n2 = this.fieldId;
            if (n != null && n == n2) {
                Long l = next.getSecond();
                Intrinsics.checkNotNullExpressionValue(l, "next.second");
                this.entityId = new PersistentEntityId(this.entityTypeId, ((Number)l).longValue());
            }
        }
    }
}

