/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.io.Closeable;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.env.BitmapImpl;
import jetbrains.exodus.env.BitmapIterator;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.kotlin.KodusKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0015\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0015\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "entityTypeId", "", "min", "", "max", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;IJJ)V", "countImpl", "getEntityTypeId", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "openBitmapIterator", "Ljetbrains/exodus/env/BitmapIterator;", "Lorg/jetbrains/annotations/NotNull;", "openCursor", "Ljetbrains/exodus/env/Cursor;", "Companion", "EntitiesOfTypeBitmapIterator", "EntitiesOfTypeIterator", "xodus-entity-store"})
public final class EntitiesOfTypeRangeIterable
extends EntityIterableBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int entityTypeId;
    private final long min;
    private final long max;

    public EntitiesOfTypeRangeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, long min, long max) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        super(txn);
        this.entityTypeId = entityTypeId;
        this.min = min;
        this.max = max;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkNotNullParameter(txn, "txn");
        return this.getStore().useVersion1Format() ? (EntityIteratorBase)new EntitiesOfTypeIterator(this, this.openCursor(txn)) : (EntityIteratorBase)new EntitiesOfTypeBitmapIterator(this, this.openBitmapIterator(txn));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        EntityIterableType entityIterableType = Companion.getType();
        return new ConstantEntityIterableHandle(this, persistentEntityStoreImpl, entityIterableType){
            final /* synthetic */ EntitiesOfTypeRangeIterable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkNotNullParameter(builder, "builder");
                super.toString(builder);
                builder.append(this.getEntityTypeId());
                builder.append('-');
                builder.append(EntitiesOfTypeRangeIterable.access$getMin$p(this.this$0));
                builder.append('-');
                builder.append(EntitiesOfTypeRangeIterable.access$getMax$p(this.this$0));
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkNotNullParameter(hash, "hash");
                hash.apply(this.getEntityTypeId());
                hash.applyDelimiter();
                hash.apply(EntitiesOfTypeRangeIterable.access$getMin$p(this.this$0));
                hash.applyDelimiter();
                hash.apply(EntitiesOfTypeRangeIterable.access$getMax$p(this.this$0));
            }

            @NotNull
            public int[] getTypeIdsAffectingCreation() {
                int[] nArray = new int[]{this.getEntityTypeId()};
                return nArray;
            }

            public int getEntityTypeId() {
                return EntitiesOfTypeRangeIterable.access$getEntityTypeId$p(this.this$0);
            }

            public boolean isMatchedEntityAdded(@NotNull EntityId added) {
                Intrinsics.checkNotNullParameter(added, "added");
                return added.getTypeId() == this.getEntityTypeId() && this.isRangeAffected(added.getLocalId());
            }

            public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
                Intrinsics.checkNotNullParameter(deleted, "deleted");
                return deleted.getTypeId() == this.getEntityTypeId() && this.isRangeAffected(deleted.getLocalId());
            }

            private final boolean isRangeAffected(long id) {
                long l = EntitiesOfTypeRangeIterable.access$getMin$p(this.this$0);
                return id <= EntitiesOfTypeRangeIterable.access$getMax$p(this.this$0) ? l <= id : false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        long l;
        Intrinsics.checkNotNullParameter(txn, "txn");
        if (this.getStore().useVersion1Format()) {
            Closeable closeable = this.openCursor(txn);
            Throwable throwable = null;
            try {
                boolean success;
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                ArrayByteIterable arrayByteIterable = LongBinding.longToCompressedEntry(this.min);
                Intrinsics.checkNotNullExpressionValue(arrayByteIterable, "longToCompressedEntry(min)");
                ByteIterable key = arrayByteIterable;
                long result = 0L;
                boolean bl2 = success = cursor.getSearchKeyRange(key) != null;
                while (success && this.max <= LongBinding.compressedEntryToLong(cursor.getKey())) {
                    long l2 = result;
                    result = l2 + 1L;
                    success = cursor.getNextNoDup();
                }
                long l3 = result;
                l = l3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        } else {
            BitmapImpl bitmapImpl = this.getStore().getEntitiesBitmapTable(txn, this.entityTypeId);
            Transaction transaction = txn.getEnvironmentTransaction();
            Intrinsics.checkNotNullExpressionValue(transaction, "txn.environmentTransaction");
            l = bitmapImpl.count(transaction, this.min, this.max);
        }
        return l;
    }

    private final Cursor openCursor(PersistentStoreTransaction txn) {
        Cursor cursor = this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId);
        Intrinsics.checkNotNullExpressionValue(cursor, "store.getEntitiesIndexCursor(txn, entityTypeId)");
        return cursor;
    }

    private final BitmapIterator openBitmapIterator(PersistentStoreTransaction txn) {
        BitmapIterator bitmapIterator = this.getStore().getEntitiesBitmapIterator(txn, this.entityTypeId);
        Intrinsics.checkNotNullExpressionValue(bitmapIterator, "store.getEntitiesBitmapIterator(txn, entityTypeId)");
        return bitmapIterator;
    }

    private static final EntityIterableBase _init_$lambda-1(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
        long min = Long.parseLong(KodusKt.getNotNull((String)parameters[1]));
        long max = Long.parseLong(KodusKt.getNotNull((String)parameters[2]));
        Intrinsics.checkNotNullExpressionValue(txn, "txn");
        return new EntitiesOfTypeRangeIterable(txn, Integer.parseInt(KodusKt.getNotNull((String)parameters[0])), min, max);
    }

    static {
        EntityIterableBase.registerType(Companion.getType(), EntitiesOfTypeRangeIterable::_init_$lambda-1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\bH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable$EntitiesOfTypeIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "iterable", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable;", "index", "Ljetbrains/exodus/env/Cursor;", "(Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable;Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable;Ljetbrains/exodus/env/Cursor;)V", "hasNext", "", "checkHasNext", "", "success", "hasNextImpl", "nextIdImpl", "Ljetbrains/exodus/entitystore/EntityId;", "xodus-entity-store"})
    private final class EntitiesOfTypeIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        public EntitiesOfTypeIterator(@NotNull EntitiesOfTypeRangeIterable iterable2, Cursor index2) {
            Intrinsics.checkNotNullParameter(EntitiesOfTypeRangeIterable.this, "this$0");
            Intrinsics.checkNotNullParameter(iterable2, "iterable");
            Intrinsics.checkNotNullParameter(index2, "index");
            super(iterable2);
            this.setCursor(index2);
            ArrayByteIterable arrayByteIterable = LongBinding.longToCompressedEntry(EntitiesOfTypeRangeIterable.this.min);
            Intrinsics.checkNotNullExpressionValue(arrayByteIterable, "longToCompressedEntry(min)");
            ByteIterable key = arrayByteIterable;
            this.checkHasNext(this.getCursor().getSearchKeyRange(key) != null);
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntitiesOfTypeRangeIterable.this.explain(Companion.getType());
                Cursor cursor = this.getCursor();
                Intrinsics.checkNotNullExpressionValue(cursor, "cursor");
                Cursor cursor2 = cursor;
                long localId = LongBinding.compressedEntryToLong(cursor2.getKey());
                EntityId result = new PersistentEntityId(EntitiesOfTypeRangeIterable.this.entityTypeId, localId);
                this.checkHasNext(cursor2.getNext());
                return result;
            }
            return null;
        }

        private final void checkHasNext(boolean success) {
            this.hasNext = success && EntitiesOfTypeRangeIterable.this.max >= LongBinding.compressedEntryToLong(this.getCursor().getKey());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable$EntitiesOfTypeBitmapIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "iterable", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable;", "it", "Ljetbrains/exodus/env/BitmapIterator;", "(Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable;Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable;Ljetbrains/exodus/env/BitmapIterator;)V", "getIt", "()Ljetbrains/exodus/env/BitmapIterator;", "next", "Ljetbrains/exodus/entitystore/EntityId;", "checkNext", "", "hasNextImpl", "", "nextIdImpl", "xodus-entity-store"})
    private final class EntitiesOfTypeBitmapIterator
    extends EntityIteratorBase {
        @NotNull
        private final BitmapIterator it;
        @Nullable
        private EntityId next;

        public EntitiesOfTypeBitmapIterator(@NotNull EntitiesOfTypeRangeIterable iterable2, BitmapIterator it) {
            Intrinsics.checkNotNullParameter(EntitiesOfTypeRangeIterable.this, "this$0");
            Intrinsics.checkNotNullParameter(iterable2, "iterable");
            Intrinsics.checkNotNullParameter(it, "it");
            super(iterable2);
            this.it = it;
            this.setCursor(this.it.getCursor());
            if (this.it.getSearchBit(EntitiesOfTypeRangeIterable.this.min)) {
                this.checkNext();
            }
        }

        @NotNull
        public final BitmapIterator getIt() {
            return this.it;
        }

        @Override
        protected boolean hasNextImpl() {
            return this.next != null;
        }

        @Override
        @Nullable
        protected EntityId nextIdImpl() {
            EntityId entityId;
            EntityId it = entityId = this.next;
            boolean bl = false;
            this.checkNext();
            return entityId;
        }

        private final void checkNext() {
            this.next = null;
            if (this.it.hasNext()) {
                Long l = this.it.next();
                EntitiesOfTypeRangeIterable entitiesOfTypeRangeIterable = EntitiesOfTypeRangeIterable.this;
                long localId = ((Number)l).longValue();
                boolean bl = false;
                if (entitiesOfTypeRangeIterable.max >= localId) {
                    this.next = new PersistentEntityId(entitiesOfTypeRangeIterable.entityTypeId, localId);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeRangeIterable$Companion;", "", "()V", "type", "Ljetbrains/exodus/entitystore/EntityIterableType;", "getType", "()Ljetbrains/exodus/entitystore/EntityIterableType;", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityIterableType getType() {
            return EntityIterableType.ALL_ENTITIES_RANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

