/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.util.StringInterner;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class StoreNamingRules {
    @NonNls
    private static final String ENTITIES_SEQUENCES_PREFIX = "entities.sequences";
    @NonNls
    private static final String ENTITY_TYPES_SEQUENCE = "entity.types.sequence";
    @NonNls
    private static final String PROPERTY_IDS_SEQUENCE = "property.types.sequence";
    @NonNls
    private static final String LINK_IDS_SEQUENCE = "link.types.sequence";
    @NonNls
    private static final String PROPERTY_CUSTOM_TYPES_SEQUENCE = "property.custom.types.sequence";
    @NonNls
    private static final String ENTITY_TYPES_TABLE = "entity.types";
    @NonNls
    private static final String PROPERTY_IDS_TABLE = "property.types";
    @NonNls
    private static final String LINK_IDS_TABLE = "link.types";
    @NonNls
    private static final String PROPERTY_CUSTOM_TYPES_TABLE = "property.custom.types";
    @NonNls
    private static final String ENTITIES_TABLE_PREFIX = "entities";
    @NonNls
    private static final String PROPERTIES_TABLE_PREFIX = "properties";
    @NonNls
    private static final String LINKS_TABLE_PREFIX = "links";
    @NonNls
    private static final String BLOBS_TABLE_PREFIX = "blobs";
    @NonNls
    private static final String BLOB_FILE_LENGTHS = "blobFileLengths";
    @NonNls
    private static final String INTERNAL_SETTINGS = "----internal.settings----";
    @NotNull
    private final String storeName;

    StoreNamingRules(@NotNull String storeName) {
        this.storeName = storeName;
    }

    @NotNull
    String getEntityTypesSequenceName() {
        return this.getFQName(ENTITY_TYPES_SEQUENCE, new Object[0]);
    }

    @NotNull
    String getPropertyIdsSequenceName() {
        return this.getFQName(PROPERTY_IDS_SEQUENCE, new Object[0]);
    }

    @NotNull
    String getLinkIdsSequenceName() {
        return this.getFQName(LINK_IDS_SEQUENCE, new Object[0]);
    }

    @NotNull
    String getPropertyCustomTypesSequence() {
        return this.getFQName(PROPERTY_CUSTOM_TYPES_SEQUENCE, new Object[0]);
    }

    @NotNull
    String getEntitiesSequenceName(int entityTypeId) {
        return this.getFQName(ENTITIES_SEQUENCES_PREFIX, entityTypeId);
    }

    @NotNull
    String getEntityTypesTableName() {
        return this.getFQName(ENTITY_TYPES_TABLE, new Object[0]);
    }

    @NotNull
    String getPropertyIdsTableName() {
        return this.getFQName(PROPERTY_IDS_TABLE, new Object[0]);
    }

    @NotNull
    String getLinkIdsTableName() {
        return this.getFQName(LINK_IDS_TABLE, new Object[0]);
    }

    @NotNull
    String getPropertyCustomTypesTable() {
        return this.getFQName(PROPERTY_CUSTOM_TYPES_TABLE, new Object[0]);
    }

    @NotNull
    String getEntitiesTableName(int entityTypeId) {
        return this.getFQName(ENTITIES_TABLE_PREFIX, entityTypeId);
    }

    @NotNull
    String getPropertiesTableName(int entityTypeId) {
        return this.getFQName(PROPERTIES_TABLE_PREFIX, entityTypeId);
    }

    @NotNull
    String getLinksTableName(int entityTypeId) {
        return this.getFQName(LINKS_TABLE_PREFIX, entityTypeId);
    }

    @NotNull
    String getBlobsObsoleteTableName(int entityTypeId) {
        return this.getFQName(BLOBS_TABLE_PREFIX, entityTypeId);
    }

    @NotNull
    String getBlobsTableName(int entityTypeId) {
        return this.getFQName(BLOBS_TABLE_PREFIX, entityTypeId, "v2");
    }

    @NotNull
    String getBlobHashesTableName(int entityTypeId) {
        return this.getFQName(BLOBS_TABLE_PREFIX, entityTypeId, "#hashes");
    }

    String getBlobFileLengthsTable() {
        return this.getFQName(BLOB_FILE_LENGTHS, new Object[0]);
    }

    @NotNull
    String getInternalSettingsName() {
        return this.getFQName(INTERNAL_SETTINGS, new Object[0]);
    }

    @NotNull
    private String getFQName(@NotNull String localName, Object ... params) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.storeName);
        builder.append('.');
        builder.append(localName);
        for (Object param : params) {
            builder.append('#');
            builder.append(param);
        }
        return StringInterner.intern(builder.toString());
    }
}

