/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.lang.ref.SoftReference;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.EvictListener;
import jetbrains.exodus.core.dataStructures.persistent.PersistentObjectCache;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapterMutable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.Updatable;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\t\b\u0010\u0018\u0000 22\u00020\u0001:\u0003123B;\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\u00020\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060$J\u0010\u0010%\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0006J\u0010\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\u0006J\u0010\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010*\u001a\u00020+J\u001c\u0010,\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\u0006\u0010/\u001a\u00020!J\u0010\u00100\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\u0006R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00064"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter;", "", "config", "Ljetbrains/exodus/entitystore/PersistentEntityStoreConfig;", "cache", "Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$NonAdjustablePersistentObjectCache;", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$CacheItem;", "stickyObjects", "Ljetbrains/exodus/core/dataStructures/hash/HashMap;", "Ljetbrains/exodus/entitystore/Updatable;", "(Ljetbrains/exodus/entitystore/PersistentEntityStoreConfig;Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$NonAdjustablePersistentObjectCache;Ljetbrains/exodus/core/dataStructures/hash/HashMap;)V", "getCache$xodus_entity_store", "()Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$NonAdjustablePersistentObjectCache;", "clone", "Ljetbrains/exodus/entitystore/EntityIterableCacheAdapterMutable;", "getClone", "()Ljetbrains/exodus/entitystore/EntityIterableCacheAdapterMutable;", "getConfig$xodus_entity_store", "()Ljetbrains/exodus/entitystore/PersistentEntityStoreConfig;", "isSparse", "", "()Z", "getStickyObjects$xodus_entity_store", "()Ljetbrains/exodus/core/dataStructures/hash/HashMap;", "adjustHitRate", "", "cacheObject", "key", "it", "Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;", "clear", "count", "", "forEachKey", "procedure", "Ljetbrains/exodus/core/dataStructures/hash/ObjectProcedure;", "getObject", "getStickyObject", "handle", "getStickyObjectUnsafe", "getUpdatable", "hitRate", "", "parseCachedObject", "item", "remove", "size", "tryKey", "CacheItem", "Companion", "NonAdjustablePersistentObjectCache", "xodus-entity-store"})
public class EntityIterableCacheAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentEntityStoreConfig config;
    @NotNull
    private final NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem> cache;
    @NotNull
    private final HashMap<EntityIterableHandle, Updatable> stickyObjects;

    @JvmOverloads
    public EntityIterableCacheAdapter(@NotNull PersistentEntityStoreConfig config, @NotNull NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem> cache, @NotNull HashMap<EntityIterableHandle, Updatable> stickyObjects) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(cache, "cache");
        Intrinsics.checkNotNullParameter(stickyObjects, "stickyObjects");
        this.config = config;
        this.cache = cache;
        this.stickyObjects = stickyObjects;
    }

    public /* synthetic */ EntityIterableCacheAdapter(PersistentEntityStoreConfig persistentEntityStoreConfig, NonAdjustablePersistentObjectCache nonAdjustablePersistentObjectCache, HashMap hashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            nonAdjustablePersistentObjectCache = new NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem>(persistentEntityStoreConfig.getEntityIterableCacheSize());
        }
        if ((n & 4) != 0) {
            hashMap = new HashMap<EntityIterableHandle, Updatable>();
        }
        this(persistentEntityStoreConfig, nonAdjustablePersistentObjectCache, hashMap);
    }

    @NotNull
    public final PersistentEntityStoreConfig getConfig$xodus_entity_store() {
        return this.config;
    }

    @NotNull
    public final NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem> getCache$xodus_entity_store() {
        return this.cache;
    }

    @NotNull
    public final HashMap<EntityIterableHandle, Updatable> getStickyObjects$xodus_entity_store() {
        return this.stickyObjects;
    }

    @Nullable
    public final CachedInstanceIterable tryKey(@NotNull EntityIterableHandle key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (key.isSticky()) {
            return (CachedInstanceIterable)((Object)this.getStickyObject(key));
        }
        CachedInstanceIterable cachedInstanceIterable = (CachedInstanceIterable)((Object)this.getStickyObjectUnsafe(key));
        if (cachedInstanceIterable == null) {
            cachedInstanceIterable = this.parseCachedObject(key, (CacheItem)this.cache.tryKey(key));
        }
        return cachedInstanceIterable;
    }

    @Nullable
    public final CachedInstanceIterable getObject(@NotNull EntityIterableHandle key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (key.isSticky()) {
            return (CachedInstanceIterable)((Object)this.getStickyObject(key));
        }
        CachedInstanceIterable cachedInstanceIterable = (CachedInstanceIterable)((Object)this.getStickyObjectUnsafe(key));
        if (cachedInstanceIterable == null) {
            cachedInstanceIterable = this.parseCachedObject(key, (CacheItem)this.cache.getObject(key));
        }
        return cachedInstanceIterable;
    }

    @Nullable
    public final Updatable getUpdatable(@NotNull EntityIterableHandle key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (key.isSticky()) {
            return this.getStickyObject(key);
        }
        Updatable updatable = this.getStickyObjectUnsafe(key);
        if (updatable == null) {
            updatable = (Updatable)((Object)this.parseCachedObject(key, (CacheItem)this.cache.getObject(key)));
        }
        return updatable;
    }

    public void cacheObject(@NotNull EntityIterableHandle key, @NotNull CachedInstanceIterable it) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(it, "it");
        if (it instanceof Updatable && this.stickyObjects.containsKey(key)) {
            Map map = this.stickyObjects;
            CachedInstanceIterable cachedInstanceIterable = it;
            map.put(key, cachedInstanceIterable);
        } else {
            this.cache.cacheObject(key, new CacheItem(it, this.config.getEntityIterableCacheMaxSizeOfDirectValue()));
        }
    }

    public final void forEachKey(@NotNull ObjectProcedure<EntityIterableHandle> procedure) {
        Intrinsics.checkNotNullParameter(procedure, "procedure");
        this.cache.forEachKey(procedure);
    }

    public void remove(@NotNull EntityIterableHandle key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.cache.remove(key);
    }

    public final float hitRate() {
        return this.cache.hitRate();
    }

    public final int count() {
        return this.cache.count();
    }

    public final int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    public final boolean isSparse() {
        return this.cache.count() < this.cache.size() / 2;
    }

    @NotNull
    public final EntityIterableCacheAdapterMutable getClone() {
        return EntityIterableCacheAdapterMutable.Companion.create(this);
    }

    public final void adjustHitRate() {
        this.cache.adjustHitRate();
    }

    @Nullable
    public final Updatable getStickyObjectUnsafe(@NotNull EntityIterableHandle handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        return (Updatable)this.stickyObjects.get(handle);
    }

    @NotNull
    public final Updatable getStickyObject(@NotNull EntityIterableHandle handle) {
        Intrinsics.checkNotNullParameter(handle, "handle");
        Updatable updatable = this.getStickyObjectUnsafe(handle);
        if (updatable == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("Sticky object not found, handle=", EntityIterableCache.Companion.toString(this.config, handle)));
        }
        return updatable;
    }

    private final CachedInstanceIterable parseCachedObject(EntityIterableHandle key, CacheItem item) {
        CacheItem cacheItem = item;
        if (cacheItem != null) {
            CacheItem it = cacheItem;
            boolean bl = false;
            CachedInstanceIterable cached = it.getCached();
            if (cached == null) {
                SoftReference<CachedInstanceIterable> softReference = it.getRef();
                CachedInstanceIterable cachedInstanceIterable = cached = softReference == null ? null : softReference.get();
                if (cached == null) {
                    this.getCache$xodus_entity_store().remove(key);
                }
            }
            return cached;
        }
        return null;
    }

    @JvmOverloads
    public EntityIterableCacheAdapter(@NotNull PersistentEntityStoreConfig config, @NotNull NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem> cache) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(cache, "cache");
        this(config, cache, null, 4, null);
    }

    @JvmOverloads
    public EntityIterableCacheAdapter(@NotNull PersistentEntityStoreConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this(config, null, null, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$CacheItem;", "", "it", "Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;", "maxSizeOfDirectValue", "", "(Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;I)V", "cached", "getCached", "()Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;", "setCached", "(Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;)V", "ref", "Ljava/lang/ref/SoftReference;", "getRef", "()Ljava/lang/ref/SoftReference;", "setRef", "(Ljava/lang/ref/SoftReference;)V", "xodus-entity-store"})
    public static final class CacheItem {
        @Nullable
        private CachedInstanceIterable cached;
        @Nullable
        private SoftReference<CachedInstanceIterable> ref;

        public CacheItem(@NotNull CachedInstanceIterable it, int maxSizeOfDirectValue) {
            Intrinsics.checkNotNullParameter(it, "it");
            if (it.isUpdatable() || it.size() <= (long)maxSizeOfDirectValue) {
                this.cached = it;
                this.ref = null;
            } else {
                this.cached = null;
                this.ref = new SoftReference<CachedInstanceIterable>(it);
            }
        }

        @Nullable
        public final CachedInstanceIterable getCached() {
            return this.cached;
        }

        public final void setCached(@Nullable CachedInstanceIterable cachedInstanceIterable) {
            this.cached = cachedInstanceIterable;
        }

        @Nullable
        public final SoftReference<CachedInstanceIterable> getRef() {
            return this.ref;
        }

        public final void setRef(@Nullable SoftReference<CachedInstanceIterable> softReference) {
            this.ref = softReference;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B1\b\u0016\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\tH\u0016\u00a8\u0006\u000f"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$NonAdjustablePersistentObjectCache;", "K", "V", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentObjectCache;", "size", "", "(I)V", "source", "listener", "Ljetbrains/exodus/core/dataStructures/persistent/EvictListener;", "(Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$NonAdjustablePersistentObjectCache;Ljetbrains/exodus/core/dataStructures/persistent/EvictListener;)V", "endWrite", "getCacheAdjuster", "Ljetbrains/exodus/core/execution/SharedTimer$ExpirablePeriodicTask;", "getClone", "xodus-entity-store"})
    public static final class NonAdjustablePersistentObjectCache<K, V>
    extends PersistentObjectCache<K, V> {
        public NonAdjustablePersistentObjectCache(int size) {
            super(size);
        }

        public NonAdjustablePersistentObjectCache(@NotNull NonAdjustablePersistentObjectCache<K, V> source, @Nullable EvictListener<K, V> listener) {
            Intrinsics.checkNotNullParameter(source, "source");
            super(source, listener);
        }

        @Override
        @NotNull
        public NonAdjustablePersistentObjectCache<K, V> getClone(@Nullable EvictListener<K, V> listener) {
            return new NonAdjustablePersistentObjectCache<K, V>(this, listener);
        }

        @NotNull
        public final NonAdjustablePersistentObjectCache<K, V> endWrite() {
            return new NonAdjustablePersistentObjectCache<K, V>(this, null);
        }

        @Override
        @Nullable
        protected SharedTimer.ExpirablePeriodicTask getCacheAdjuster() {
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$Companion;", "", "()V", "getCachedValue", "Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;", "item", "Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter$CacheItem;", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CachedInstanceIterable getCachedValue(@NotNull CacheItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            CachedInstanceIterable cached = item.getCached();
            if (cached == null) {
                SoftReference<CachedInstanceIterable> softReference = item.getRef();
                cached = softReference == null ? null : softReference.get();
            }
            return cached;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

