/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.LongComparable;
import jetbrains.exodus.core.dataStructures.persistent.LongIteratorsKt;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005\u0010\u0011\u0012\u0013\u0014B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet;", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet;", "bitsPerEntry", "", "(I)V", "source", "(Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet;)V", "elementsPerEntry", "mask", "root", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Root;", "beginRead", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "beginWrite", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$MutableSet;", "getClone", "Entry", "ImmutableSet", "ItemIterator", "MutableSet", "Root", "xodus-utils"})
public final class PersistentBitTreeLongSet
implements PersistentLongSet {
    @NotNull
    private final Root root;
    private final int bitsPerEntry;
    private final int elementsPerEntry;
    private final int mask;

    @JvmOverloads
    public PersistentBitTreeLongSet(int bitsPerEntry) {
        this.bitsPerEntry = bitsPerEntry;
        this.elementsPerEntry = 1 << bitsPerEntry;
        this.mask = this.elementsPerEntry - 1;
        this.root = new Root(new Persistent23Tree<Entry>(), 0);
    }

    public /* synthetic */ PersistentBitTreeLongSet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    private PersistentBitTreeLongSet(PersistentBitTreeLongSet source) {
        this.bitsPerEntry = source.bitsPerEntry;
        this.elementsPerEntry = source.elementsPerEntry;
        this.mask = source.mask;
        this.root = source.root.getClone();
    }

    @Override
    @NotNull
    public PersistentLongSet.ImmutableSet beginRead() {
        Persistent23Tree.ImmutableTree<Entry> immutableTree = this.root.getMap$xodus_utils().beginRead();
        Intrinsics.checkNotNullExpressionValue(immutableTree, "root.map.beginRead()");
        return new ImmutableSet((AbstractPersistent23Tree<Entry>)immutableTree, this.root.getSize$xodus_utils(), this.bitsPerEntry, this.mask);
    }

    @Override
    @NotNull
    public PersistentLongSet getClone() {
        return new PersistentBitTreeLongSet(this);
    }

    @Override
    @NotNull
    public PersistentLongSet.MutableSet beginWrite() {
        Persistent23Tree.MutableTree<Entry> mutableTree = this.root.getMap$xodus_utils().beginWrite();
        Intrinsics.checkNotNullExpressionValue(mutableTree, "root.map.beginWrite()");
        return new MutableSet(mutableTree, this.root.getSize$xodus_utils(), this.bitsPerEntry, this.mask, this);
    }

    @JvmOverloads
    public PersistentBitTreeLongSet() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B-\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$ImmutableSet;", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$ImmutableSet;", "map", "Ljetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree;", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Entry;", "size", "", "bitsPerEntry", "mask", "(Ljetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree;III)V", "contains", "", "key", "", "getEntryByIndex", "index", "isEmpty", "longIterator", "Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "reverseLongIterator", "tailLongIterator", "tailReverseLongIterator", "xodus-utils"})
    private static final class ImmutableSet
    implements PersistentLongSet.ImmutableSet {
        @NotNull
        private final AbstractPersistent23Tree<Entry> map;
        private final int size;
        private final int bitsPerEntry;
        private final int mask;

        public ImmutableSet(@NotNull AbstractPersistent23Tree<Entry> map, int size, int bitsPerEntry, int mask) {
            Intrinsics.checkNotNullParameter(map, "map");
            this.map = map;
            this.size = size;
            this.bitsPerEntry = bitsPerEntry;
            this.mask = mask;
        }

        private final Entry getEntryByIndex(long index2) {
            AbstractPersistent23Tree.RootNode<Entry> rootNode = this.map.getRoot();
            if (rootNode == null) {
                return null;
            }
            AbstractPersistent23Tree.RootNode<Entry> root = rootNode;
            return (Entry)root.getByWeight(index2);
        }

        @Override
        public boolean contains(long key) {
            Entry entry = this.getEntryByIndex(key >> this.bitsPerEntry);
            return entry != null && entry.getBits$xodus_utils().get((int)key & this.mask);
        }

        @Override
        @NotNull
        public LongIterator longIterator() {
            Iterator<Entry> iterator2 = this.map.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "map.iterator()");
            return new ItemIterator(iterator2, this.bitsPerEntry, false, 4, null);
        }

        @Override
        @NotNull
        public LongIterator reverseLongIterator() {
            Iterator<Entry> iterator2 = this.map.reverseIterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "map.reverseIterator()");
            return new ItemIterator(iterator2, this.bitsPerEntry, true);
        }

        @Override
        @NotNull
        public LongIterator tailLongIterator(long key) {
            LongIterator longIterator;
            Entry entry = this.getEntryByIndex(key >> this.bitsPerEntry);
            if (entry == null) {
                LongIterator longIterator2 = LongIterator.EMPTY;
                Intrinsics.checkNotNullExpressionValue(longIterator2, "EMPTY");
                longIterator = longIterator2;
            } else {
                Iterator<Entry> iterator2 = this.map.tailIterator((Entry)((Comparable)entry));
                Intrinsics.checkNotNullExpressionValue(iterator2, "map.tailIterator(entry)");
                longIterator = LongIteratorsKt.skipTail(new ItemIterator(iterator2, this.bitsPerEntry, false, 4, null), key);
            }
            return longIterator;
        }

        @Override
        @NotNull
        public LongIterator tailReverseLongIterator(long key) {
            LongIterator longIterator;
            Entry entry = this.getEntryByIndex(key >> this.bitsPerEntry);
            if (entry == null) {
                LongIterator longIterator2 = LongIterator.EMPTY;
                Intrinsics.checkNotNullExpressionValue(longIterator2, "EMPTY");
                longIterator = longIterator2;
            } else {
                Iterator<Entry> iterator2 = this.map.tailReverseIterator((Entry)((Comparable)entry));
                Intrinsics.checkNotNullExpressionValue(iterator2, "map.tailReverseIterator(entry)");
                longIterator = LongIteratorsKt.skipTail(new ItemIterator(iterator2, this.bitsPerEntry, true), key);
            }
            return longIterator;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B5\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$MutableSet;", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongSet$MutableSet;", "mutableSet", "Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree$MutableTree;", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Entry;", "size", "", "bitsPerEntry", "mask", "baseSet", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet;", "(Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree$MutableTree;IIILjetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet;)V", "add", "", "key", "", "clear", "contains", "", "endWrite", "getEntryByIndex", "index", "isEmpty", "longIterator", "Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "remove", "reverseLongIterator", "tailLongIterator", "tailReverseLongIterator", "xodus-utils"})
    public static final class MutableSet
    implements PersistentLongSet.MutableSet {
        @NotNull
        private final Persistent23Tree.MutableTree<Entry> mutableSet;
        private int size;
        private final int bitsPerEntry;
        private final int mask;
        @NotNull
        private final PersistentBitTreeLongSet baseSet;

        public MutableSet(@NotNull Persistent23Tree.MutableTree<Entry> mutableSet, int size, int bitsPerEntry, int mask, @NotNull PersistentBitTreeLongSet baseSet) {
            Intrinsics.checkNotNullParameter(mutableSet, "mutableSet");
            Intrinsics.checkNotNullParameter(baseSet, "baseSet");
            this.mutableSet = mutableSet;
            this.size = size;
            this.bitsPerEntry = bitsPerEntry;
            this.mask = mask;
            this.baseSet = baseSet;
        }

        private final Entry getEntryByIndex(long index2) {
            AbstractPersistent23Tree.RootNode<Entry> rootNode = this.mutableSet.getRoot();
            if (rootNode == null) {
                return null;
            }
            AbstractPersistent23Tree.RootNode<Entry> root = rootNode;
            return (Entry)root.getByWeight(index2);
        }

        @Override
        public boolean contains(long key) {
            Entry entry = this.getEntryByIndex(key >> this.bitsPerEntry);
            return entry != null && entry.getBits$xodus_utils().get((int)key & this.mask);
        }

        @Override
        @NotNull
        public LongIterator longIterator() {
            Iterator iterator2 = this.mutableSet.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "mutableSet.iterator()");
            return new ItemIterator(iterator2, this.bitsPerEntry, false, 4, null);
        }

        @Override
        @NotNull
        public LongIterator reverseLongIterator() {
            Iterator<Entry> iterator2 = this.mutableSet.reverseIterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "mutableSet.reverseIterator()");
            return new ItemIterator(iterator2, this.bitsPerEntry, true);
        }

        @Override
        @NotNull
        public LongIterator tailLongIterator(long key) {
            LongIterator longIterator;
            Entry entry = this.getEntryByIndex(key >> this.bitsPerEntry);
            if (entry == null) {
                LongIterator longIterator2 = LongIterator.EMPTY;
                Intrinsics.checkNotNullExpressionValue(longIterator2, "EMPTY");
                longIterator = longIterator2;
            } else {
                Iterator<Entry> iterator2 = this.mutableSet.tailIterator((Entry)((Comparable)entry));
                Intrinsics.checkNotNullExpressionValue(iterator2, "mutableSet.tailIterator(entry)");
                longIterator = LongIteratorsKt.skipTail(new ItemIterator(iterator2, this.bitsPerEntry, false, 4, null), key);
            }
            return longIterator;
        }

        @Override
        @NotNull
        public LongIterator tailReverseLongIterator(long key) {
            LongIterator longIterator;
            Entry entry = this.getEntryByIndex(key >> this.bitsPerEntry);
            if (entry == null) {
                LongIterator longIterator2 = LongIterator.EMPTY;
                Intrinsics.checkNotNullExpressionValue(longIterator2, "EMPTY");
                longIterator = longIterator2;
            } else {
                Iterator<Entry> iterator2 = this.mutableSet.tailReverseIterator((Entry)((Comparable)entry));
                Intrinsics.checkNotNullExpressionValue(iterator2, "mutableSet.tailReverseIterator(entry)");
                longIterator = LongIteratorsKt.skipTail(new ItemIterator(iterator2, this.bitsPerEntry, true), key);
            }
            return longIterator;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void add(long key) {
            long index2 = key >> this.bitsPerEntry;
            Entry entry = this.getEntryByIndex(index2);
            int bitIndex = (int)key & this.mask;
            if (entry == null) {
                entry = new Entry(index2, this.mask + 1);
                this.mutableSet.add((Entry)((Comparable)entry));
                int n = this.size;
                this.size = n + 1;
            } else {
                if (entry.getBits$xodus_utils().get(bitIndex)) {
                    return;
                }
                Entry copy = new Entry(index2, entry, this.mask + 1);
                this.mutableSet.add((Entry)((Comparable)copy));
                entry = copy;
                int n = this.size;
                this.size = n + 1;
            }
            entry.getBits$xodus_utils().set(bitIndex);
        }

        @Override
        public boolean remove(long key) {
            long index2 = key >> this.bitsPerEntry;
            Entry entry = this.getEntryByIndex(index2);
            if (entry == null) {
                return false;
            }
            Entry entry2 = entry;
            int bitIndex = (int)key & this.mask;
            if (!entry2.getBits$xodus_utils().get(bitIndex)) {
                return false;
            }
            int n = this.size;
            this.size = n + -1;
            Entry copy = new Entry(index2, entry2, this.mask + 1);
            copy.getBits$xodus_utils().clear(bitIndex);
            if (copy.getBits$xodus_utils().isEmpty()) {
                this.mutableSet.exclude((Entry)((Comparable)entry2));
            } else {
                this.mutableSet.add((Entry)((Comparable)copy));
            }
            return true;
        }

        @Override
        public void clear() {
            this.mutableSet.setRoot(null);
            this.size = 0;
        }

        @Override
        public boolean endWrite() {
            if (!this.mutableSet.endWrite()) {
                return false;
            }
            this.baseSet.root.setSize$xodus_utils(this.size);
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Entry;", "Ljetbrains/exodus/core/dataStructures/persistent/LongComparable;", "index", "", "elementsPerEntry", "", "(JI)V", "other", "(JLjetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Entry;I)V", "bits", "Ljava/util/BitSet;", "getBits$xodus_utils", "()Ljava/util/BitSet;", "getIndex$xodus_utils", "()J", "compareTo", "getWeight", "xodus-utils"})
    public static final class Entry
    implements LongComparable<Entry> {
        private final long index;
        @NotNull
        private final BitSet bits;

        public final long getIndex$xodus_utils() {
            return this.index;
        }

        @NotNull
        public final BitSet getBits$xodus_utils() {
            return this.bits;
        }

        public Entry(long index2, int elementsPerEntry) {
            this.index = index2;
            this.bits = new BitSet(elementsPerEntry);
        }

        public Entry(long index2, @NotNull Entry other, int elementsPerEntry) {
            Intrinsics.checkNotNullParameter(other, "other");
            this.index = index2;
            this.bits = new BitSet(elementsPerEntry);
            this.bits.or(other.bits);
        }

        @Override
        public long getWeight() {
            return this.index;
        }

        @Override
        public int compareTo(@NotNull Entry other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return Intrinsics.compare(this.index, other.index);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Root;", "", "map", "Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree;", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Entry;", "size", "", "(Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree;I)V", "clone", "getClone", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Root;", "getMap$xodus_utils", "()Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree;", "getSize$xodus_utils", "()I", "setSize$xodus_utils", "(I)V", "xodus-utils"})
    public static final class Root {
        @NotNull
        private final Persistent23Tree<Entry> map;
        private int size;

        public Root(@NotNull Persistent23Tree<Entry> map, int size) {
            Intrinsics.checkNotNullParameter(map, "map");
            this.map = map;
            this.size = size;
        }

        @NotNull
        public final Persistent23Tree<Entry> getMap$xodus_utils() {
            return this.map;
        }

        public final int getSize$xodus_utils() {
            return this.size;
        }

        public final void setSize$xodus_utils(int n) {
            this.size = n;
        }

        @NotNull
        public final Root getClone() {
            Persistent23Tree<Entry> persistent23Tree = this.map.getClone();
            Intrinsics.checkNotNullExpressionValue(persistent23Tree, "map.clone");
            return new Root(persistent23Tree, this.size);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B'\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\bH\u0002J\t\u0010\u000f\u001a\u00020\bH\u0096\u0002J\u000e\u0010\r\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$ItemIterator;", "Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "iterator", "", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentBitTreeLongSet$Entry;", "bitsPerEntry", "", "isReversed", "", "(Ljava/util/Iterator;IZ)V", "currentEntry", "currentEntryBase", "", "next", "fetchEntry", "hasNext", "()Ljava/lang/Long;", "nextBit", "e", "fromBit", "nextLong", "remove", "", "xodus-utils"})
    private static class ItemIterator
    implements LongIterator {
        @NotNull
        private final Iterator<Entry> iterator;
        private final int bitsPerEntry;
        private final boolean isReversed;
        private Entry currentEntry;
        private long currentEntryBase;
        private int next;

        public ItemIterator(@NotNull Iterator<Entry> iterator2, int bitsPerEntry, boolean isReversed) {
            Intrinsics.checkNotNullParameter(iterator2, "iterator");
            this.iterator = iterator2;
            this.bitsPerEntry = bitsPerEntry;
            this.isReversed = isReversed;
            this.next = -1;
        }

        public /* synthetic */ ItemIterator(Iterator iterator2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(iterator2, n, bl);
        }

        @Override
        @NotNull
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index2 = this.next;
            long result = (long)index2 + this.currentEntryBase;
            Entry entry = this.currentEntry;
            if (entry == null) {
                Intrinsics.throwUninitializedPropertyAccessException("currentEntry");
                entry = null;
            }
            this.next = this.nextBit(entry, this.next + (this.isReversed ? -1 : 1));
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != -1 || this.fetchEntry();
        }

        private final boolean fetchEntry() {
            while (this.iterator.hasNext()) {
                Entry entry = this.iterator.next();
                int nextIndex = ItemIterator.nextBit$default(this, entry, 0, 2, null);
                if (nextIndex == -1) continue;
                this.currentEntry = entry;
                this.currentEntryBase = entry.getIndex$xodus_utils() << this.bitsPerEntry;
                this.next = nextIndex;
                return true;
            }
            return false;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private final int nextBit(Entry e, int fromBit) {
            BitSet bits = e.getBits$xodus_utils();
            return this.isReversed ? bits.previousSetBit(fromBit == Integer.MAX_VALUE ? bits.size() : fromBit) : bits.nextSetBit(fromBit == Integer.MAX_VALUE ? 0 : fromBit);
        }

        static /* synthetic */ int nextBit$default(ItemIterator itemIterator, Entry entry, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBit");
            }
            if ((n2 & 2) != 0) {
                n = Integer.MAX_VALUE;
            }
            return itemIterator.nextBit(entry, n);
        }
    }
}

