/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.core.dataStructures.Stack;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.Flag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPersistentHashSet<K>
implements Iterable<K> {
    static final Object[] EMPTY_TABLE = new Object[0];
    static final RootTableNode EMPTY_ROOT = new RootTableNode(0, EMPTY_TABLE, 0);
    static final int BITS_PER_TABLE = 5;
    static final int BITS_IN_HASH = 32;

    AbstractPersistentHashSet() {
    }

    @NotNull
    abstract RootTableNode<K> getRoot();

    public final boolean contains(K key) {
        return this.getKey(key) != null;
    }

    @Nullable
    public final K getKey(K key) {
        return this.getRoot().getKey(key, key.hashCode(), 0);
    }

    public final boolean isEmpty() {
        return this.getRoot().getMask() == 0;
    }

    public final int size() {
        return this.getRoot().getSize();
    }

    @Override
    public final Iterator<K> iterator() {
        RootTableNode<K> root = this.getRoot();
        return root.getMask() == 0 ? Collections.EMPTY_LIST.iterator() : new Itr<K>(root);
    }

    static class HashCollisionNode<K>
    implements Node<K> {
        private final K[] keys;

        HashCollisionNode(K ... keys2) {
            this.keys = keys2;
        }

        @Override
        @NotNull
        public Node<K> insert(@NotNull K key, int hash, int offset, Flag flag) {
            int keysLength = this.keys.length;
            for (int i = 0; i < keysLength; ++i) {
                if (!this.keys[i].equals(key)) continue;
                Object[] newKeys = (Object[])this.keys.clone();
                newKeys[i] = key;
                return new HashCollisionNode<Object>(newKeys);
            }
            K[] newKeys = Arrays.copyOf(this.keys, keysLength + 1);
            newKeys[keysLength] = key;
            flag.flag();
            return new HashCollisionNode<K>(newKeys);
        }

        @Override
        @Nullable
        public Object remove(@NotNull K key, int hash, int offset) {
            int keysLength = this.keys.length;
            for (int i = 0; i < keysLength; ++i) {
                if (!this.keys[i].equals(key)) continue;
                if (keysLength == 2) {
                    return this.keys[1 - i];
                }
                Object[] newKeys = new Object[keysLength - 1];
                int k = 0;
                for (int j = 0; j < keysLength; ++j) {
                    if (j == i) continue;
                    newKeys[k++] = this.keys[j];
                }
                return new HashCollisionNode<Object>(newKeys);
            }
            return null;
        }

        @Override
        public K getKey(@NotNull K key, int hash, int offset) {
            for (K k : this.keys) {
                if (!k.equals(key)) continue;
                return k;
            }
            return null;
        }

        @Override
        public void checkNode(int offset) {
            int keysLength = this.keys.length;
            if (keysLength < 2) {
                throw new RuntimeException("Unnecessary hash collision node of cardinality " + keysLength);
            }
            for (K key : this.keys) {
                if (key != null) continue;
                throw new RuntimeException("Null in collision list");
            }
        }

        @Override
        public RootTableNode<K> asRoot(int size) {
            throw new UnsupportedOperationException("Unexpected as root!");
        }

        @Override
        public Object get(int index2) {
            return this.keys[index2];
        }

        @Override
        public boolean isOut(int index2) {
            return index2 + 1 > this.keys.length;
        }

        @Override
        public void forEachKey(ObjectProcedure<K> procedure) {
            for (K k : this.keys) {
                procedure.execute(k);
            }
        }
    }

    static class TableNode<K>
    implements Node<K> {
        private final int mask;
        private final Object[] table;

        TableNode(int mask, Object[] table) {
            this.mask = mask;
            this.table = table;
        }

        private TableNode(@NotNull K key1, int hash1, @NotNull K key2, int hash2, int offset) {
            int subhash2 = TableNode.getSubhash(hash2, offset);
            int subhash1 = TableNode.getSubhash(hash1, offset);
            if (subhash1 == subhash2) {
                this.mask = 1 << subhash1;
                this.table = new Object[]{TableNode.createNode(key1, hash1, key2, hash2, offset + 5)};
            } else {
                this.mask = (1 << subhash2) + (1 << subhash1);
                this.table = subhash1 < subhash2 ? new Object[]{key1, key2} : new Object[]{key2, key1};
            }
        }

        public int getMask() {
            return this.mask;
        }

        @Override
        @NotNull
        public Node<K> insert(@NotNull K key, int hash, int offset, Flag flag) {
            Object result;
            int subhash = TableNode.getSubhash(hash, offset);
            if ((this.mask & 1 << subhash) == 0) {
                flag.flag();
                return this.cloneAndAdd(key, subhash);
            }
            int index2 = this.getPosition(subhash);
            Object target = this.table[index2];
            if (target instanceof Node) {
                result = ((Node)target).insert(key, hash, offset + 5, flag);
            } else if (target.equals(key)) {
                result = key;
            } else {
                flag.flag();
                result = TableNode.createNode(target, key, hash, offset + 5);
            }
            return (Node)this.cloneAndReplace(result, index2, offset);
        }

        @Override
        @Nullable
        public Object remove(@NotNull K key, int hash, int offset) {
            int subhash = TableNode.getSubhash(hash, offset);
            if ((this.mask & 1 << subhash) == 0) {
                return null;
            }
            int index2 = this.getPosition(subhash);
            Object target = this.table[index2];
            if (target instanceof Node) {
                Object removed = ((Node)target).remove(key, hash, offset + 5);
                if (removed == null) {
                    return null;
                }
                return this.cloneAndReplace(removed, index2, offset);
            }
            return target.equals(key) ? this.cloneAndRemove(subhash, index2, offset) : null;
        }

        @Override
        public K getKey(@NotNull K key, int hash, int offset) {
            int subhash = TableNode.getSubhash(hash, offset);
            if ((this.mask & 1 << subhash) == 0) {
                return null;
            }
            int index2 = this.getPosition(subhash);
            Object target = this.table[index2];
            if (target instanceof Node) {
                return ((Node)target).getKey(key, hash, offset + 5);
            }
            return (K)(target.equals(key) ? target : null);
        }

        @Override
        public void forEachKey(ObjectProcedure<K> procedure) {
            for (Object target : this.table) {
                if (target instanceof Node) {
                    ((Node)target).forEachKey(procedure);
                    continue;
                }
                procedure.execute(target);
            }
        }

        private TableNode<K> cloneAndAdd(K key, int subhash) {
            int index2 = this.getPosition(subhash);
            int tableLength = this.table.length;
            Object[] newTable = new Object[tableLength + 1];
            System.arraycopy(this.table, 0, newTable, 0, index2);
            System.arraycopy(this.table, index2, newTable, index2 + 1, tableLength - index2);
            newTable[index2] = key;
            return new TableNode<K>(this.mask + (1 << subhash), newTable);
        }

        @NotNull
        private Object cloneAndReplace(@NotNull Object newChild, int index2, int offset) {
            int tableLength = this.table.length;
            if (offset != 0 && tableLength == 1 && !(newChild instanceof Node)) {
                return newChild;
            }
            Object[] newTable = Arrays.copyOf(this.table, tableLength);
            newTable[index2] = newChild;
            return new TableNode<K>(this.mask, newTable);
        }

        private Object cloneAndRemove(int subhash, int index2, int offset) {
            int size = this.getPosition(32);
            if (size == 1) {
                return new TableNode<K>(0, EMPTY_TABLE);
            }
            if (size == 2) {
                if (offset == 0 || this.table[1 - index2] instanceof Node) {
                    return new TableNode<K>(this.mask - (1 << subhash), new Object[]{this.table[1 - index2]});
                }
                return this.table[1 - index2];
            }
            Object[] newTable = new Object[this.table.length - 1];
            System.arraycopy(this.table, 0, newTable, 0, index2);
            System.arraycopy(this.table, index2 + 1, newTable, index2, newTable.length - index2);
            return new TableNode<K>(this.mask - (1 << subhash), newTable);
        }

        private int getPosition(int subhash) {
            int m = this.mask & (subhash == 32 ? -1 : (1 << subhash) - 1);
            m -= m >>> 1 & 0x55555555;
            m = (m & 0x33333333) + (m >>> 2 & 0x33333333);
            m = m + (m >>> 4) & 0xF0F0F0F;
            m += m >>> 8;
            return m + (m >>> 16) & 0xFF;
        }

        private static <K> Node<K> createNode(K notHashedKey, K hashedKey, int hash, int offset) {
            return TableNode.createNode(notHashedKey, notHashedKey.hashCode(), hashedKey, hash, offset);
        }

        private static <K> Node<K> createNode(K key1, int hash1, K key2, int hash2, int offset) {
            Object[] table;
            int subhash1 = TableNode.getSubhash(hash1, offset);
            int subhash2 = TableNode.getSubhash(hash2, offset);
            if (subhash2 == subhash1) {
                table = new Object[]{offset + 5 >= 32 ? new HashCollisionNode<Object>(key1, key2) : new TableNode<K>(key1, hash1, key2, hash2, offset + 5)};
            } else {
                Object[] objectArray;
                if (subhash2 < subhash1) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = key2;
                    objectArray = objectArray2;
                    objectArray2[1] = key1;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = key1;
                    objectArray = objectArray3;
                    objectArray3[1] = key2;
                }
                table = objectArray;
            }
            return new TableNode<K>(1 << subhash2 | 1 << subhash1, table);
        }

        private static int getSubhash(int hash, int offset) {
            return hash >>> offset & 0x1F;
        }

        @Override
        public void checkNode(int offset) {
            int tableLength;
            if (offset > 0 && ((tableLength = this.table.length) == 0 || tableLength == 1 && !(this.table[0] instanceof Node))) {
                throw new RuntimeException("unnecessary use of table node");
            }
            int m = this.mask;
            for (Object o : this.table) {
                if (m == 0) {
                    throw new RuntimeException("Inconsistent mask and table");
                }
                m &= m - 1;
                if (o == null) {
                    throw new RuntimeException("Null in table");
                }
                if (!(o instanceof Node)) continue;
                ((Node)o).checkNode(offset + 5);
            }
            if (m != 0) {
                throw new RuntimeException("Inconsistent mask and table");
            }
        }

        @Override
        public RootTableNode<K> asRoot(int size) {
            return new RootTableNode(this.mask, this.table, size);
        }

        @Override
        public Object get(int index2) {
            return this.table[index2];
        }

        @Override
        public boolean isOut(int index2) {
            return index2 + 1 > this.table.length;
        }
    }

    static class RootTableNode<K>
    extends TableNode<K> {
        private final int size;

        RootTableNode(int mask, Object[] table, int size) {
            super(mask, table);
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }

    static class TreePos<K> {
        private final Node<K> node;
        private int index;

        TreePos(Node<K> node) {
            this.node = node;
            this.index = 0;
        }
    }

    static interface Node<K> {
        @NotNull
        public Node<K> insert(@NotNull K var1, int var2, int var3, Flag var4);

        @Nullable
        public Object remove(@NotNull K var1, int var2, int var3);

        @Nullable
        public K getKey(@NotNull K var1, int var2, int var3);

        public void checkNode(int var1);

        public RootTableNode<K> asRoot(int var1);

        public Object get(int var1);

        public boolean isOut(int var1);

        public void forEachKey(ObjectProcedure<K> var1);
    }

    static class Itr<K>
    implements Iterator<K> {
        private final Node<K> startingRoot;
        private Stack<TreePos<K>> stack;
        private boolean hasNext;
        private boolean hasNextValid;

        public Itr(Node<K> startingRoot) {
            this.startingRoot = startingRoot;
        }

        @Override
        public boolean hasNext() {
            TreePos<K> treePos;
            if (this.hasNextValid) {
                return this.hasNext;
            }
            this.hasNextValid = true;
            if (this.stack == null) {
                this.stack = new Stack();
                treePos = new TreePos<K>(this.startingRoot);
                ((TreePos)treePos).index = -1;
                this.stack.push(treePos);
            }
            treePos = this.stack.peek();
            ((TreePos)treePos).index++;
            while (((TreePos)treePos).node.isOut(((TreePos)treePos).index)) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    this.hasNext = false;
                    return false;
                }
                treePos = this.stack.peek();
                ((TreePos)treePos).index++;
            }
            while (true) {
                Object o;
                if (!((o = ((TreePos)treePos).node.get(((TreePos)treePos).index)) instanceof Node)) {
                    this.hasNext = true;
                    return true;
                }
                treePos = new TreePos((Node)o);
                this.stack.push(treePos);
            }
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNextValid = false;
            TreePos<K> treePos = this.stack.peek();
            return (K)((TreePos)treePos).node.get(((TreePos)treePos).index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

