/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.AbstractSet;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;

public class LongLinkedHashSet
extends AbstractSet<Long>
implements LongSet {
    private Entry[] table;
    private Entry top;
    private Entry back;
    private int capacity;
    private int size;
    private final float loadFactor;
    private int mask;

    public LongLinkedHashSet() {
        this(0);
    }

    public LongLinkedHashSet(int capacity) {
        this(capacity, 1.0f);
    }

    public LongLinkedHashSet(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long[] toLongArray() {
        if (this.size == 0) {
            return EMPTY_ARRAY;
        }
        long[] result = new long[this.size];
        int i = 0;
        LongIterator itr = this.iterator();
        while (itr.hasNext()) {
            result[i++] = itr.nextLong();
        }
        return result;
    }

    @Override
    public boolean contains(long key) {
        Entry[] table = this.table;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index2];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.hashNext;
        }
        return false;
    }

    @Override
    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    @Override
    public boolean add(long key) {
        Entry[] table = this.table;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index2];
        while (e != null) {
            if (e.key == key) {
                return false;
            }
            e = e.hashNext;
        }
        e = new Entry(key);
        e.hashNext = table[index2];
        table[index2] = e;
        Entry top = this.top;
        e.next = top;
        if (top != null) {
            top.previous = e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this.size;
        if (this.size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return true;
    }

    @Override
    public boolean add(Long key) {
        return this.add((long)key);
    }

    @Override
    public boolean remove(long key) {
        Entry[] table = this.table;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        Entry e = table[index2];
        if (e == null) {
            return false;
        }
        if (e.key == key) {
            table[index2] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return false;
            } while (e.key != key);
            last.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this.size;
        return true;
    }

    @Override
    public boolean remove(Object key) {
        return this.remove((Long)key);
    }

    @Override
    @NotNull
    public LongIterator iterator() {
        return new LinkedHashIterator();
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.back = null;
        this.top = null;
        this.capacity = capacity;
        this.size = 0;
    }

    private void unlink(Entry e) {
        Entry prev = e.previous;
        Entry next = e.next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            this.allocateTable(length);
            Entry[] table = this.table;
            int mask = this.mask;
            Entry e = this.back;
            while (e != null) {
                int index2 = HashUtil.indexFor(e.key, length, mask);
                e.hashNext = table[index2];
                table[index2] = e;
                e = e.previous;
            }
        }
    }

    private class LinkedHashIterator
    implements LongIterator {
        private Entry e;
        private Entry last;

        private LinkedHashIterator() {
            this.e = LongLinkedHashSet.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LongLinkedHashSet.this.remove(this.last.key);
            this.last = null;
        }

        @Override
        public Long next() {
            return this.nextLong();
        }

        @Override
        public long nextLong() {
            Entry result = this.last = this.e;
            this.e = result.previous;
            return result.key;
        }
    }

    private static class Entry {
        private final long key;
        private Entry next;
        private Entry previous;
        private Entry hashNext;

        private Entry(long key) {
            this.key = key;
        }
    }
}

