/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.util.Iterator;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.AbstractHashMap;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010'\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002!\"B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u0018H\u0014J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00120\u001aR\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u001f\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0017\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006#"}, d2={"Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "V", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap;", "", "capacity", "", "loadFactor", "", "(IF)V", "mask", "table", "", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$Entry;", "[Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$Entry;", "allocateTable", "", "length", "containsKey", "", "key", "get", "(J)Ljava/lang/Object;", "getEntry", "", "", "hashIterator", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap$HashMapIterator;", "init", "put", "value", "(JLjava/lang/Object;)Ljava/lang/Object;", "rehash", "remove", "Entry", "HashIterator", "xodus-utils"})
public final class LongHashMap<V>
extends AbstractHashMap<Long, V> {
    private final float loadFactor;
    @NotNull
    private Entry<V>[] table;
    private int capacity;
    private int mask;

    @JvmOverloads
    public LongHashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        boolean $i$f$emptyArray = false;
        this.table = new Entry[0];
        this.init(capacity);
    }

    public /* synthetic */ LongHashMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 1.0f;
        }
        this(n, f);
    }

    @Nullable
    public V get(long key) {
        Entry<V> entry = this.getEntry(key);
        return (V)(entry == null ? null : entry.getValue());
    }

    @Override
    @Nullable
    public V put(long key, V value) {
        Entry<V>[] table = this.table;
        boolean bl = false;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        for (Entry<V> e = table[index2]; e != null; e = e.getHashNext()) {
            if (e.getKey() != key) continue;
            return e.setValue(value);
        }
        Entry<V> newEntry = new Entry<V>(key, value);
        boolean bl2 = false;
        newEntry.setHashNext(table[index2]);
        table[index2] = newEntry;
        ++this._size;
        if (this._size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return null;
    }

    public boolean containsKey(long key) {
        return this.getEntry(key) != null;
    }

    @Nullable
    public V remove(long key) {
        Entry<V>[] table = this.table;
        boolean bl = false;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        Entry<V> entry = table[index2];
        if (entry == null) {
            return null;
        }
        Entry<V> e = entry;
        Entry<V> last = null;
        while (key != e.getKey()) {
            last = e;
            if (e.getHashNext() != null) continue;
            return null;
        }
        --this._size;
        if (last == null) {
            table[index2] = e.getHashNext();
        } else {
            last.setHashNext(e.getHashNext());
        }
        return e.getValue();
    }

    @Override
    @Nullable
    protected Map.Entry<Long, V> getEntry(@NotNull Object key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return TypeIntrinsics.asMutableMapEntry(this.getEntry((Long)key));
    }

    @Override
    protected void init(int capacity) {
        int c = Integer.max(capacity, 4);
        boolean bl = false;
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)c / this.loadFactor)));
        this.capacity = c;
        this._size = 0;
    }

    @Override
    @NotNull
    protected AbstractHashMap.HashMapIterator hashIterator() {
        return new HashIterator();
    }

    private final Entry<V> getEntry(long key) {
        Entry<V>[] table = this.table;
        int index2 = HashUtil.indexFor(key, table.length, this.mask);
        for (Entry<V> e = table[index2]; e != null; e = e.getHashNext()) {
            if (e.getKey() != key) continue;
            return e;
        }
        return null;
    }

    private final void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private final void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            Iterator<Map.Entry<Long, V>> entries = this.entrySet().iterator();
            this.allocateTable(length);
            Entry<V>[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                int index2 = HashUtil.indexFor(e.getKey(), length, mask);
                e.setHashNext(table[index2]);
                table[index2] = e;
            }
        }
    }

    @JvmOverloads
    public LongHashMap(int capacity) {
        this(capacity, 0.0f, 2, null);
    }

    @JvmOverloads
    public LongHashMap() {
        this(0, 0.0f, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010'\n\u0002\u0010\t\n\u0002\b\u0012\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0014R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0005\u001a\u00028\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$Entry;", "V", "", "", "key", "value", "(JLjava/lang/Object;)V", "hashNext", "getHashNext", "()Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$Entry;", "setHashNext", "(Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$Entry;)V", "getKey", "()Ljava/lang/Long;", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "newValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "xodus-utils"})
    private static final class Entry<V>
    implements Map.Entry<Long, V>,
    KMutableMap.Entry {
        private final long key;
        private V value;
        @Nullable
        private Entry<V> hashNext;

        public Entry(long key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public Long getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public void setValue(V v) {
            this.value = v;
        }

        @Nullable
        public final Entry<V> getHashNext() {
            return this.hashNext;
        }

        public final void setHashNext(@Nullable Entry<V> entry) {
            this.hashNext = entry;
        }

        @Override
        public V setValue(V newValue) {
            V v;
            V it = v = this.getValue();
            boolean bl = false;
            this.setValue(newValue);
            return v;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00120\u0001R\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0014J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$HashIterator;", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap$HashMapIterator;", "Ljetbrains/exodus/core/dataStructures/hash/AbstractHashMap;", "", "(Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;)V", "e", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$Entry;", "index", "", "last", "table", "", "[Ljetbrains/exodus/core/dataStructures/hash/LongHashMap$Entry;", "hasNext", "", "initNextEntry", "", "nextEntry", "remove", "xodus-utils"})
    private final class HashIterator
    extends AbstractHashMap.HashMapIterator {
        @NotNull
        private final Entry<V>[] table;
        private int index;
        @Nullable
        private Entry<V> e;
        @Nullable
        private Entry<V> last;

        public HashIterator() {
            Intrinsics.checkNotNullParameter(LongHashMap.this, "this$0");
            this.table = LongHashMap.this.table;
            this.initNextEntry();
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            Entry entry = this.last;
            if (entry == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            LongHashMap.this.remove(entry.getKey());
            this.last = null;
        }

        @NotNull
        protected Entry<V> nextEntry() {
            Entry entry;
            Entry entry2 = this.e;
            if (entry2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Entry it = entry = entry2;
            boolean bl = false;
            this.last = it;
            this.initNextEntry();
            return entry;
        }

        private final void initNextEntry() {
            Entry result = this.e;
            if (result != null) {
                result = result.getHashNext();
            }
            Entry<V>[] table = this.table;
            while (result == null && this.index < table.length) {
                int n = this.index;
                this.index = n + 1;
                result = table[n];
            }
            this.e = result;
        }
    }
}

