/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.hash;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.AbstractHashMap;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.Nullable;

public class HashMap<K, V>
extends AbstractHashMap<K, V>
implements Serializable {
    protected static final int DEFAULT_TABLE_SIZE = 3;
    protected static final int DEFAULT_MASK = 3;
    private Entry<K, V>[] table;
    private int capacity;
    private final float loadFactor;
    private int mask;
    private Entry<K, V> nullEntry;

    public HashMap() {
        this(0, 0, 1.0f, 3, 3);
    }

    public HashMap(int capacity) {
        this(capacity, 1.0f);
    }

    public HashMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.init(capacity);
    }

    public HashMap(HashMap<K, V> copy) {
        this(copy.capacity, copy.size(), copy.loadFactor, copy.table.length, copy.mask);
        Entry<K, V>[] source = copy.table;
        for (int i = 0; i < source.length; ++i) {
            this.table[i] = super.copyEntry(source[i]);
        }
    }

    protected HashMap(int capacity, int size, float loadFactor, int tableSize, int mask) {
        this.loadFactor = loadFactor;
        if (capacity < 4) {
            capacity = 4;
        }
        this.table = new Entry[tableSize];
        this.mask = mask;
        this.capacity = capacity;
        this._size = size;
    }

    @Override
    public V put(@Nullable K key, V value) {
        if (key == null) {
            if (this.nullEntry == null) {
                ++this._size;
                this.nullEntry = new Entry((Object)null, (Object)value);
                return null;
            }
            return this.nullEntry.setValue(value);
        }
        Entry<K, V>[] table = this.table;
        int hash = key.hashCode();
        int index2 = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index2];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                return e.setValue(value);
            }
            e = e.hashNext;
        }
        e = new Entry((Object)key, (Object)value);
        e.hashNext = (Entry)table[index2];
        table[index2] = e;
        ++this._size;
        if (this._size > this.capacity) {
            this.rehash(HashUtil.nextCapacity(this.capacity));
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            if (this.nullEntry != null) {
                --this._size;
                Object hadNullValue = ((Entry)this.nullEntry).value;
                this.nullEntry = null;
                return (V)hadNullValue;
            }
            return null;
        }
        Entry<K, V>[] table = this.table;
        int hash = key.hashCode();
        int index2 = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index2];
        if (e == null) {
            return null;
        }
        Object entryKey = e.key;
        if (entryKey == key || entryKey.equals(key)) {
            table[index2] = e.hashNext;
        } else {
            Entry last;
            do {
                last = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while ((entryKey = e.key) != key && !entryKey.equals(key));
            last.hashNext = e.hashNext;
        }
        --this._size;
        return (V)e.value;
    }

    @Override
    protected Map.Entry<K, V> getEntry(Object key) {
        if (key == null) {
            return this.nullEntry;
        }
        Entry<K, V>[] table = this.table;
        int hash = key.hashCode();
        int index2 = HashUtil.indexFor(hash, table.length, this.mask);
        Entry e = table[index2];
        while (e != null) {
            Object entryKey = e.key;
            if (entryKey == key || entryKey.equals(key)) {
                return e;
            }
            e = e.hashNext;
        }
        return null;
    }

    @Override
    protected void init(int capacity) {
        if (capacity < 4) {
            capacity = 4;
        }
        this.allocateTable(HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor)));
        this.capacity = capacity;
        this._size = 0;
    }

    @Override
    protected AbstractHashMap.HashMapIterator hashIterator() {
        return new HashIterator();
    }

    private void allocateTable(int length) {
        this.table = new Entry[length];
        this.mask = (1 << MathUtil.integerLogarithm(this.table.length)) - 1;
    }

    private void rehash(int capacity) {
        int length = HashUtil.getCeilingPrime((int)((float)capacity / this.loadFactor));
        this.capacity = capacity;
        if (length != this.table.length) {
            Iterator entries = this.entrySet().iterator();
            this.allocateTable(length);
            Entry<K, V>[] table = this.table;
            int mask = this.mask;
            while (entries.hasNext()) {
                Entry e = (Entry)entries.next();
                if (e.key == null) continue;
                int index2 = HashUtil.indexFor(e.key.hashCode(), length, mask);
                e.hashNext = (Entry)table[index2];
                table[index2] = e;
            }
        }
    }

    @Nullable
    private Entry<K, V> copyEntry(@Nullable Entry<K, V> sourceEntry) {
        return sourceEntry == null ? null : new Entry<Object, Object>(((Entry)sourceEntry).key, ((Entry)sourceEntry).value, this.copyEntry(((Entry)sourceEntry).hashNext));
    }

    private final class HashIterator
    extends AbstractHashMap.HashMapIterator {
        private final Entry<K, V>[] table;
        private int index;
        private Entry<K, V> e;
        private Entry<K, V> last;

        HashIterator() {
            this.table = HashMap.this.table;
            this.index = -1;
            this.e = null;
            this.initNextEntry();
        }

        @Override
        protected boolean hasNext() {
            return this.e != null;
        }

        @Override
        protected void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<K, V> nextEntry() {
            this.last = this.e;
            Entry result = this.last;
            this.initNextEntry();
            return result;
        }

        private void initNextEntry() {
            Entry result = this.e;
            if (result != null) {
                result = result.hashNext;
            }
            if (this.index < 0) {
                result = HashMap.this.nullEntry;
                this.index = 0;
            }
            Entry<K, V>[] table = this.table;
            while (result == null && this.index < table.length) {
                result = table[this.index++];
            }
            this.e = result;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private final K key;
        private V value;
        private Entry<K, V> hashNext;

        private Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public Entry(K key, V value, Entry<K, V> hashNext) {
            this.key = key;
            this.value = value;
            this.hashNext = hashNext;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }
}

