/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.io.Closeable;
import jetbrains.exodus.core.dataStructures.CacheHitRateable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0018\b&\u0018\u0000 #*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001#B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0012\u001a\u00020\fH&J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u0014\u001a\u00020\u0004H&J\u0018\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\b\u0010\u001a\u001a\u00020\fH&J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\u001d\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0003\u001a\u00020\u0004J\u0017\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\"\u001a\u00020\fH&R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ljetbrains/exodus/core/dataStructures/IntObjectCacheBase;", "V", "Ljetbrains/exodus/core/dataStructures/CacheHitRateable;", "size", "", "(I)V", "criticalSection", "Ljava/io/Closeable;", "isEmpty", "", "()Z", "adjustHitRate", "", "cacheObject", "key", "x", "(ILjava/lang/Object;)Ljava/lang/Object;", "cacheObjectLocked", "clear", "containsKey", "count", "get", "(I)Ljava/lang/Object;", "getObject", "getObjectLocked", "isCached", "lock", "newCriticalSection", "put", "value", "remove", "removeLocked", "tryKey", "tryKeyLocked", "unlock", "Companion", "xodus-utils"})
public abstract class IntObjectCacheBase<V>
extends CacheHitRateable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final Closeable criticalSection;
    public static final int DEFAULT_SIZE = 8192;
    public static final int MIN_SIZE = 4;

    protected IntObjectCacheBase(int size) {
        this.size = Math.max(4, size);
        this.criticalSection = new Closeable(this){
            final /* synthetic */ IntObjectCacheBase<V> this$0;
            {
                this.this$0 = $receiver;
            }

            public void close() {
                this.this$0.unlock();
            }
        };
    }

    public final boolean isEmpty() {
        return this.count() == 0;
    }

    public final boolean containsKey(int key) {
        return this.isCached(key);
    }

    @Nullable
    public final V get(int key) {
        return this.tryKey(key);
    }

    @Nullable
    public final V put(int key, V value) {
        V oldValue = this.getObject(key);
        if (oldValue != null) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V tryKeyLocked(int key) {
        V v;
        Closeable closeable = this.newCriticalSection();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            v = this.tryKey(key);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V getObjectLocked(int key) {
        V v;
        Closeable closeable = this.newCriticalSection();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            v = this.getObject(key);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V cacheObjectLocked(int key, V x) {
        V v;
        Closeable closeable = this.newCriticalSection();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            v = this.getObject(key) == null ? (V)this.cacheObject(key, x) : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V removeLocked(int key) {
        V v;
        Closeable closeable = this.newCriticalSection();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            v = this.remove(key);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return v;
    }

    public final boolean isCached(int key) {
        return this.getObjectLocked(key) != null;
    }

    public final int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustHitRate() {
        Closeable closeable = this.newCriticalSection();
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            super.adjustHitRate();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public abstract void clear();

    public abstract void lock();

    public abstract void unlock();

    @Nullable
    public abstract V tryKey(int var1);

    @Nullable
    public abstract V getObject(int var1);

    @Nullable
    public abstract V cacheObject(int var1, V var2);

    @Nullable
    public abstract V remove(int var1);

    public abstract int count();

    private final Closeable newCriticalSection() {
        this.lock();
        return this.criticalSection;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/exodus/core/dataStructures/IntObjectCacheBase$Companion;", "", "()V", "DEFAULT_SIZE", "", "MIN_SIZE", "xodus-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

