/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.ConfigSettingChangeListener;
import jetbrains.exodus.ConfigurationStrategy;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.util.StringHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractConfig {
    @NonNls
    private static final String UNSUPPORTED_TYPE_ERROR_MSG = "Unsupported value type";
    @NonNls
    private static final ThreadLocal<Boolean> listenersSuppressed = ThreadLocal.withInitial(() -> false);
    @NotNull
    private final Map<String, Object> settings = new StringHashMap<Object>();
    @NotNull
    private final Set<ConfigSettingChangeListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean isMutable = true;

    protected AbstractConfig(@NotNull Pair<String, Object>[] props, @NotNull ConfigurationStrategy strategy) {
        for (Pair<String, Object> prop : props) {
            Object value;
            String propName = prop.getFirst();
            Object defaultValue = prop.getSecond();
            if (defaultValue == null) {
                value = AbstractConfig.getString(strategy, propName, null);
            } else {
                Class<?> clazz = defaultValue.getClass();
                if (clazz == Boolean.class) {
                    value = AbstractConfig.getBoolean(strategy, propName, (Boolean)defaultValue);
                } else if (clazz == Integer.class) {
                    value = AbstractConfig.getInteger(strategy, propName, (Integer)defaultValue);
                } else if (clazz == Long.class) {
                    value = AbstractConfig.getLong(strategy, propName, (Long)defaultValue);
                } else if (clazz == String.class) {
                    value = AbstractConfig.getString(strategy, propName, (String)defaultValue);
                } else {
                    throw new ExodusException(UNSUPPORTED_TYPE_ERROR_MSG);
                }
            }
            if (value == null) continue;
            this.setSetting(propName, value);
        }
    }

    public Object getSetting(@NotNull String key) {
        return this.settings.get(key);
    }

    public AbstractConfig setSetting(@NotNull String key, @NotNull Object value) {
        this.checkIsMutable();
        if (!value.equals(this.settings.get(key))) {
            HashMap<ConfigSettingChangeListener, HashMap<String, Object>> listenerToContext = null;
            boolean listenersSuppressed = AbstractConfig.listenersSuppressed.get();
            if (!listenersSuppressed) {
                listenerToContext = new HashMap<ConfigSettingChangeListener, HashMap<String, Object>>();
                for (ConfigSettingChangeListener listener : this.listeners) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    listener.beforeSettingChanged(key, value, context);
                    listenerToContext.put(listener, context);
                }
            }
            this.settings.put(key, value);
            if (!listenersSuppressed) {
                for (ConfigSettingChangeListener listener : this.listeners) {
                    listener.afterSettingChanged(key, value, (Map)listenerToContext.get(listener));
                }
            }
        }
        return this;
    }

    public AbstractConfig removeSetting(@NotNull String key) {
        this.checkIsMutable();
        this.settings.remove(key);
        return this;
    }

    public Map<String, Object> getSettings() {
        return Collections.unmodifiableMap(this.settings);
    }

    public void addChangedSettingsListener(@NotNull ConfigSettingChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangedSettingsListener(@NotNull ConfigSettingChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setSettings(@NotNull Map<String, String> settings) throws InvalidSettingException {
        this.checkIsMutable();
        StringBuilder errorMessage = new StringBuilder();
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String key = entry.getKey();
            Object oldValue = this.getSetting(key);
            if (oldValue == null) {
                AbstractConfig.appendLineFeed(errorMessage);
                errorMessage.append("Unknown setting key: ");
                errorMessage.append(key);
                continue;
            }
            String value = entry.getValue();
            Class<?> clazz = oldValue.getClass();
            try {
                Object newValue;
                if (clazz == Boolean.class) {
                    newValue = Boolean.valueOf(value);
                } else if (clazz == Integer.class) {
                    newValue = Integer.decode(value);
                } else if (clazz == Long.class) {
                    newValue = Long.decode(value);
                } else if (clazz == String.class) {
                    newValue = value;
                } else {
                    AbstractConfig.appendLineFeed(errorMessage);
                    errorMessage.append(UNSUPPORTED_TYPE_ERROR_MSG);
                    errorMessage.append(": ");
                    errorMessage.append(clazz);
                    continue;
                }
                this.setSetting(key, newValue);
            }
            catch (NumberFormatException ignore) {
                AbstractConfig.appendLineFeed(errorMessage);
                errorMessage.append(UNSUPPORTED_TYPE_ERROR_MSG);
                errorMessage.append(": ");
                errorMessage.append(clazz);
            }
        }
        if (errorMessage.length() > 0) {
            throw new InvalidSettingException(errorMessage.toString());
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public AbstractConfig setMutable(boolean isMutable) {
        this.isMutable = isMutable;
        return this;
    }

    private void checkIsMutable() {
        if (!this.isMutable) {
            throw new ExodusException("Config is immutable");
        }
    }

    public static void suppressConfigChangeListenersForThread() {
        listenersSuppressed.set(true);
    }

    public static void resumeConfigChangeListenersForThread() {
        listenersSuppressed.set(false);
    }

    private static boolean getBoolean(@NotNull ConfigurationStrategy strategy, @NotNull String propName, boolean defaultValue) {
        String value = strategy.getProperty(propName);
        return value == null ? defaultValue : new Boolean("true".equalsIgnoreCase(value));
    }

    private static Integer getInteger(@NotNull ConfigurationStrategy strategy, @NotNull String propName, Integer defaultValue) {
        String v = strategy.getProperty(propName);
        if (v != null) {
            try {
                return new Integer(Integer.decode(v));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static Long getLong(@NotNull ConfigurationStrategy strategy, @NotNull String propName, Long defaultValue) {
        String v = strategy.getProperty(propName);
        if (v != null) {
            try {
                return new Long(Long.decode(v));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static String getString(@NotNull ConfigurationStrategy strategy, @NotNull String propName, String defaultValue) {
        String v = strategy.getProperty(propName);
        return v == null ? defaultValue : new String(v);
    }

    private static void appendLineFeed(@NotNull StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append('\n');
        }
    }
}

