/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.smi.OctetString;

public abstract class AgentXContextPDU
extends AgentXPDU {
    protected OctetString context;

    protected AgentXContextPDU(byte type, OctetString context) {
        super(type);
        this.context = context;
    }

    protected AgentXContextPDU(AgentXMessageHeader header) {
        super(header);
    }

    protected AgentXContextPDU(byte type, byte flags, int sessionID, int transactionID, int packetID) {
        super(type, flags, sessionID, transactionID, packetID);
    }

    protected abstract void decodeAfterContext(ByteBuffer var1, int var2) throws IOException;

    protected abstract void encodeAfterContext(ByteBuffer var1);

    protected abstract int getAfterContextLength();

    @Override
    public final void decodePayload(ByteBuffer buf, int length) throws IOException {
        this.context = this.isFlagSet(8) ? AgentXProtocol.decodeOctetString(buf) : new OctetString();
        this.decodeAfterContext(buf, length);
    }

    @Override
    public final void encodePayload(ByteBuffer buf) {
        if (this.isFlagSet(8)) {
            AgentXProtocol.encodeOctetString(buf, this.context);
        }
        this.encodeAfterContext(buf);
    }

    @Override
    public final int getPayloadLength() {
        int length = 0;
        if (this.context != null && this.context.length() > 0 && AgentXProtocol.isNonDefaultContextsEnabled()) {
            length = AgentXProtocol.getOctetStringLength(this.context.length());
        }
        return length += this.getAfterContextLength();
    }

    public OctetString getContext() {
        return this.context;
    }

    public void setContext(OctetString context) {
        this.context = context;
    }

    @Override
    protected String toStringExtMembers() {
        return super.toStringExtMembers() + ",context=" + this.context;
    }

    @Override
    protected void beforeEncode() {
        if (this.context != null && this.context.length() > 0 && AgentXProtocol.isNonDefaultContextsEnabled()) {
            this.addFlag((byte)8);
        }
    }
}

