/*_############################################################################
  _## 
  _##  SNMP4J-Agent 3 - SnapshotAgentTest.java  
  _## 
  _##  Copyright (C) 2005-2025  Frank Fock (SNMP4J.org)
  _##  
  _##  Licensed under the Apache License, Version 2.0 (the "License");
  _##  you may not use this file except in compliance with the License.
  _##  You may obtain a copy of the License at
  _##  
  _##      http://www.apache.org/licenses/LICENSE-2.0
  _##  
  _##  Unless required by applicable law or agreed to in writing, software
  _##  distributed under the License is distributed on an "AS IS" BASIS,
  _##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  _##  See the License for the specific language governing permissions and
  _##  limitations under the License.
  _##  
  _##########################################################################*/
package org.snmp4j.agent.test;

import junit.framework.TestCase;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;

public class SnapshotAgentTest extends TestCase {

    public void testGetSubtreeRoots() {
        List<VariableBinding> vbs = List.of(new VariableBinding[] {
                new VariableBinding(new OID("1.0.8802.1.1.1.1.1.2.1.2"), new OctetString("")),
                new VariableBinding(new OID("1.3.6.1.2.1.1.1"), new OctetString("sysDescr")),
                new VariableBinding(new OID("1.0.8802.1.1.1.1.1.2.1.2.1"), new OctetString(".1")),
                new VariableBinding(new OID("1.3.6.1.2.1.1.2"), new TimeTicks())
        });
        SortedMap<OID,OID> subreeRoots = SnapshotAgent.getSubtreeRoots(vbs);
        assertEquals(new OID("1.0.8802.1.1.1.1.1.2.1"), subreeRoots.firstKey());
        assertEquals(new OID("1.3.6.1.2.1.1"), subreeRoots.lastKey());
    }
}