/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.ManagedObject;

public class MOServerLookupEvent
extends EventObject {
    private static final long serialVersionUID = -6148932595537688122L;
    private ManagedObject<?> lookupResult;
    private final MOQuery query;
    private final IntendedUse intendedUse;
    private List<MOServerLookupListener> completionListeners;

    public MOServerLookupEvent(Object source, ManagedObject<?> lookupResult, MOQuery query, IntendedUse intendedUse) {
        super(source);
        this.lookupResult = lookupResult;
        this.query = query;
        this.intendedUse = intendedUse;
    }

    public MOServerLookupEvent(Object source, ManagedObject<?> lookupResult, MOQuery query, IntendedUse intendedUse, boolean withCompletionCallback) {
        this(source, lookupResult, query, intendedUse);
        if (withCompletionCallback) {
            this.completionListeners = new ArrayList<MOServerLookupListener>(2);
        }
    }

    public ManagedObject<?> getLookupResult() {
        return this.lookupResult;
    }

    public void setLookupResult(ManagedObject<?> lookupResult) {
        this.lookupResult = lookupResult;
    }

    public MOQuery getQuery() {
        return this.query;
    }

    public IntendedUse getIntendedUse() {
        return this.intendedUse;
    }

    public boolean isCompletionCallbackAvailable() {
        return this.completionListeners != null;
    }

    public synchronized boolean addCompletionListener(MOServerLookupListener lookupCompletionListener) {
        if (this.completionListeners == null) {
            return false;
        }
        this.completionListeners.add(lookupCompletionListener);
        return true;
    }

    public synchronized boolean removeCompletionListener(MOServerLookupListener lookupCompletionListener) {
        return this.completionListeners != null && this.completionListeners.remove(lookupCompletionListener);
    }

    public synchronized void completedUse(Object result) {
        if (this.completionListeners != null) {
            for (MOServerLookupListener listener : this.completionListeners) {
                listener.completedUse(this, result);
            }
        }
    }

    public static enum IntendedUse {
        undefined,
        register,
        get,
        getNext,
        prepare,
        commit,
        undo,
        cleanUp,
        update,
        unregister;

    }
}

