/*_############################################################################
  _## 
  _##  SNMP4J 2 - AssignableFromIntArray.java  
  _## 
  _##  Copyright (C) 2003-2013  Frank Fock and Jochen Katz (SNMP4J.org)
  _##  
  _##  Licensed under the Apache License, Version 2.0 (the "License");
  _##  you may not use this file except in compliance with the License.
  _##  You may obtain a copy of the License at
  _##  
  _##      http://www.apache.org/licenses/LICENSE-2.0
  _##  
  _##  Unless required by applicable law or agreed to in writing, software
  _##  distributed under the License is distributed on an "AS IS" BASIS,
  _##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  _##  See the License for the specific language governing permissions and
  _##  limitations under the License.
  _##  
  _##########################################################################*/
package org.snmp4j.smi;

/**
 * The <code>AssignableFromIntArray</code> interface describes objects whose
 * value can be set from an int array and converted back to an int array.
 *
 * @author Frank Fock
 * @version 1.10.1
 * @since 1.10.1
 */
public interface AssignableFromIntArray {

  /**
   * Sets the value of this object from the supplied int array.
   * @param value
   *    an int array.
   */
  void setValue(int[] value);

  /**
   * Returns the value of this object as an int array.
   * @return
   *    an int array.
   */
  int[] toIntArray();
}
