/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXTarget.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import java.io.Serial;
import java.io.Serializable;

import org.snmp4j.smi.Address;

/**
 * The {@link AgentXTarget} implements a AgentX target.
 * @param <A>
 *     the address type of the target class.
 */
public class AgentXTarget<A extends Address> implements Serializable {

    @Serial
    private static final long serialVersionUID = -2305474833796499902L;

    private final A address;
    private long timeout = AgentXProtocol.DEFAULT_TIMEOUT_SECONDS * 1000;

    /**
     * Creates a {@link AgentXTarget} from an address.
     * @param address
     *    the address of the target.
     */
    public AgentXTarget(A address) {
        this.address = address;
    }

    /**
     * Creates a {@link AgentXTarget} from an address.
     * @param address
     *    the address of the target.
     * @param timeout
     *    the target timeout (derived from the session) in seconds.
     */
    public AgentXTarget(A address, byte timeout) {
        this(address);
        this.timeout = timeout * 1000;
    }

    /**
     * Creates a {@link AgentXTarget} from an address.
     * @param address
     *    the address of the target.
     * @param timeout
     *    the target timeout (derived from the session) in milliseconds.
     */
    public AgentXTarget(A address, long timeout) {
        this(address);
        this.timeout = timeout;
    }

    /**
     * Gets the target timeout in milliseconds.
     * @return
     *    the target timeout milliseconds.
     */
    public long getTimeout() {
        return timeout;
    }

    /**
     * Gets the target's address.
     * @return
     *    a transport address.
     */
    public A getAddress() {
        return address;
    }
}
