/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.UserTarget;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.UsmUserEvent;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SNMPv3SecurityModel;
import org.snmp4j.security.SecretOctetString;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.security.UsmSecurityParameters;
import org.snmp4j.security.UsmSecurityStateReference;
import org.snmp4j.security.UsmTimeEntry;
import org.snmp4j.security.UsmTimeTable;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class USM
extends SNMPv3SecurityModel {
    public static final int RFC3414_11_2_MIN_PASSWORD_LENGTH = 8;
    private static final int MAXLEN_USMUSERNAME = 32;
    private static final LogAdapter logger = LogFactory.getLogger(USM.class);
    private final UsmUserTable userTable;
    private final UsmTimeTable timeTable;
    private boolean engineDiscoveryEnabled = true;
    private final SecurityProtocols securityProtocols;
    private final transient List<UsmUserListener> usmUserListeners = new CopyOnWriteArrayList<UsmUserListener>();

    public USM(SecurityProtocols securityProtocols, OctetString localEngineID, int engineBoots) {
        this(securityProtocols, localEngineID, engineBoots, CounterSupport.getInstance());
    }

    public USM(SecurityProtocols securityProtocols, OctetString localEngineID, int engineBoots, CounterSupport counterSupport) {
        this.localEngineID = localEngineID;
        this.timeTable = new UsmTimeTable(localEngineID, engineBoots);
        this.userTable = new UsmUserTable();
        this.securityProtocols = securityProtocols;
        this.counterSupport = counterSupport;
    }

    public USM() {
        this(SecurityProtocols.getInstance().addDefaultProtocols(), new OctetString(MPv3.createLocalEngineID(USM.randomID())), 0);
    }

    private static OctetString randomID() {
        Random random = new Random();
        byte[] randomID = new byte[8];
        random.nextBytes(randomID);
        return new SecretOctetString(randomID);
    }

    @Override
    public int getID() {
        return 3;
    }

    @Override
    public boolean supportsEngineIdDiscovery() {
        return true;
    }

    @Override
    public boolean hasAuthoritativeEngineID() {
        return true;
    }

    public void setLocalEngine(OctetString localEngineID, int engineBoots, int engineTime) {
        this.localEngineID = localEngineID;
        this.timeTable.setLocalTime(new UsmTimeEntry(localEngineID, engineBoots, engineTime));
    }

    public void setEngineBoots(int engineBoots) {
        this.timeTable.setEngineBoots(engineBoots);
    }

    public int getEngineBoots() {
        return this.timeTable.getEngineBoots();
    }

    public int getEngineTime() {
        return this.timeTable.getEngineTime();
    }

    @Override
    public SecurityParameters newSecurityParametersInstance() {
        return new UsmSecurityParameters(this.securityProtocols);
    }

    @Override
    public SecurityStateReference newSecurityStateReference() {
        return new UsmSecurityStateReference();
    }

    @Override
    public int generateRequestMessage(int snmpVersion, byte[] globalData, int maxMessageSize, int securityModel, byte[] securityEngineID, byte[] securityName, int securityLevel, BERInputStream scopedPDU, SecurityParameters securityParameters, BEROutputStream wholeMsg, TransportStateReference tmStateReference, SecurityStateReference securityStateReference) throws IOException {
        if (!(securityStateReference instanceof UsmSecurityStateReference)) {
            securityStateReference = new UsmSecurityStateReference();
        }
        UsmSecurityStateReference usmSecurityStateReference = (UsmSecurityStateReference)securityStateReference;
        if (tmStateReference.getTarget() instanceof UserTarget) {
            usmSecurityStateReference.applyTargetSecurityInformation(tmStateReference.getTarget());
        }
        return this.generateResponseMessage(snmpVersion, globalData, maxMessageSize, securityModel, securityEngineID, securityName, securityLevel, scopedPDU, usmSecurityStateReference, securityParameters, wholeMsg);
    }

    public boolean hasUser(OctetString engineID, OctetString securityName) {
        UsmUserEntry entry = this.userTable.getUser(engineID, securityName);
        if (entry == null) {
            entry = this.userTable.getUser(securityName);
            return entry != null || securityName.length() <= 0;
        }
        return true;
    }

    public UsmUserEntry getUser(OctetString engineID, OctetString securityName) {
        return this.getUser(engineID, securityName, UsmUser.LocalizationGrant.any);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UsmUserEntry getUser(OctetString engineID, OctetString securityName, UsmUser.LocalizationGrant requiredLocalizationGrant) {
        UsmUserEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("getUser(engineID=" + engineID.toHexString() + ",securityName=" + securityName.toString() + ",requiredLocalizationGrant=" + String.valueOf((Object)requiredLocalizationGrant) + ")")));
        }
        if ((entry = this.userTable.getUser(engineID, securityName)) == null) {
            entry = this.userTable.getUser(securityName);
            if (entry == null && securityName.length() > 0) {
                if (!logger.isDebugEnabled()) return null;
                logger.debug((Serializable)((Object)("USM.getUser - User '" + String.valueOf(securityName) + "' unknown")));
                return null;
            }
            if (entry == null || engineID == null || engineID.length() == 0) {
                entry = new UsmUserEntry();
                entry.setUserName(securityName);
                entry.setUsmUser(new UsmUser(securityName, null, null, null, null));
                return entry;
            }
            if (!entry.getUsmUser().isLocalizationGranted(requiredLocalizationGrant)) return null;
            return this.addLocalizedUsmUserEntry(engineID, securityName, entry);
        }
        if (engineID == null) return entry;
        if (engineID.length() <= 0) return entry;
        if (!entry.getUsmUser().isLocalizationGranted(requiredLocalizationGrant)) return entry;
        return this.addLocalizedUsmUserEntry(engineID, securityName, entry);
    }

    protected UsmUserEntry addLocalizedUsmUserEntry(OctetString engineID, OctetString securityName, UsmUserEntry entry) {
        OID authProtocolOID = entry.getUsmUser().getAuthenticationProtocol();
        OID privProtocolOID = entry.getUsmUser().getPrivacyProtocol();
        OctetString authPassword = entry.getUsmUser().getAuthenticationPassphrase();
        if (authProtocolOID != null && authPassword != null) {
            byte[] authKey = entry.getUsmUser().isLocalized() ? authPassword.getValue() : this.securityProtocols.passwordToKey(authProtocolOID, authPassword, engineID.getValue());
            byte[] privKey = null;
            OctetString privPassword = entry.getUsmUser().getPrivacyPassphrase();
            if (privProtocolOID != null && privPassword != null) {
                privKey = entry.getUsmUser().isLocalized() ? privPassword.getValue() : this.securityProtocols.passwordToKey(privProtocolOID, authProtocolOID, privPassword, engineID.getValue());
            } else {
                privProtocolOID = null;
            }
            entry = this.addLocalizedUser(engineID.getValue(), securityName, authProtocolOID, authKey, privProtocolOID, privKey);
        }
        return entry;
    }

    private static boolean isValidSecurityStateReference(SecurityStateReference securityStateReference) {
        return securityStateReference instanceof UsmSecurityStateReference && ((UsmSecurityStateReference)securityStateReference).getSecurityName() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int generateResponseMessage(int snmpVersion, byte[] globalData, int maxMessageSize, int securityModel, byte[] securityEngineID, byte[] securityName, int securityLevel, BERInputStream scopedPDU, SecurityStateReference securityStateReference, SecurityParameters securityParameters, BEROutputStream wholeMsg) throws IOException {
        byte[] wholeMessage;
        OctetString secEngineID;
        UsmSecurityParameters usmSecurityParams;
        block34: {
            UsmUserEntry user;
            OctetString secName;
            block36: {
                block35: {
                    block33: {
                        usmSecurityParams = (UsmSecurityParameters)securityParameters;
                        if (!securityStateReference.isCachedForResponseProcessing() && !USM.isValidSecurityStateReference(securityStateReference)) break block33;
                        UsmSecurityStateReference usmSecurityStateReference = (UsmSecurityStateReference)securityStateReference;
                        if (securityEngineID != null && securityEngineID.length > 0 || usmSecurityStateReference.getSecurityEngineID() == null) {
                            usmSecurityParams.setAuthoritativeEngineID(securityEngineID);
                            usmSecurityStateReference.setSecurityEngineID(securityEngineID);
                        } else {
                            usmSecurityParams.setAuthoritativeEngineID(usmSecurityStateReference.getSecurityEngineID());
                        }
                        if (usmSecurityStateReference.getSecurityName() == null) {
                            OctetString userName = new OctetString(securityName);
                            usmSecurityStateReference.setSecurityName(userName.getValue());
                            usmSecurityParams.setUserName(userName);
                            OctetString secName2 = this.getSecurityName(new OctetString(securityEngineID), userName);
                            if (secName2 != null && secName2.length() <= 32) {
                                usmSecurityParams.setUserName(secName2);
                            }
                        } else {
                            usmSecurityParams.setUserName(new OctetString(usmSecurityStateReference.getSecurityName()));
                        }
                        usmSecurityParams.setAuthenticationProtocol(usmSecurityStateReference.getAuthenticationProtocol());
                        usmSecurityParams.setPrivacyProtocol(usmSecurityStateReference.getPrivacyProtocol());
                        usmSecurityParams.setAuthenticationKey(usmSecurityStateReference.getAuthenticationKey());
                        usmSecurityParams.setPrivacyKey(usmSecurityStateReference.getPrivacyKey());
                        break block34;
                    }
                    secEngineID = new OctetString();
                    if (securityEngineID != null) {
                        secEngineID.setValue(securityEngineID);
                    }
                    secName = new OctetString(securityName);
                    user = null;
                    if (secEngineID.length() != 0) break block35;
                    if (this.isEngineDiscoveryEnabled()) {
                        if (this.hasUser(null, secName)) {
                            user = new UsmUserEntry();
                        }
                        break block36;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)"Engine ID unknown and discovery disabled"));
                        }
                        return 1410;
                    }
                }
                user = this.getUser(secEngineID, secName, UsmUser.LocalizationGrant.outgoing);
            }
            if (user == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Security name not found for engineID=" + secEngineID.toHexString() + ", securityName=" + secName.toHexString())));
                }
                return 1404;
            }
            AuthenticationProtocol auth = this.securityProtocols.getAuthenticationProtocol(user.getUsmUser().getAuthenticationProtocol());
            PrivacyProtocol priv = this.securityProtocols.getPrivacyProtocol(user.getUsmUser().getPrivacyProtocol());
            usmSecurityParams.setAuthenticationProtocol(auth);
            usmSecurityParams.setPrivacyProtocol(priv);
            usmSecurityParams.setAuthenticationKey(user.getAuthenticationKey());
            usmSecurityParams.setPrivacyKey(user.getPrivacyKey());
            usmSecurityParams.setUserName(user.getUsmUser().getSecurityName());
            usmSecurityParams.setAuthoritativeEngineID(secEngineID.getValue());
        }
        if (usmSecurityParams.getAuthoritativeEngineID().length > 32) {
            logger.error((Serializable)((Object)("Engine ID too long: " + usmSecurityParams.getAuthoritativeEngineID().length + ">32 for " + new OctetString(usmSecurityParams.getAuthoritativeEngineID()).toHexString())));
            return 1415;
        }
        if (securityName.length > 32) {
            logger.error((Serializable)((Object)("Security name too long: " + usmSecurityParams.getAuthoritativeEngineID().length + ">32 for " + new OctetString(securityName).toHexString())));
            return 1416;
        }
        if (securityLevel >= 2) {
            if (securityStateReference.isCachedForResponseProcessing()) {
                usmSecurityParams.setAuthoritativeEngineBoots(this.getEngineBoots());
                usmSecurityParams.setAuthoritativeEngineTime(this.getEngineTime());
            } else {
                secEngineID = new OctetString(securityEngineID);
                UsmTimeEntry entry = this.timeTable.getTime(secEngineID);
                if (entry == null) {
                    entry = new UsmTimeEntry(secEngineID, usmSecurityParams.getAuthoritativeEngineBoots(), usmSecurityParams.getAuthoritativeEngineTime());
                    this.timeTable.addEntry(entry);
                } else {
                    usmSecurityParams.setAuthoritativeEngineBoots(entry.getEngineBoots());
                    usmSecurityParams.setAuthoritativeEngineTime(entry.getLatestReceivedTime());
                }
            }
        }
        if (securityLevel >= 2 && usmSecurityParams.getAuthenticationProtocol() == null) {
            return 1403;
        }
        byte[] scopedPduBytes = USM.buildMessageBuffer(scopedPDU);
        if (securityLevel == 3) {
            if (usmSecurityParams.getPrivacyProtocol() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Unsupported security level (missing or unsupported privacy protocol): Security params are " + String.valueOf(usmSecurityParams))));
                }
                return 1403;
            }
            logger.debug((Serializable)((Object)"RFC3414 \u00a73.1.4.a Outgoing message needs to be encrypted"));
            DecryptParams decryptParams = new DecryptParams();
            try {
                byte[] encryptedScopedPdu = usmSecurityParams.getPrivacyProtocol().encrypt(scopedPduBytes, 0, scopedPduBytes.length, usmSecurityParams.getPrivacyKey(), usmSecurityParams.getAuthoritativeEngineBoots(), usmSecurityParams.getAuthoritativeEngineTime(), decryptParams);
                if (encryptedScopedPdu == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)"Encryption error"));
                    }
                    return 1405;
                }
                usmSecurityParams.setPrivacyParameters(new OctetString(decryptParams.array));
                OctetString encryptedString = new OctetString(encryptedScopedPdu);
                BEROutputStream os = new BEROutputStream(ByteBuffer.allocate(encryptedString.getBERLength()));
                encryptedString.encodeBER(os);
                scopedPduBytes = os.getBuffer().array();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Encryption error: " + e.getMessage())));
                }
                return 1405;
            }
        } else {
            logger.debug((Serializable)((Object)"RFC3414 \u00a73.1.4.b Outgoing message is not encrypted"));
            usmSecurityParams.setPrivacyParameters(new OctetString());
        }
        if (securityLevel >= 2) {
            AuthenticationProtocol authenticationProtocol = usmSecurityParams.getAuthenticationProtocol();
            byte[] blank = new byte[authenticationProtocol.getAuthenticationCodeLength()];
            usmSecurityParams.setAuthenticationParameters(new OctetString(blank));
            wholeMessage = USM.buildWholeMessage(new Integer32(snmpVersion), scopedPduBytes, globalData, usmSecurityParams);
            int authParamsPos = usmSecurityParams.getAuthParametersPosition() + usmSecurityParams.getSecurityParametersPosition();
            boolean authOK = usmSecurityParams.getAuthenticationProtocol().authenticate(usmSecurityParams.getAuthenticationKey(), wholeMessage, 0, wholeMessage.length, new ByteArrayWindow(wholeMessage, authParamsPos, authenticationProtocol.getAuthenticationCodeLength()));
            if (!authOK) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)"Outgoing message could not be authenticated"));
                }
                return 1407;
            }
        } else {
            usmSecurityParams.setAuthoritativeEngineBoots(0);
            usmSecurityParams.setAuthenticationParameters(new OctetString());
            usmSecurityParams.setAuthoritativeEngineTime(0);
            wholeMessage = USM.buildWholeMessage(new Integer32(snmpVersion), scopedPduBytes, globalData, usmSecurityParams);
        }
        ByteBuffer buf = ByteBuffer.wrap(wholeMessage).position(wholeMessage.length);
        wholeMsg.setBuffer(buf);
        return 0;
    }

    private OctetString getSecurityName(OctetString engineID, OctetString securityName) {
        if (securityName.length() == 0) {
            return securityName;
        }
        UsmUserEntry user = this.userTable.getUser(engineID, securityName);
        if (user != null) {
            return user.getUsmUser().getSecurityName();
        }
        if (this.isEngineDiscoveryEnabled() && (user = this.userTable.getUser(securityName)) != null) {
            return user.getUsmUser().getSecurityName();
        }
        return null;
    }

    private void updateCachedDataForReport(StatusInformation statusInformation, int securityLevel, OID reportID, UsmSecurityStateReference usmSecurityStateReference, byte[] securityName) {
        usmSecurityStateReference.setSecurityName(securityName);
        if (statusInformation != null) {
            CounterEvent event = new CounterEvent(this, reportID);
            this.fireIncrementCounter(event);
            if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                statusInformation.setSecurityLevel(new Integer32(1));
            } else {
                statusInformation.setSecurityLevel(new Integer32(securityLevel));
            }
            statusInformation.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
        }
    }

    @Override
    public int processIncomingMsg(int snmpVersion, int maxMessageSize, SecurityParameters securityParameters, SecurityModel securityModel, int securityLevel, BERInputStream wholeMsg, TransportStateReference tmStateReference, OctetString securityEngineID, OctetString securityName, BEROutputStream scopedPDU, Integer32 maxSizeResponseScopedPDU, SecurityStateReference securityStateReference, StatusInformation statusInfo) throws IOException {
        UsmSecurityParameters usmSecurityParameters = (UsmSecurityParameters)securityParameters;
        UsmSecurityStateReference usmSecurityStateReference = (UsmSecurityStateReference)securityStateReference;
        securityEngineID.setValue(usmSecurityParameters.getAuthoritativeEngineID());
        byte[] message = USM.buildMessageBuffer(wholeMsg);
        if (securityEngineID.length() == 0 || this.timeTable.checkEngineID(securityEngineID, this.isEngineDiscoveryEnabled(), usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime()) != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.3 Unknown engine ID: '" + securityEngineID.toHexString() + "'")));
            }
            securityEngineID.setValue(usmSecurityParameters.getAuthoritativeEngineID());
            securityName.setValue(usmSecurityParameters.getUserName().getValue());
            this.updateCachedDataForReport(statusInfo, securityLevel, SnmpConstants.usmStatsUnknownEngineIDs, usmSecurityStateReference, securityName.getValue());
            return 1410;
        }
        securityName.setValue(usmSecurityParameters.getUserName().getValue());
        int scopedPDUPosition = usmSecurityParameters.getScopedPduPosition();
        if (usmSecurityParameters.getUserName().length() > 0 || securityLevel > 1) {
            byte[] privKey;
            byte[] authKey;
            PrivacyProtocol priv;
            AuthenticationProtocol auth;
            if (usmSecurityStateReference.getSecurityName() != null && usmSecurityStateReference.getSecurityEngineID() != null) {
                if (!Arrays.equals(usmSecurityStateReference.getSecurityName(), securityName.getValue())) {
                    this.reportUnknownSecurityName(securityEngineID, securityName, securityLevel, statusInfo, usmSecurityStateReference);
                    return 1404;
                }
                auth = usmSecurityStateReference.getAuthenticationProtocol();
                priv = usmSecurityStateReference.getPrivacyProtocol();
                authKey = usmSecurityStateReference.getAuthenticationKey();
                privKey = usmSecurityStateReference.getPrivacyKey();
            } else {
                usmSecurityStateReference.setSecurityName(securityName.getValue());
                UsmUserEntry user = this.getUser(securityEngineID, securityName, UsmUser.LocalizationGrant.incoming);
                if (user == null) {
                    this.reportUnknownSecurityName(securityEngineID, securityName, securityLevel, statusInfo, usmSecurityStateReference);
                    return 1404;
                }
                auth = this.securityProtocols.getAuthenticationProtocol(user.getUsmUser().getAuthenticationProtocol());
                priv = this.securityProtocols.getPrivacyProtocol(user.getUsmUser().getPrivacyProtocol());
                authKey = user.getAuthenticationKey();
                privKey = user.getPrivacyKey();
                usmSecurityStateReference.setAuthenticationKey(user.getAuthenticationKey());
                usmSecurityStateReference.setPrivacyKey(user.getPrivacyKey());
                usmSecurityStateReference.setAuthenticationProtocol(auth);
                usmSecurityStateReference.setPrivacyProtocol(priv);
            }
            if (securityLevel >= 2 && auth == null || securityLevel >= 3 && priv == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.5 - Unsupported security level: " + securityLevel + " by user " + String.valueOf(securityName) + " authProtocol=" + String.valueOf(auth) + ", privProtocol=" + String.valueOf(priv))));
                }
                CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsUnsupportedSecLevels);
                this.fireIncrementCounter(event);
                if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                    statusInfo.setSecurityLevel(new Integer32(1));
                }
                statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                return 1403;
            }
            if (securityLevel >= 2) {
                if (statusInfo != null) {
                    int authParamsPos = usmSecurityParameters.getAuthParametersPosition() + usmSecurityParameters.getSecurityParametersPosition();
                    boolean authentic = auth.isAuthentic(authKey, message, 0, message.length, new ByteArrayWindow(message, authParamsPos, auth.getAuthenticationCodeLength()));
                    if (!authentic) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.6 Wrong digest -> authentication failure. Security parameters: " + usmSecurityParameters.getAuthenticationParameters().toHexString())));
                        }
                        CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsWrongDigests);
                        this.fireIncrementCounter(event);
                        if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                            statusInfo.setSecurityLevel(new Integer32(1));
                        }
                        statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                        return 1408;
                    }
                    int status = this.timeTable.checkTime(new UsmTimeEntry(securityEngineID, usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime()));
                    switch (status) {
                        case 1411: {
                            logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.7.a Not in time window; engineID='" + String.valueOf(securityEngineID) + "', engineBoots=" + usmSecurityParameters.getAuthoritativeEngineBoots() + ", engineTime=" + usmSecurityParameters.getAuthoritativeEngineTime())));
                            CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsNotInTimeWindows);
                            this.fireIncrementCounter(event);
                            statusInfo.setSecurityLevel(new Integer32(2));
                            statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                            return status;
                        }
                        case 1410: {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.7.b - Unknown engine ID: " + String.valueOf(securityEngineID))));
                            }
                            CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsUnknownEngineIDs);
                            this.fireIncrementCounter(event);
                            if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                                statusInfo.setSecurityLevel(new Integer32(1));
                            }
                            statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                            return status;
                        }
                    }
                }
                if (securityLevel >= 3) {
                    OctetString privParams = usmSecurityParameters.getPrivacyParameters();
                    DecryptParams decryptParams = new DecryptParams(privParams.getValue(), 0, privParams.length());
                    try {
                        int scopedPDUHeaderLength = message.length - scopedPDUPosition;
                        ByteBuffer bis = ByteBuffer.wrap(message, scopedPDUPosition, scopedPDUHeaderLength);
                        BERInputStream scopedPDUHeader = new BERInputStream(bis);
                        long headerStartingPosition = scopedPDUHeader.getPosition();
                        int scopedPDULength = BER.decodeHeader(scopedPDUHeader, new BER.MutableByte());
                        int scopedPDUPayloadPosition = scopedPDUPosition + (int)(scopedPDUHeader.getPosition() - headerStartingPosition);
                        scopedPDUHeader.close();
                        scopedPDUHeader = null;
                        byte[] scopedPduBytes = priv.decrypt(message, scopedPDUPayloadPosition, scopedPDULength, privKey, usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime(), decryptParams);
                        ByteBuffer buf = ByteBuffer.wrap(scopedPduBytes);
                        scopedPDU.setFilledBuffer(buf);
                    }
                    catch (Exception ex) {
                        logger.debug((Serializable)((Object)("RFC 3414 \u00a73.2.8 Decryption error: " + ex.getMessage())));
                        return 1406;
                    }
                } else {
                    int scopedPduLength = message.length - scopedPDUPosition;
                    ByteBuffer buf = ByteBuffer.wrap(message, scopedPDUPosition, scopedPduLength);
                    scopedPDU.setFilledBuffer(buf);
                }
            } else {
                int scopedPduLength = message.length - scopedPDUPosition;
                ByteBuffer buf = ByteBuffer.wrap(message, scopedPDUPosition, scopedPduLength);
                scopedPDU.setFilledBuffer(buf);
            }
        } else {
            int scopedPduLength = message.length - scopedPDUPosition;
            ByteBuffer buf = ByteBuffer.wrap(message, scopedPDUPosition, scopedPduLength);
            scopedPDU.setFilledBuffer(buf);
        }
        int maxSecParamsOverhead = usmSecurityParameters.getBERMaxLength(securityLevel);
        maxSizeResponseScopedPDU.setValue(maxMessageSize - maxSecParamsOverhead);
        usmSecurityStateReference.setSecurityName(securityName.getValue());
        return 0;
    }

    private void reportUnknownSecurityName(OctetString securityEngineID, OctetString securityName, int securityLevel, StatusInformation statusInfo, UsmSecurityStateReference usmSecurityStateReference) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.4 Unknown security name: " + securityName.toHexString() + " (" + String.valueOf(securityName) + ") for engine ID " + securityEngineID.toHexString())));
        }
        this.updateCachedDataForReport(statusInfo, securityLevel, SnmpConstants.usmStatsUnknownUserNames, usmSecurityStateReference, securityName.getValue());
    }

    protected void fireIncrementCounter(CounterEvent e) {
        this.getCounterSupport().fireIncrementCounter(e);
    }

    @Deprecated
    public void addUser(OctetString userName, UsmUser user) {
        this.addUser(user);
    }

    public void addUser(UsmUser user) {
        this.addUser(user, user.getLocalizationEngineID());
    }

    public UsmUserEntry addUsmUserEntry(UsmUserEntry usmUserEntry) {
        UsmUserEntry previousEntry = this.userTable.addUser(usmUserEntry);
        this.fireUsmUserChange(new UsmUserEvent(this, usmUserEntry, 1));
        return previousEntry;
    }

    @Deprecated
    public void addUser(OctetString userName, OctetString engineID, UsmUser user) {
        this.addUser(user, engineID);
    }

    public void addUser(UsmUser user, OctetString engineID) {
        OctetString userEngineID;
        byte[] authKey = null;
        byte[] privKey = null;
        UsmUser newUser = user;
        if (user.getSecurityName().length() > 32) {
            String txt = "User '" + String.valueOf(user.getSecurityName()) + "' not added because of its too long security name with length " + user.getSecurityName().length();
            logger.warn((Serializable)((Object)txt));
            throw new IllegalArgumentException(txt);
        }
        if (engineID != null && engineID.length() > 0 && (engineID.length() < 5 || engineID.length() > 32)) {
            String txt = "User '" + String.valueOf(user.getSecurityName()) + "' not added because of an engine ID of incorrect length " + engineID.length();
            logger.warn((Serializable)((Object)txt));
            throw new IllegalArgumentException(txt);
        }
        if (user.isLocalized()) {
            userEngineID = user.getLocalizationEngineID();
        } else {
            OctetString octetString = userEngineID = engineID == null ? new OctetString() : engineID;
            if (userEngineID.length() > 0) {
                newUser = user.localizeUser(userEngineID, null, null, this.getSecurityProtocols());
            }
        }
        if (newUser.getAuthenticationPassphrase() != null) {
            authKey = newUser.getAuthenticationPassphrase().getValue();
        }
        if (newUser.getPrivacyPassphrase() != null) {
            privKey = newUser.getPrivacyPassphrase().getValue();
        }
        UsmUserEntry entry = new UsmUserEntry(user.getSecurityName(), userEngineID, newUser);
        entry.setAuthenticationKey(authKey);
        entry.setPrivacyKey(privKey);
        this.addUsmUserEntry(entry);
    }

    public void updateUser(UsmUserEntry entry) {
        UsmUserEntry oldEntry = this.userTable.addUser(entry);
        if (oldEntry != null && entry.getStorageType() == null) {
            entry.setStorageType(oldEntry.getStorageType());
        }
        this.fireUsmUserChange(new UsmUserEvent(this, entry, oldEntry == null ? 1 : 3));
    }

    public void setUsers(UsmUser[] users) {
        if (users == null || users.length == 0) {
            this.userTable.clear();
        } else {
            ArrayList<UsmUserEntry> v = new ArrayList<UsmUserEntry>(users.length);
            for (UsmUser user : users) {
                UsmUserEntry entry = new UsmUserEntry(user.getSecurityName(), (UsmUser)user.clone());
                v.add(entry);
            }
            this.userTable.setUsers(v);
        }
    }

    public UsmUserTable getUserTable() {
        return this.userTable;
    }

    public UsmTimeTable getTimeTable() {
        return this.timeTable;
    }

    public List<UsmUser> removeAllUsers(OctetString userName, OctetString engineID) {
        List<UsmUserEntry> entries;
        if (this.userTable != null && !(entries = this.userTable.removeAllUsers(userName, engineID)).isEmpty()) {
            ArrayList<UsmUser> users = new ArrayList<UsmUser>();
            for (UsmUserEntry entry : entries) {
                users.add(entry.getUsmUser());
                this.fireUsmUserChange(new UsmUserEvent(this, entry, 2));
            }
            return users;
        }
        return Collections.emptyList();
    }

    public List<UsmUser> removeAllUsers(OctetString userName) {
        return this.removeAllUsers(userName, null);
    }

    @Deprecated
    public UsmUser removeUser(OctetString engineID, OctetString userName) {
        UsmUserEntry entry = this.userTable.removeUser(engineID, userName);
        if (entry != null) {
            this.fireUsmUserChange(new UsmUserEvent(this, entry, 2));
            return entry.getUsmUser();
        }
        return null;
    }

    public void removeAllUsers() {
        this.userTable.clear();
        this.fireUsmUserChange(new UsmUserEvent(this, null, 2));
    }

    public UsmUserEntry addLocalizedUser(byte[] engineID, OctetString userName, OID authProtocol, byte[] authKey, OID privProtocol, byte[] privKey) {
        UsmUserEntry newEntry = new UsmUserEntry(engineID, userName, authProtocol, authKey, privProtocol, privKey);
        this.userTable.addUser(newEntry);
        this.fireUsmUserChange(new UsmUserEvent(this, newEntry, 1));
        return newEntry;
    }

    public boolean isEngineDiscoveryEnabled() {
        return this.engineDiscoveryEnabled;
    }

    public void setEngineDiscoveryEnabled(boolean engineDiscoveryEnabled) {
        this.engineDiscoveryEnabled = engineDiscoveryEnabled;
    }

    public void removeUsmUserListener(UsmUserListener l) {
        this.usmUserListeners.remove(l);
    }

    public void addUsmUserListener(UsmUserListener l) {
        if (!this.usmUserListeners.contains(l)) {
            this.usmUserListeners.add(l);
        }
    }

    public void removeEngineTime(OctetString engineID) {
        this.timeTable.removeEntry(engineID);
    }

    protected void fireUsmUserChange(UsmUserEvent e) {
        for (UsmUserListener listener : this.usmUserListeners) {
            listener.usmUserChange(e);
        }
    }

    public SecurityProtocols getSecurityProtocols() {
        return this.securityProtocols;
    }
}

