/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.MOAccess;

public class MOAccessImpl
implements MOAccess {
    public static final short ACCESSIBLE_FOR_READ = 1;
    public static final short ACCESSIBLE_FOR_WRITE = 2;
    public static final short ACCESSIBLE_FOR_CREATE = 4;
    public static final short ACCESSIBLE_FOR_NOTIFY = 8;
    public static final short ACCESSIBLE_FOR_READ_ONLY = 9;
    public static final short ACCESSIBLE_FOR_READ_WRITE = 11;
    public static final short ACCESSIBLE_FOR_READ_CREATE = 15;
    public static final MOAccess ACCESS_READ_ONLY = new MOAccessImpl(9);
    public static final MOAccess ACCESS_FOR_NOTIFY = new MOAccessImpl(8);
    public static final MOAccess ACCESS_WRITE_ONLY = new MOAccessImpl(2);
    public static final MOAccess ACCESS_READ_WRITE = new MOAccessImpl(11);
    public static final MOAccess ACCESS_READ_CREATE = new MOAccessImpl(15);
    private short access = (short)9;

    public MOAccessImpl(int access) {
        this.access = (short)(access & 0xFFFF);
    }

    @Override
    public boolean isAccessibleForRead() {
        return (this.access & 1) > 0;
    }

    @Override
    public boolean isAccessibleForWrite() {
        return (this.access & 2) > 0;
    }

    @Override
    public boolean isAccessibleForNotify() {
        return (this.access & 8) > 0;
    }

    @Override
    public boolean isAccessibleForCreate() {
        return (this.access & 4) > 0;
    }

    public final short getAccess() {
        return this.access;
    }

    public static MOAccess getInstance(int moAccess) {
        switch (moAccess) {
            case 9: {
                return ACCESS_READ_ONLY;
            }
            case 15: {
                return ACCESS_READ_CREATE;
            }
            case 8: {
                return ACCESS_FOR_NOTIFY;
            }
            case 11: {
                return ACCESS_READ_WRITE;
            }
            case 2: {
                return ACCESS_WRITE_ONLY;
            }
        }
        return new MOAccessImpl(moAccess);
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (this.isAccessibleForRead()) {
            sb.append("|read");
        }
        if (this.isAccessibleForWrite()) {
            sb.append("|write");
        }
        if (this.isAccessibleForNotify()) {
            sb.append("|notify");
        }
        if (this.isAccessibleForCreate()) {
            sb.append("|create");
        }
        if (sb.length() > 0) {
            return sb.substring(1);
        }
        return "";
    }

    public String toString() {
        return "MOAccessImpl{" + this.asString() + "}";
    }
}

