/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.LinkedMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.snmp.SNMPv2TC;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOFactory
implements MOFactory,
LinkedMOFactory,
MOTableRowFactory<DefaultMOMutableRow2PC> {
    private Map<String, Map<String, TextualConvention<?>>> textualConventions = new HashMap();
    private Map<OID, Object> links;
    private static MOFactory instance;

    protected DefaultMOFactory() {
    }

    public static MOFactory getInstance() {
        if (instance == null) {
            instance = new DefaultMOFactory();
            DefaultMOFactory.addSNMPv2TCs(instance);
        }
        return instance;
    }

    public static void setInstance(MOFactory factory) {
        instance = factory;
    }

    public static void addSNMPv2TCs(MOFactory factory) {
        Collection<TextualConvention<?>> tcs = new SNMPv2TC().getTextualConventions();
        for (TextualConvention<?> tc : tcs) {
            factory.addTextualConvention(tc);
        }
    }

    protected Map<? extends String, ? extends Map<String, TextualConvention<?>>> getTextualConventions() {
        return this.textualConventions;
    }

    @Override
    public synchronized void addTextualConvention(TextualConvention<?> tc) {
        Map tcMap = this.textualConventions.computeIfAbsent(tc.getModuleName(), k -> new HashMap(10));
        tcMap.put(tc.getName(), tc);
    }

    @Override
    public synchronized void removeTextualConvention(TextualConvention<?> tc) {
        Map<String, TextualConvention<?>> tcMap = this.textualConventions.get(tc.getModuleName());
        if (tcMap != null) {
            tcMap.remove(tc.getName());
            if (tcMap.isEmpty()) {
                this.textualConventions.remove(tc.getModuleName());
            }
        }
    }

    @Override
    public synchronized <V extends Variable> TextualConvention<V> getTextualConvention(String moduleName, String name) {
        Map<String, TextualConvention<?>> tcMap = this.textualConventions.get(moduleName);
        if (tcMap != null) {
            return tcMap.get(name);
        }
        return null;
    }

    @Override
    public DefaultMOMutableRow2PC createRow(OID index2, Variable[] values2) throws UnsupportedOperationException {
        return new DefaultMOMutableRow2PC(index2, values2);
    }

    @Override
    public void freeRow(DefaultMOMutableRow2PC row) {
    }

    @Override
    public void setLink(OID oid, Object instrumentationHelperObject) {
        if (this.links == null) {
            this.initLinkMap();
        }
        this.links.put(oid, instrumentationHelperObject);
    }

    @Override
    public Object getLink(OID oid) {
        if (this.links != null) {
            OID searchOID = new OID(oid);
            Object result = null;
            while (searchOID.size() > 0 && (result = this.links.get(searchOID)) == null) {
                searchOID.trim(1);
            }
            return result;
        }
        return null;
    }

    protected synchronized void initLinkMap() {
        if (this.links == null) {
            this.links = new HashMap<OID, Object>();
        }
    }
}

