/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.Serializable;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.smi.OID;

public class AgentXRegion
extends DefaultMOScope
implements Comparable<AgentXRegion>,
Serializable {
    private static final long serialVersionUID = -6110407395132112108L;
    private boolean singleOID;
    private byte rangeSubID;

    public AgentXRegion(OID lowerBound, OID upperBound) {
        super(lowerBound, true, upperBound, false);
    }

    public AgentXRegion(AgentXRegion other) {
        super(other.getLowerBound(), other.isLowerIncluded(), other.getUpperBound(), other.isUpperIncluded());
        this.singleOID = other.singleOID;
        this.rangeSubID = other.rangeSubID;
    }

    public byte getRangeSubID() {
        return this.rangeSubID;
    }

    public boolean isSingleOID() {
        return this.singleOID;
    }

    public void setRangeSubID(byte rangeSubID) {
        this.rangeSubID = rangeSubID;
    }

    public void setSingleOID(boolean singleOID) {
        this.singleOID = singleOID;
    }

    public int getUpperBoundSubID() {
        if (this.rangeSubID != 0) {
            return this.upperBound.get(this.rangeSubID - 1);
        }
        return 0;
    }

    public boolean isRange() {
        return this.rangeSubID > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.lowerBound.compareTo(this.upperBound) >= 0;
    }

    public int getLowerBoundSubID() {
        if (this.rangeSubID != 0) {
            return this.lowerBound.get(this.rangeSubID - 1);
        }
        return 0;
    }

    @Override
    public int compareTo(AgentXRegion other) {
        int c = this.lowerBound.compareTo(other.lowerBound);
        if (c == 0 && (c = this.upperBound.compareTo(other.upperBound)) == 0) {
            c = this.rangeSubID - other.rangeSubID;
        }
        return c;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[lowerBound=" + String.valueOf(this.lowerBound) + ",lowerIncluded=" + this.lowerIncluded + ",upperBound=" + String.valueOf(this.upperBound) + ",upperIncluded=" + this.upperIncluded + ",rangeSubID=" + this.rangeSubID + ",upperBoundSubID=" + this.getUpperBoundSubID() + "]";
    }
}

