/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.util.Comparator;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.smi.OctetString;

public class MOScopeComparator
implements Comparator<MOScope> {
    @Override
    public int compare(MOScope o1, MOScope o2) {
        if (o1 == o2) {
            return 0;
        }
        int result = 0;
        result = o2 instanceof MOQuery ? MOScopeComparator.compareQueryWithScope(o1, (MOQuery)o2) : (o1 instanceof MOQuery ? -MOScopeComparator.compareQueryWithScope(o2, (MOQuery)o1) : (o2 instanceof MOContextScope ? MOScopeComparator.compareContextScope(o1, (MOContextScope)o2) : (o1 instanceof MOContextScope ? -MOScopeComparator.compareContextScope(o2, (MOContextScope)o1) : MOScopeComparator.compareScope(o1, o2))));
        return result;
    }

    private static int compareContextScope(MOScope scope, MOContextScope scope2) {
        if (scope == scope2) {
            return 0;
        }
        int result = MOScopeComparator.compareScope(scope, scope2);
        if (result == 0 && scope instanceof MOContextScope) {
            OctetString c1 = ((MOContextScope)scope).getContext();
            OctetString c2 = scope2.getContext();
            if (c1 != null && c2 != null) {
                result = c1.compareTo(c2);
            }
        }
        return result;
    }

    private static int compareScope(MOScope scope, MOScope scope2) {
        if (scope == scope2 || scope.equals(scope2)) {
            return 0;
        }
        int result = 0;
        if (scope.getUpperBound() == null) {
            result = 1;
            if (scope2.getUpperBound() == null && (result = scope.getLowerBound().compareTo(scope2.getLowerBound())) == 0) {
                result += scope.isLowerIncluded() ? -1 : 0;
                result += scope2.isLowerIncluded() ? 1 : 0;
            }
        } else {
            result = scope.getUpperBound().compareTo(scope2.getUpperBound());
            if (result == 0) {
                result += scope.isUpperIncluded() ? -1 : 0;
                if (!((result += scope2.isUpperIncluded() ? 1 : 0) != 0 || (result = scope.getUpperBound().compareTo(scope2.getLowerBound())) != 0 || scope.isUpperIncluded() && scope2.isLowerIncluded())) {
                    return -1;
                }
            }
        }
        return result;
    }

    private static int compareQueryWithScope(MOScope scope, MOQuery scope2) {
        int result = 0;
        if (scope.getUpperBound() == null) {
            return 1;
        }
        result = scope.getUpperBound().compareTo(scope2.getLowerBound());
        if (!(result != 0 || scope.isUpperIncluded() && scope2.isLowerIncluded())) {
            return -1;
        }
        if (result == 0 && scope instanceof MOContextScope) {
            OctetString c1 = ((MOContextScope)scope).getContext();
            OctetString c2 = scope2.getContext();
            if (c1 != null && c2 != null) {
                result = c1.compareTo(c2);
            }
        }
        return result;
    }

    public static boolean isQueryContextMatching(MOQuery a, MOScope b2) {
        OctetString ca = a.getContext();
        if (ca == null) {
            return true;
        }
        if (b2 instanceof MOContextScope) {
            OctetString cb = ((MOContextScope)b2).getContext();
            return ca.equals(cb);
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MOScopeComparator) {
            return this == obj;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

