/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.MutableMOScope;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class DefaultMOQuery
implements MOQuery {
    private final MOContextScope scope;
    private boolean writeAccessQuery;
    private Object source;

    public DefaultMOQuery(MOContextScope scope) {
        this.scope = scope;
    }

    public DefaultMOQuery(MOContextScope scope, boolean isWriteAccessIntended) {
        this(scope);
        this.writeAccessQuery = isWriteAccessIntended;
    }

    public DefaultMOQuery(MOContextScope scope, boolean isWriteAccessIntended, Object source) {
        this(scope, isWriteAccessIntended);
        this.source = source;
    }

    @Override
    public MOContextScope getScope() {
        return this.scope;
    }

    public Object getSource() {
        return this.source;
    }

    @Override
    public boolean matchesQuery(ManagedObject<?> managedObject) {
        return true;
    }

    @Override
    public void subtractScope(MOScope scope) {
        if (!(this.scope instanceof MutableMOScope)) {
            throw new UnsupportedOperationException();
        }
        ((MutableMOScope)((Object)this.scope)).subtractScope(scope);
    }

    public void setNewExclusiveLowerBound(OID newExclusiveLowerBound) {
        if (!(this.scope instanceof MutableMOScope)) {
            throw new UnsupportedOperationException("Scope is not mutable:" + this.scope.getClass().getName());
        }
        ((MutableMOScope)((Object)this.scope)).setLowerBound(newExclusiveLowerBound);
        ((MutableMOScope)((Object)this.scope)).setLowerIncluded(false);
    }

    @Override
    public boolean isEmpty() {
        return this.scope.isEmpty();
    }

    public String toString() {
        return this.getClass().getName() + "[" + String.valueOf(this.getScope().getContext()) + "]=" + String.valueOf(this.getScope().getLowerBound()) + "<" + (this.getScope().isLowerIncluded() ? "=" : "") + " x <" + (this.getScope().isUpperIncluded() ? "=" : "") + String.valueOf(this.getScope().getUpperBound());
    }

    @Override
    public boolean isWriteAccessQuery() {
        return this.writeAccessQuery;
    }

    @Override
    public OID getLowerBound() {
        return this.scope.getLowerBound();
    }

    @Override
    public OID getUpperBound() {
        return this.scope.getUpperBound();
    }

    @Override
    public boolean isLowerIncluded() {
        return this.scope.isLowerIncluded();
    }

    @Override
    public boolean isUpperIncluded() {
        return this.scope.isUpperIncluded();
    }

    @Override
    public boolean isCovered(MOScope other) {
        return this.scope.isCovered(other);
    }

    @Override
    public boolean isOverlapping(MOScope other) {
        return this.scope.isOverlapping(other);
    }

    @Override
    public boolean covers(OID oid) {
        return this.scope.covers(oid);
    }

    public MOScope clone() {
        try {
            return (MOScope)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OctetString getContext() {
        return this.scope.getContext();
    }
}

