/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.OutputStream;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.Cluster;
import jetbrains.exodus.vfs.ClusterIterator;
import jetbrains.exodus.vfs.ClusterKey;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;

class VfsAppendingStream
extends OutputStream {
    @NotNull
    private final VirtualFileSystem vfs;
    @NotNull
    private final Transaction txn;
    private final long fd;
    private final Store contents;
    private final Runnable clusterFlushTrigger;
    private byte[] outputCluster;
    private int position;
    private long currentClusterNumber;
    private boolean isOpen;

    VfsAppendingStream(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, @NotNull File file, @NotNull Runnable clusterFlushTrigger) {
        this.vfs = vfs;
        this.txn = txn;
        this.fd = file.getDescriptor();
        this.contents = vfs.getContents();
        this.clusterFlushTrigger = clusterFlushTrigger;
        this.outputCluster = null;
        ClusteringStrategy clusteringStrategy = vfs.getConfig().getClusteringStrategy();
        Pair<Cluster, Cluster> pairOfClusters = VfsAppendingStream.getTwoLastClusters(vfs, txn, file);
        Cluster prevCluster = pairOfClusters.getFirst();
        Cluster currentCluster = pairOfClusters.getSecond();
        int prevClusterSize = prevCluster == null ? 0 : prevCluster.getSize();
        int currentClusterSize = currentCluster == null ? 0 : currentCluster.getSize();
        int clusterSize = prevClusterSize == 0 ? clusteringStrategy.getFirstClusterSize() : clusteringStrategy.getNextClusterSize(prevClusterSize);
        long l = this.currentClusterNumber = currentCluster == null ? 0L : currentCluster.getClusterNumber();
        if (clusterSize <= currentClusterSize) {
            this.allocNextCluster(clusteringStrategy.getNextClusterSize(currentClusterSize));
        } else {
            this.outputCluster = new byte[clusterSize];
            if (currentClusterSize > 0) {
                currentCluster.copyTo(this.outputCluster);
            }
            this.position = currentClusterSize;
        }
        this.isOpen = true;
    }

    @Override
    public void write(int b2) {
        if (this.position == this.outputCluster.length) {
            this.flushCurrentCluster();
            this.allocNextCluster(this.vfs.getConfig().getClusteringStrategy().getNextClusterSize(this.position));
        }
        this.outputCluster[this.position++] = (byte)b2;
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.flushCurrentCluster();
        }
    }

    private void allocNextCluster(int size) {
        this.outputCluster = new byte[size];
        this.position = 0;
        ++this.currentClusterNumber;
    }

    private void flushCurrentCluster() {
        if (this.position > 0) {
            this.contents.put(this.txn, ClusterKey.toByteIterable(this.fd, this.currentClusterNumber), Cluster.writeCluster(this.outputCluster, this.vfs.getClusterConverter(), this.position, this.vfs.getConfig().getAccumulateChangesInRAM()));
            this.clusterFlushTrigger.run();
        }
    }

    private static Pair<Cluster, Cluster> getTwoLastClusters(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, @NotNull File file) {
        try (ClusterIterator iterator2 = new ClusterIterator(vfs, txn, file);){
            Cluster prevCluster = null;
            Cluster currCluster = null;
            while (iterator2.hasCluster()) {
                prevCluster = currCluster;
                currCluster = iterator2.getCurrent();
                iterator2.moveToNext();
            }
            Pair<Cluster, Cluster> pair = new Pair<Cluster, Cluster>(prevCluster, currCluster);
            return pair;
        }
    }
}

