/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import org.jetbrains.annotations.NotNull;

public final class HexUtil {
    private HexUtil() {
    }

    public static String byteArrayToString(@NotNull byte[] array) {
        return HexUtil.byteArrayToString(array, 0, array.length);
    }

    public static String byteArrayToString(@NotNull byte[] array, int off, int len) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            byte b2 = array[off + i];
            int digit = b2 >> 4 & 0xF;
            builder.append((char)(digit < 10 ? digit + 48 : digit - 10 + 97));
            digit = b2 & 0xF;
            builder.append((char)(digit < 10 ? digit + 48 : digit - 10 + 97));
        }
        return builder.toString();
    }

    public static byte[] stringToByteArray(@NotNull String str) {
        int strLen = str.length();
        if ((strLen & 1) == 1) {
            throw new IllegalArgumentException("Odd hex string length");
        }
        byte[] result = new byte[strLen / 2];
        int j = 0;
        for (int i = 0; i < strLen; i += 2) {
            result[j++] = (byte)(HexUtil.hexChar(str.charAt(i)) << 4 | HexUtil.hexChar(str.charAt(i + 1)));
        }
        return result;
    }

    private static int hexChar(char c) {
        int result = Character.digit(c, 16);
        if (result < 0 || result > 15) {
            throw new IllegalArgumentException("Bad hex digit: " + c);
        }
        return result;
    }
}

